/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;
import junit.runner.Version;
import junit.textui.ResultPrinter;

public class TestRunner
extends BaseTestRunner {
    private ResultPrinter fPrinter;
    public static final int SUCCESS_EXIT = 0;
    public static final int FAILURE_EXIT = 1;
    public static final int EXCEPTION_EXIT = 2;

    public static void main(String[] arguments) {
        TestRunner aTestRunner = new TestRunner();
        try {
            TestResult r = aTestRunner.start(arguments);
            if (!r.wasSuccessful()) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    public static void run(Class testClass) {
        TestRunner.run(new TestSuite(testClass));
    }

    public static TestResult run(Test test) {
        TestRunner runner = new TestRunner();
        return runner.doRun(test);
    }

    public static void runAndWait(Test suite) {
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.doRun(suite, true);
    }

    public TestRunner() {
        this(System.out);
    }

    public TestRunner(PrintStream writer) {
        this(new ResultPrinter(writer));
    }

    public TestRunner(ResultPrinter printer) {
        this.fPrinter = printer;
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    public TestResult doRun(Test test) {
        return this.doRun(test, false);
    }

    public TestResult doRun(Test suite, boolean wait) {
        TestResult result = this.createTestResult();
        result.addListener(this.fPrinter);
        long startTime = System.currentTimeMillis();
        suite.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.fPrinter.print(result, runTime);
        this.pause(wait);
        return result;
    }

    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    protected void pause(boolean wait) {
        if (!wait) {
            return;
        }
        this.fPrinter.printWaitPrompt();
        try {
            System.in.read();
        }
        catch (Exception exception) {}
    }

    protected void runFailed(String message) {
        System.err.println(message);
        System.exit(1);
    }

    protected TestResult runSingleMethod(String testCase, String method, boolean wait) throws Exception {
        Class testClass = this.loadSuiteClass(testCase);
        Test test = TestSuite.createTest(testClass, method);
        return this.doRun(test, wait);
    }

    public void setPrinter(ResultPrinter printer) {
        this.fPrinter = printer;
    }

    public TestResult start(String[] arguments) throws Exception {
        String testCase = "";
        String method = "";
        boolean wait = false;
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i].equals("-wait")) {
                wait = true;
            } else if (arguments[i].equals("-c")) {
                testCase = this.extractClassName(arguments[++i]);
            } else if (arguments[i].equals("-m")) {
                String arg = arguments[++i];
                int lastIndex = arg.lastIndexOf(46);
                testCase = arg.substring(0, lastIndex);
                method = arg.substring(lastIndex + 1);
            } else if (arguments[i].equals("-v")) {
                System.err.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
            } else {
                testCase = arguments[i];
            }
            ++i;
        }
        if (testCase.equals("")) {
            throw new Exception("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
        }
        try {
            if (!method.equals("")) {
                return this.runSingleMethod(testCase, method, wait);
            }
            Test suite = this.getTest(testCase);
            return this.doRun(suite, wait);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    public void testEnded(String testName) {
    }

    public void testFailed(int status, Test test, Throwable t) {
    }

    public void testStarted(String testName) {
    }
}

