/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.io.simulator.device.window;

import java.util.ResourceBundle;
import org.eclipse.soda.dk.core.Worker;
import org.eclipse.soda.dk.core.service.WorkerService;
import org.eclipse.soda.dk.generic.io.simulator.device.window.GenericIoSimulatorWindowListener;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenericIoSimulatorWindow {
    public static final int IN_LABEL = 5600;
    public static final int OUT_LABEL = 5601;
    public static ResourceBundle DefaultResourceBundle;
    Display display;
    Shell shell;
    GenericIoSimulatorWindowListener simulatorListener;
    Button[] inputPins;
    Button[] outputPins;
    Text[] inputChannels;
    Text[] outputChannels;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.generic.io.simulator.device.window.GenericIoSimulatorWindowResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public GenericIoSimulatorWindow(GenericIoSimulatorWindowListener ioAgent) {
        this.simulatorListener = ioAgent;
    }

    public void analogOutputUpdate(final int channel, final long value) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                Text field = GenericIoSimulatorWindow.this.outputChannels[channel];
                field.setText(Long.toString(value));
            }
        });
    }

    public void bind(Display display) {
        this.display = display;
    }

    public void close() {
        this.display.syncExec(new Runnable(){

            public void run() {
                if (GenericIoSimulatorWindow.this.shell != null && !GenericIoSimulatorWindow.this.shell.isDisposed()) {
                    GenericIoSimulatorWindow.this.shell.dispose();
                }
            }
        });
    }

    private Text createInputChannel(Composite comp, int channel, String name) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text field = (Text)event.widget;
                Integer channel = (Integer)field.getData();
                try {
                    long value = Long.parseLong(field.getText());
                    GenericIoSimulatorWindow.this.simulatorListener.notifyAnalogInputChanged(channel, value);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        };
        Label label = new Label(comp, 512);
        label.setText(Nls.format((String)name, (Object)new Integer(channel + 1)));
        Text field = new Text(comp, 4);
        field.setData((Object)new Integer(channel));
        GridData layoutData = new GridData();
        layoutData.widthHint = 100;
        field.setLayoutData((Object)layoutData);
        field.addModifyListener(listener);
        return field;
    }

    private Button createInputPin(Composite comp, int pin, String name) {
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                Integer pin = (Integer)button.getData();
                boolean state = button.getSelection();
                GenericIoSimulatorWindow.this.simulatorListener.notifyDigitalInputChanged(pin, state);
            }
        };
        Label label = new Label(comp, 512);
        label.setBackground(comp.getDisplay().getSystemColor(7));
        label.setText(Nls.format((String)name, (Object)new Integer(pin + 1)));
        Button button = new Button(comp, 32);
        button.setData((Object)new Integer(pin));
        button.addSelectionListener(listener);
        return button;
    }

    private Text createOutputChannel(Composite comp, int channel, String name) {
        Label label = new Label(comp, 512);
        label.setText(Nls.format((String)name, (Object)new Integer(channel + 1)));
        label.setBackground(comp.getDisplay().getSystemColor(7));
        Text field = new Text(comp, 12);
        field.setData((Object)new Integer(channel));
        field.setText(new Integer(0).toString());
        GridData layoutData = new GridData();
        layoutData.widthHint = 100;
        field.setLayoutData((Object)layoutData);
        return field;
    }

    private Button createOutputPin(Composite comp, int pin, String name) {
        Label label = new Label(comp, 512);
        label.setText(Nls.format((String)name, (Object)new Integer(pin + 1)));
        label.setBackground(comp.getDisplay().getSystemColor(7));
        Button button = new Button(comp, 32);
        button.setData((Object)new Integer(pin));
        button.setEnabled(false);
        return button;
    }

    private void createWidgets() {
        Composite comp = new Composite((Composite)this.shell, 0);
        GridLayout compGridlayout = new GridLayout();
        compGridlayout.numColumns = 4;
        comp.setLayout((Layout)compGridlayout);
        Composite inComp = new Composite(comp, 0);
        GridLayout inGridlayout = new GridLayout();
        inGridlayout.numColumns = 2;
        inComp.setLayout((Layout)inGridlayout);
        this.inputPins = new Button[this.simulatorListener.getNumberOfDigitalInputPins()];
        int pin = 0;
        while (pin < this.inputPins.length) {
            this.inputPins[pin] = this.createInputPin(inComp, pin, DefaultResourceBundle.getString(Integer.toString(5600)));
            ++pin;
        }
        Composite outComp = new Composite(comp, 0);
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = 2;
        outComp.setLayout((Layout)gridlayout);
        outComp.setBackground(comp.getDisplay().getSystemColor(7));
        this.outputPins = new Button[this.simulatorListener.getNumberOfDigitalOutputPins()];
        int pin2 = 0;
        while (pin2 < this.outputPins.length) {
            this.outputPins[pin2] = this.createOutputPin(outComp, pin2, DefaultResourceBundle.getString(Integer.toString(5601)));
            ++pin2;
        }
        Composite ainComp = new Composite(comp, 0);
        GridLayout ainGridlayout = new GridLayout();
        ainGridlayout.numColumns = 2;
        ainComp.setLayout((Layout)ainGridlayout);
        this.inputChannels = new Text[this.simulatorListener.getNumberOfAnalogInputChannels()];
        int channel = 0;
        while (channel < this.inputChannels.length) {
            this.inputChannels[channel] = this.createInputChannel(ainComp, channel, DefaultResourceBundle.getString(Integer.toString(5600)));
            ++channel;
        }
        Composite aoutComp = new Composite(comp, 0);
        GridLayout agridlayout = new GridLayout();
        agridlayout.numColumns = 2;
        aoutComp.setLayout((Layout)agridlayout);
        aoutComp.setBackground(comp.getDisplay().getSystemColor(7));
        this.outputChannels = new Text[this.simulatorListener.getNumberOfAnalogOutputChannels()];
        int channel2 = 0;
        while (channel2 < this.outputChannels.length) {
            this.outputChannels[channel2] = this.createOutputChannel(aoutComp, channel2, DefaultResourceBundle.getString(Integer.toString(5601)));
            ++channel2;
        }
    }

    protected void createWindow() {
        this.shell = new Shell(this.display, 48);
        FormLayout layout = new FormLayout();
        this.shell.setLayout((Layout)layout);
        this.shell.setText("IO Simulator: " + this.simulatorListener.getDeviceName());
        this.createWidgets();
        this.shell.pack();
        this.shell.open();
    }

    public void digitalOutputUpdate(final int channel, final boolean state) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                Button button = GenericIoSimulatorWindow.this.outputPins[channel];
                button.setSelection(state);
            }
        });
    }

    public void open() {
        Worker worker = new Worker("GenericIoSimulator-" + this.simulatorListener.getDeviceName(), new WorkerService(){

            public boolean doWork() throws InterruptedException {
                GenericIoSimulatorWindow.this.display.syncExec(GenericIoSimulatorWindow.this.runnableStartup());
                return false;
            }
        });
        worker.start();
    }

    Runnable runnableStartup() {
        return new Runnable(){

            public void run() {
                try {
                    GenericIoSimulatorWindow.this.createWindow();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
    }
}

