/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.rfid.inventory.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;

public abstract class GenericRfidInventoryProfile
extends RfidInventoryProfile {
    private GenericInventoryListener inventoryListener = new GenericInventoryListener(){

        public void receiveTagEvent(String tagId, Map tagData) {
            GenericRfidInventoryProfile.this.handleTagEvent(tagId, tagData);
        }
    };

    protected GenericRfidInventoryProfile() {
    }

    protected GenericRfidInventoryProfile(String capabilities, String status, String configuration, String metrics) {
    }

    public void activate() {
        super.activate();
        GenericInventoryListenerService adapter = (GenericInventoryListenerService)((Object)this.getGenericInventoryAdapter());
        if (adapter != null) {
            adapter.setInventoryListener(this.inventoryListener);
        }
    }

    protected boolean autonomousModeOff() {
        GenericInventoryService adapter = this.getGenericInventoryAdapter();
        if (adapter != null) {
            adapter.turnOffRfid();
            return true;
        }
        return false;
    }

    protected boolean autonomousModeOn() {
        GenericInventoryService adapter = this.getGenericInventoryAdapter();
        if (adapter != null) {
            adapter.turnOnRfid();
            return true;
        }
        return false;
    }

    public void deactivate() {
        super.deactivate();
        GenericInventoryListenerService adapter = (GenericInventoryListenerService)((Object)this.getGenericInventoryAdapter());
        if (adapter != null) {
            adapter.setInventoryListener(null);
        }
    }

    protected GenericInventoryService getGenericInventoryAdapter() {
        AdapterService adapter = this.getAdapter();
        if (adapter != null && adapter instanceof GenericInventoryService) {
            return (GenericInventoryService)adapter;
        }
        return null;
    }

    protected void handleTagEvent(String tagId, Map tagData) {
        this.log(4, "Receive tag: " + tagId);
        Hashtable<String, Map> tagReportMap = new Hashtable<String, Map>();
        Map readData = tagData != null ? tagData : new Hashtable();
        tagReportMap.put(tagId, readData);
        this.notifyTagRead(tagReportMap, GenericRfidInventoryProfile.getCurrentTimestamp());
    }
}

