/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.barcode.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;

public abstract class GenericBarcodeProfile
extends RfidInventoryProfile {
    private GenericBarcodeListener barcodeListener = new GenericBarcodeListener(){

        public void receiveBarcodeEvent(String barcode, Map barcodeData) {
            GenericBarcodeProfile.this.handleBarcodeEvent(barcode, barcodeData);
        }
    };

    protected GenericBarcodeProfile() {
    }

    protected GenericBarcodeProfile(String capabilities, String status, String configuration, String metrics) {
    }

    public void activate() {
        super.activate();
        GenericBarcodeListenerService adapter = (GenericBarcodeListenerService)((Object)this.getGenericBarcodeAdapter());
        if (adapter != null) {
            adapter.setBarcodeListener(this.barcodeListener);
        }
    }

    protected boolean autonomousModeOff() {
        GenericBarcodeService adapter = this.getGenericBarcodeAdapter();
        if (adapter != null) {
            adapter.turnOffBarcode();
            return true;
        }
        return false;
    }

    protected boolean autonomousModeOn() {
        GenericBarcodeService adapter = this.getGenericBarcodeAdapter();
        if (adapter != null) {
            adapter.turnOnBarcode();
            return true;
        }
        return false;
    }

    public void deactivate() {
        super.deactivate();
        GenericBarcodeListenerService adapter = (GenericBarcodeListenerService)((Object)this.getGenericBarcodeAdapter());
        if (adapter != null) {
            adapter.setBarcodeListener(null);
        }
    }

    protected GenericBarcodeService getGenericBarcodeAdapter() {
        AdapterService adapter = this.getAdapter();
        if (adapter != null && adapter instanceof GenericBarcodeService) {
            return (GenericBarcodeService)adapter;
        }
        return null;
    }

    protected void handleBarcodeEvent(String barcode, Map barcodeData) {
        this.log(4, "Receive barcode: " + barcode);
        Hashtable<String, Map> tagReportMap = new Hashtable<String, Map>();
        Map readData = barcodeData != null ? barcodeData : new Hashtable();
        tagReportMap.put(barcode, readData);
        this.notifyTagRead(tagReportMap, GenericBarcodeProfile.getCurrentTimestamp());
    }
}

