/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement.computed;

import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.measurement.DataMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class ControlsMeasurement
extends DataMeasurement
implements MultiplexSignalListener,
MultiplexMeasurementListener {
    protected static final int NULL_TYPE = 0;
    protected static final int STRING_TYPE = 1;
    protected static final int INT_TYPE = 2;
    protected static final int FLOATING_TYPE = 3;
    protected static final int OTHER_TYPE = 4;
    private ControlService[] controls;

    public ControlsMeasurement(String key, Object value, UnitsService units, TransformService transform, ControlService[] controls) {
        super(key, value, units, transform);
        this.setControls(controls);
    }

    public ControlService[] getControls() {
        return this.controls;
    }

    public double getDouble(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object != null) {
            return Double.parseDouble(String.valueOf(object));
        }
        return 0.0;
    }

    public long getLong(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object != null) {
            return Long.parseLong(String.valueOf(object));
        }
        return 0L;
    }

    public int getObjectType(Object object) {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return 2;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof String) {
            return 1;
        }
        if (object != null) {
            return 1;
        }
        return 0;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        this.setValue(channel, newValue, timestamp);
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.measurementChanged(source, timestamp, null, newValue, oldValue);
    }

    public void setControls(ControlService[] controls) {
        if (this.controls != controls) {
            SignalService signal;
            MeasurementService measurement;
            ControlService control;
            int i;
            if (this.controls != null) {
                i = 0;
                while (i < this.controls.length) {
                    control = controls[i];
                    if (control instanceof MeasurementService) {
                        measurement = (MeasurementService)control;
                        measurement.removeMeasurementListener((MeasurementListener)this);
                    }
                    if (control instanceof SignalService) {
                        signal = (SignalService)control;
                        signal.removeSignalListener((SignalListener)this);
                    }
                    ++i;
                }
            }
            this.controls = controls;
            if (this.controls != null) {
                i = 0;
                while (i < this.controls.length) {
                    control = controls[i];
                    if (control instanceof MeasurementService) {
                        measurement = (MeasurementService)control;
                        measurement.addMeasurementListener((MeasurementListener)this);
                    }
                    if (control instanceof SignalService) {
                        signal = (SignalService)control;
                        signal.addSignalListener((SignalListener)this);
                    }
                    ++i;
                }
            }
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
        this.setValue(channel, data, timestamp);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.setValue(data, timestamp);
    }
}

