/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;

public class Measurements
extends Measurement
implements MultiplexMeasurementListener {
    private MeasurementService[] measurements;

    public Measurements(String key, Object value, MeasurementService[] measurements) {
        super(key, value);
        this.setMeasurements(measurements);
        this.setValue(null, value, Measurements.getCurrentTimestamp());
        this.addInternalMeasurementListener();
    }

    public void addInternalMeasurementListener() {
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            measurements[i].addMeasurementListener((MeasurementListener)this);
            ++i;
        }
    }

    public void executeRead(ChannelService channel) {
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            measurements[i].executeRead(channel);
            ++i;
        }
        super.executeRead(channel);
    }

    public void executeWrite(ChannelService channel, Object value) {
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            measurements[i].executeWrite(channel, value);
            ++i;
        }
        super.executeWrite(channel, value);
    }

    public MeasurementService[] getMeasurements() {
        return this.measurements;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        MeasurementListener measurementListener = this.getMeasurementListener();
        if (measurementListener != null) {
            try {
                if (measurementListener instanceof MultiplexMeasurementListener || channel != null) {
                    ((MultiplexMeasurementListener)measurementListener).measurementChanged((MeasurementService)this, timestamp, channel, newValue, oldValue);
                } else {
                    measurementListener.measurementChanged((MeasurementService)this, timestamp, newValue, oldValue);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.measurementChanged(source, timestamp, null, newValue, oldValue);
    }

    public Object read(ChannelService channel, long timeout) throws RuntimeException {
        Object results = null;
        MeasurementService[] measurements = this.getMeasurements();
        int length = measurements.length;
        int i = 0;
        while (i < length) {
            results = measurements[i].read(channel, timeout);
            ++i;
        }
        return results;
    }

    protected void setMeasurements(MeasurementService[] measurements) {
        this.measurements = measurements;
    }

    public void setValue(ChannelService channel, Object value) {
        Object timestamp = Measurements.getCurrentTimestamp();
        super.setValue(channel, value, timestamp);
        MeasurementService[] measurements = this.getMeasurements();
        if (measurements != null) {
            int length = measurements.length;
            int i = 0;
            while (i < length) {
                measurements[i].setValue(channel, value);
                ++i;
            }
        }
    }
}

