/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.registry.bundle;

import org.eclipse.soda.dk.connection.bundle.ServiceBundle;
import org.eclipse.soda.dk.device.DeviceRegistry;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceRegistryService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class DeviceRegistryBundle
extends ServiceBundle
implements ServiceListener {
    public static final String[] SERVICE_NAMES = new String[]{DeviceRegistryService.SERVICE_NAME};

    protected void activate() {
        super.activate();
        BundleContext context = this.getBundleContext();
        StringBuffer filter = new StringBuffer(80);
        filter.append('(');
        filter.append("objectClass");
        filter.append('=');
        filter.append(DeviceService.SERVICE_NAME);
        filter.append(')');
        try {
            context.addServiceListener((ServiceListener)this, filter.toString());
        }
        catch (InvalidSyntaxException exception) {
            String message = exception.getMessage();
            this.log(1, message, exception);
        }
    }

    public Object createService() {
        DeviceRegistry deviceRegistry = new DeviceRegistry();
        deviceRegistry.start();
        return deviceRegistry;
    }

    protected void deactivate() {
        DeviceService device = this.getDevice();
        if (device != null) {
            device.exit();
        }
    }

    public DeviceService getDevice() {
        if (this.getService() instanceof DeviceService) {
            return (DeviceService)this.getService();
        }
        return null;
    }

    public String[] getExportedServiceNames() {
        return SERVICE_NAMES;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (serviceEvent.getType() == 1) {
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            DeviceService deviceService = (DeviceService)this.getBundleContext().getService(serviceReference);
            if (deviceService != null) {
                this.getDevice().put(deviceService.getKey(), (ControlService)deviceService);
            }
            this.getBundleContext().ungetService(serviceReference);
        }
    }
}

