/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.DeviceCommand;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class SimpleMessageCommand
extends DeviceCommand
implements ResponseListener {
    protected MessageService message;

    public SimpleMessageCommand(String key, MessageService message) {
        super(key);
        this.setMessage(message);
    }

    public void execute(ChannelService channel) {
        try {
            this.getDevice().send(channel, this.getMessage(), (ResponseListener)this);
            super.execute(channel);
        }
        catch (RuntimeException exception) {
            this.log(1, this.toString(), exception);
        }
    }

    public void execute(ChannelService channel, Object data) {
        if (data != null) {
            throw new IllegalArgumentException(String.valueOf(data));
        }
        this.execute(channel);
    }

    public MessageService getMessage() {
        return this.message;
    }

    public void noResponseReceived(TransportService transportService, ChannelService channel, Object timestamp, Object data) {
        this.fireErrorOccurred(timestamp, data);
    }

    public void responseReceived(TransportService transportService, ChannelService channel, Object timestamp, Object data) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireCommandExecuted(commandListener, timestamp, channel);
        }
    }

    public void setMessage(MessageService message) throws IllegalArgumentException {
        this.message = message;
        if (message == null) {
            throw new IllegalArgumentException("null");
        }
    }
}

