/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.signal;

import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.signal.TransformSignal;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class ParameterSignal
extends TransformSignal {
    private ParameterService parameter;

    public ParameterSignal(String key, MessageService message, TransformService transform, ParameterService parameter) {
        super(key, message, transform);
        this.setParameter(parameter);
    }

    public ParameterService getParameter() {
        return this.parameter;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.messageReceived(transportService, timestamp, null, message);
    }

    public void messageReceived(TransportService transportService, Object timestamp, ChannelService channel, MessageService message) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            try {
                MessageService myMessage = this.getMessage().matches(message);
                if (myMessage != null) {
                    this.fireSignalOccurred(signalListener, timestamp, channel, this.decode(myMessage.decodeMessage(message, this.getParameter())));
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void setParameter(ParameterService parameter) {
        this.parameter = parameter;
    }
}

