/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.device.NotificationController;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceControl;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.ConnectionTransportService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class Container
extends Control {
    public static final char TOPIC_DELIMITER = '/';
    public static final int NOTIFICATION_PRIORITY_DEFAULT = 5;
    protected static final int INITIALIZE_CONFIGURATION_RESOURCE = 3014;
    protected static final int[] DEVICE_STATE_RESOURCE_TABLE = new int[]{3000, 3001, 3002, 3003, 3004, 3005};
    protected static final int INITIALIZE_CONFIGURATION_MISCOMPARE_RESOURCE = 3015;
    protected static final int DEVICE_CREATED_STATE_RESOURCE = 3001;
    protected static final int INITIALIZE_CONFIGURATION_SAME_RESOURCE = 3016;
    protected static final int DEVICE_CHANGED_EXCEPTION_RESOURCE = 3006;
    protected static final int EXCEPTION_NO_TRANSPORT_RESOURCE = 3017;
    protected static final int DEVICE_DEAD_STATE_RESOURCE = 3000;
    protected static final int CHANNEL_CHANGED_EXCEPTION_RESOURCE = 3020;
    protected static final int RUN_EXCEPTION_RESOURCE = 3007;
    protected static final int DEVICE_ALIVE_STATE_RESOURCE = 3002;
    protected static final int INITIALIZE_READ_EXCEPTION_RESOURCE = 3008;
    protected static final int DEVICE_CONNECTED_STATE_RESOURCE = 3003;
    protected static final int INITIALIZE_WRITE_EXCEPTION_RESOURCE = 3009;
    protected static final int DEVICE_ACTIVE_STATE_RESOURCE = 3004;
    protected static final int SEND_EXCEPTION_RESOURCE = 3010;
    protected static final int DEVICE_STARTED_STATE_RESOURCE = 3005;
    protected static final int PROCESSING_UNABLE_TO_KEEP_UP_EXCEPTION_RESOURCE = 3011;
    protected static final int MESSAGE_RECEIVED_EXCEPTION_RESOURCE = 3012;
    protected static final int INITIALIZE_CONFIGURATION_EXCEPTION_RESOURCE = 3013;
    private Hashtable controls;
    private ConfigurationService configurationService = null;
    private int information = 0;
    private int state = 0;
    protected final Object stateChanged = new Object();
    private BundleContext bundleContext;
    private NotificationController notificationController = null;
    protected Measurement status = null;
    protected Measurement configuration = null;
    protected Measurement capabilities = null;
    protected Measurement metrics = null;
    protected long broadcastCommandCount = 0L;
    protected long broadcastMeasurementCount = 0L;
    protected long broadcastSignalCount = 0L;
    protected int logLevel = 0;
    protected int notificationPriority = -1;
    static /* synthetic */ Class class$0;

    protected Container() {
        this("");
    }

    protected Container(String key) {
        super(key);
        this.controls = new Hashtable(3);
    }

    public void activate() {
    }

    public void activate(ChannelService channel) {
        if (channel == null) {
            this.activate();
        }
    }

    public void addData(String topic, Dictionary data) {
        Bundle bundle;
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null && (bundle = bundleContext.getBundle()) != null) {
            if (data.get("bundle.symbolicName") == null) {
                data.put("bundle.symbolicName", bundle.getSymbolicName());
            }
            if (data.get("bundle") == null) {
                data.put("bundle", bundle);
            }
            if (data.get("bundle.id") == null) {
                data.put("bundle.id", Container.createNumber((long)bundle.getBundleId()));
            }
        }
    }

    protected void addQualifiedKeys(String id) {
        NotificationController notificationController = this.getNotificationController();
        if (notificationController != null) {
            notificationController.addQualifiedKeys(id);
        }
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        if (errorNumber == 3006) {
            return true;
        }
        return super.attemptRecoveryFromError(errorNumber, error);
    }

    public void broadcast(String topic, Dictionary data) {
        this.addData(topic, data);
        this.getNotificationService().broadcast(topic, data);
    }

    public void broadcastStatus() {
        this.broadcastStatus(Container.getCurrentTimestamp(), this.getState(), Integer.MIN_VALUE);
    }

    public void broadcastStatus(Object timestamp, int newState, int oldState) {
        NotificationController notificationService = this.getNotificationController();
        if (notificationService != null && this.status != null) {
            this.status.setValue(null, this.getStatusDictionary(newState, oldState), timestamp);
        }
    }

    protected void changeIds(String oldId, String newId) {
        if (oldId == null) {
            this.removeQualifiedKeys();
            this.addQualifiedKeys(newId);
        } else if (!oldId.equals(newId)) {
            this.removeQualifiedKeys();
            this.addQualifiedKeys(newId);
        }
    }

    public Map collectMetrics() {
        HashMap<String, Number> map = new HashMap<String, Number>(13);
        map.put("broadcastCommandCount", Container.createNumber((long)this.getBroadcastCommandCount()));
        map.put("broadcastMeasurementCount", Container.createNumber((long)this.getBroadcastMeasurementCount()));
        map.put("broadcastSignalCount", Container.createNumber((long)this.getBroadcastSignalCount()));
        return map;
    }

    public Filter createFilter(String filterString) throws InvalidSyntaxException {
        if (this.bundleContext != null) {
            return this.bundleContext.createFilter(filterString);
        }
        try {
            Class<?> filterClass = Class.forName("org.eclipse.osgi.framework.internal.core.FilterImpl");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> constructor = filterClass.getConstructor(classArray);
            return (Filter)constructor.newInstance(filterString);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof InvalidSyntaxException) {
                throw (InvalidSyntaxException)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void deactivate() {
    }

    public void deactivate(ChannelService channel) {
        if (channel == null) {
            this.deactivate();
        }
    }

    public Enumeration elements() {
        return this.getControls().elements();
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        this.fireErrorOccurred(timestamp, data);
    }

    public void exit() {
        if (this.getState() > 0) {
            try {
                this.stop();
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            try {
                this.setState(0);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            try {
                this.setNotificationService(null);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            try {
                this.setListenersNull();
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            try {
                this.setConfigurationInformation(null);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            try {
                if (this.controls != null) {
                    Enumeration enumeration = this.controls.elements();
                    while (enumeration.hasMoreElements()) {
                        Object control = enumeration.nextElement();
                        if (!(control instanceof DeviceControl)) continue;
                        ((DeviceControl)control).setDevice(null);
                    }
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            this.controls = null;
        }
    }

    public void fireContainerChanged(Object timestamp, int newState, int oldState) {
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
    }

    public ControlService get(String key) {
        Hashtable controls = this.getControls();
        if (controls == null) {
            return null;
        }
        return (ControlService)controls.get(key);
    }

    public long getBroadcastCommandCount() {
        return this.broadcastCommandCount;
    }

    public long getBroadcastMeasurementCount() {
        return this.broadcastMeasurementCount;
    }

    public long getBroadcastSignalCount() {
        return this.broadcastSignalCount;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public MeasurementService getCapabilities() {
        return this.capabilities;
    }

    public CommandService getCommand(String key) throws ClassCastException {
        return (CommandService)this.get(key);
    }

    public MeasurementService getConfiguration() {
        return this.configuration;
    }

    public Dictionary getConfigurationInformation() {
        if (this.configurationService == null) {
            return null;
        }
        return this.configurationService.getProperties();
    }

    public Object getConfigurationInformation(String propertyName) {
        return this.getString(propertyName, null);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    protected int getControlCapacity() {
        return 101;
    }

    public Hashtable getControls() {
        return this.controls;
    }

    public abstract String getDefaultKey();

    public short getDefaultStyle() {
        return 0;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 3014: 
            case 3016: {
                return 3;
            }
            case 3000: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: {
                return 4;
            }
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3010: 
            case 3011: 
            case 3012: 
            case 3013: {
                return 1;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public int getInformation() {
        return this.information;
    }

    public Object getLogDetails4() {
        TransportService transport = this.getTransport();
        ConnectionService connection = null;
        if (transport instanceof ConnectionTransportService) {
            connection = ((ConnectionTransportService)transport).getConnection();
        }
        return String.valueOf(connection);
    }

    public Object getLogDetails5() {
        return String.valueOf(this.getTransport());
    }

    public Object getLogDetails6() {
        return String.valueOf((Object)this);
    }

    public int getLogLevel() {
        if (this.logLevel == 0) {
            return super.getLogLevel();
        }
        return this.logLevel;
    }

    public MeasurementService getMeasurement(String key) throws ClassCastException {
        return (MeasurementService)this.get(key);
    }

    public Measurement getMetrics() {
        return this.metrics;
    }

    public NotificationController getNotificationController() {
        return this.notificationController;
    }

    public int getNotificationPriority() {
        if (this.notificationPriority == -1) {
            return this.getNotificationPriorityDefault();
        }
        return this.notificationPriority;
    }

    public int getNotificationPriorityDefault() {
        return 5;
    }

    public NotificationService getNotificationService() {
        if (this.notificationController != null) {
            return this.notificationController.getNotificationService();
        }
        return null;
    }

    public Number getNumberValue(Object data) {
        return EscConfiguration.numberValue((Object)data);
    }

    public String getPrefix() {
        return this.getString("prefix", "");
    }

    public long getReadTimeout() {
        return 1L;
    }

    public SignalService getSignal(String key) throws ClassCastException {
        return (SignalService)this.get(key);
    }

    public int getState() {
        return this.state;
    }

    public MeasurementService getStatus() {
        return this.status;
    }

    public Dictionary getStatusDictionary(int newState, int oldState) {
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        map.put("state", Container.createInteger((int)newState));
        if (oldState != Integer.MIN_VALUE) {
            map.put("state_old", Container.createInteger((int)oldState));
        }
        return map;
    }

    public String getString(String key, String defaultString) {
        if (this.configurationService != null) {
            return this.configurationService.getString(key, super.getString(key, defaultString));
        }
        return super.getString(key, defaultString);
    }

    public int getStyle() {
        return (short)this.getInformation();
    }

    public TransportService getTransport() {
        return null;
    }

    public Object handleMethodMetrics(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                Map map = this.collectMetrics();
                return map;
            }
        }
        return null;
    }

    public void initializeMeasurements() {
    }

    public void initializeMeasurements(ChannelService channel) {
        if (channel == null) {
            this.initializeMeasurements();
        }
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements() && this.isRunning()) {
            Object object = enumeration.nextElement();
            if (!(object instanceof MeasurementService)) continue;
            MeasurementService measurement = (MeasurementService)object;
            this.transportStartedWait();
            if (!this.isRunning()) {
                return;
            }
            Object value = measurement.getValue(channel);
            if (value != null) {
                try {
                    measurement.executeWrite(channel, value);
                }
                catch (RuntimeException exception) {
                    this.handleError(exception, 3009, measurement);
                }
            }
            try {
                measurement.executeRead(channel);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 3008, measurement);
            }
        }
    }

    public boolean isInitializeMeasurements() {
        return (this.getInformation() & 2) == 2;
    }

    public boolean isRunning() {
        return false;
    }

    public Enumeration keys() {
        return this.getControls().keys();
    }

    protected void load(ControlService control) {
        if (control instanceof DeviceService) {
            DeviceService device = (DeviceService)control;
            Enumeration enumeration = device.elements();
            while (enumeration.hasMoreElements()) {
                ControlService object = (ControlService)enumeration.nextElement();
                if (object == control) continue;
                this.put(object.getKey(), object);
            }
        }
    }

    public void notificationReceived(String externalKey, Dictionary data) {
    }

    public String prependPrefix(String topic) {
        return this.prependPrefix(this.getPrefix(), topic);
    }

    public String prependPrefix(String topicPrefix, String topic) {
        int topicPrefixLength;
        if (topicPrefix != null && (topicPrefixLength = topicPrefix.length()) > 0) {
            int topicLength = topic.length();
            char[] characters = new char[topicPrefixLength + topicLength + 1];
            System.arraycopy(topicPrefix.toCharArray(), 0, characters, 0, topicPrefixLength);
            characters[topicPrefixLength] = 47;
            System.arraycopy(topic.toCharArray(), 0, characters, topicPrefixLength + 1, topicLength);
            return new String(characters).intern();
        }
        return topic.intern();
    }

    public void put(ControlService control) {
        this.put(control.getKey(), control);
    }

    public void put(String key, ControlService control) {
        Hashtable controls = this.getControls();
        if (controls == null || controls.isEmpty()) {
            this.controls = new Hashtable(this.getControlCapacity());
        }
        this.getControls().put(key, control);
        this.load(control);
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        if (this.configurationService == null) {
            this.setConfigurationInformation(new Hashtable());
        }
        this.getConfigurationInformation().put(propertyName, value);
    }

    public void register(String topic) {
        this.getNotificationController().register(topic);
    }

    public void register(String[] topics) {
        this.getNotificationController().register(topics);
    }

    public void remove(String key) {
        this.getControls().remove(key);
    }

    public void removeListeners(DeviceService device) {
        if (device != null) {
            SignalListener signalListener;
            if (this instanceof DeviceListener) {
                device.removeDeviceListener((DeviceListener)this);
            }
            MeasurementListener measurementListener = this instanceof MeasurementListener ? (MeasurementListener)this : null;
            CommandListener commandListener = this instanceof CommandListener ? (CommandListener)this : null;
            SignalListener signalListener2 = signalListener = this instanceof SignalListener ? (SignalListener)this : null;
            if (measurementListener != null || commandListener != null || signalListener != null) {
                Enumeration enumeration = device.elements();
                while (enumeration.hasMoreElements()) {
                    Object control = enumeration.nextElement();
                    if (control instanceof MeasurementService && measurementListener != null) {
                        ((MeasurementService)control).removeMeasurementListener(measurementListener);
                    }
                    if (control instanceof CommandService && commandListener != null) {
                        ((CommandService)control).removeCommandListener(commandListener);
                    }
                    if (!(control instanceof SignalService) || signalListener == null) continue;
                    ((SignalService)control).removeSignalListener(signalListener);
                }
            }
        }
    }

    protected void removeQualifiedKeys() {
        NotificationController notificationController = this.getNotificationController();
        if (notificationController != null) {
            notificationController.removeQualifiedKeys();
        }
    }

    public void send(ChannelService channel, MessageService message) {
    }

    public void send(ChannelService channel, MessageService message, ResponseListener responseListener) {
    }

    public void send(MessageService message) {
    }

    public void send(MessageService message, ResponseListener responseListener) {
    }

    public void setBroadcastCommandCount(long broadcastCommandCount) {
        this.broadcastCommandCount = broadcastCommandCount;
    }

    public void setBroadcastMeasurementCount(long broadcastMeasurementCount) {
        this.broadcastMeasurementCount = broadcastMeasurementCount;
    }

    public void setBroadcastSignalCount(long broadcastSignalCount) {
        this.broadcastSignalCount = broadcastSignalCount;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        String oldId = this.configurationService != null ? this.configurationService.getString("prefix", null) : null;
        String newId = null;
        if (configurationInformation != null) {
            this.configurationService = new EscConfiguration(configurationInformation);
            newId = this.configurationService.getString("prefix", null);
            String key = this.configurationService.getString("key", this.getKey());
            this.setKey(key);
        } else {
            this.configurationService = null;
        }
        this.changeIds(oldId, newId);
        if (this.configuration != null) {
            this.configuration.setValue(null, configurationInformation, Container.getCurrentTimestamp());
        }
    }

    protected void setInformation(int information) {
        this.information = information;
    }

    public void setListenersNull() {
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setMetrics(Measurement metrics) {
        this.metrics = metrics;
    }

    public void setNotificationController(NotificationController notificationController) {
        if (this.notificationController != notificationController) {
            if (this.notificationController != null) {
                this.notificationController.exit();
            }
            this.notificationController = notificationController;
        }
    }

    public void setNotificationPriority(int notificationPriority) {
        this.notificationPriority = notificationPriority;
    }

    public void setNotificationService(NotificationService notificationService) {
        NotificationController notificationController = this.getNotificationController();
        if (this.notificationController != null) {
            notificationController.setNotificationService(notificationService);
            if (notificationService == null) {
                this.setNotificationController(null);
            } else {
                this.broadcastStatus();
            }
        } else if (notificationService != null) {
            String prefix = this.getString("prefix", null);
            if (prefix != null) {
                this.setNotificationController(new NotificationController(notificationService, this, prefix, this.getNotificationPriority()));
            } else {
                this.setNotificationController(new NotificationController(notificationService, this, null, this.getNotificationPriority()));
            }
            this.setupNotification();
            this.broadcastStatus();
        }
    }

    public void setState(int state) {
        this.setStateLocal(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setStateLocal(int state) {
        int oldState = this.state;
        Object currentTimestamp = null;
        if (state != oldState) {
            Object object = this.stateChanged;
            synchronized (object) {
                this.state = state;
                this.stateChanged.notifyAll();
            }
            if (state == 5) {
                try {
                    this.activate(null);
                }
                catch (RuntimeException exception) {
                    this.handleError(exception, 1);
                }
            } else if (oldState == 5) {
                try {
                    this.deactivate();
                    if (this.metrics != null) {
                        Map value = this.collectMetrics();
                        currentTimestamp = EscObject.getCurrentTimestamp();
                        this.metrics.setValue(null, value, currentTimestamp);
                    }
                }
                catch (RuntimeException exception) {
                    this.handleError(exception, 1);
                }
            }
            if (currentTimestamp == null) {
                currentTimestamp = EscObject.getCurrentTimestamp();
            }
            this.fireContainerChanged(currentTimestamp, state, oldState);
            this.report(null, DEVICE_STATE_RESOURCE_TABLE[state], Transport.STATE_STRINGS[oldState], this.getConfigurationInformation());
        } else {
            Object object = this.stateChanged;
            synchronized (object) {
                this.stateChanged.notifyAll();
            }
        }
    }

    public void setStyle(short style) {
        this.setInformation(this.getInformation() & 0xFFFF0000 | style);
    }

    public void setTransport(TransportService transport) {
    }

    public void setup() {
        String key = this.getKey();
        if (key == null || key.length() == 0) {
            this.setKey(this.getDefaultKey());
        }
        if (this.getInformation() == 0) {
            this.setInformation(this.getDefaultStyle());
        }
    }

    public void setupCustom() {
    }

    public void setupNotification() {
    }

    public void setupNotificationCustom() {
    }

    public void start() {
        this.setup();
        this.setupCustom();
        this.setStateLocal(2);
    }

    public void startupCommands() {
    }

    public void startupCommands(ChannelService channel) {
        Hashtable controls;
        ControlService controlPoll;
        ControlService controlStart;
        if (channel == null) {
            this.startupCommands();
        }
        if ((controlStart = this.get("start")) instanceof CommandService) {
            this.transportStartedWait();
            if (!this.isRunning()) {
                return;
            }
            try {
                ((CommandService)controlStart).execute(null);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 3013, controlStart);
            }
        }
        if ((controlPoll = this.get("poll")) instanceof CommandService) {
            this.transportStartedWait();
            if (!this.isRunning()) {
                return;
            }
            try {
                ((CommandService)controlPoll).execute(null, (Object)Boolean.TRUE);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 3013, controlPoll);
            }
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.isInitializeMeasurements()) {
            this.initializeMeasurements(channel);
        }
        if ((controls = this.getControls()) != null) {
            TransportService transport = this.getTransport();
            boolean transportMultiplex = transport != null ? transport.isMultiplexing() : false;
            StringBuffer buffer = new StringBuffer(256);
            buffer.append(this.getSimpleClassName().toLowerCase());
            buffer.append('.');
            int saveLength = buffer.length();
            Iterator iterator = controls.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = String.valueOf(entry.getKey());
                String ckey = this.validConfigurationId(key);
                ControlService control = (ControlService)entry.getValue();
                if (control == null) continue;
                buffer.append(ckey);
                Object value = this.getObject(buffer.toString(), null);
                buffer.setLength(saveLength);
                if (value == null && !key.equals(ckey)) {
                    buffer.append(key);
                    value = this.getObject(buffer.toString(), null);
                    buffer.setLength(saveLength);
                }
                if (value == null || value.toString().length() <= 0) continue;
                this.transportStartedWait();
                if (!this.isRunning()) {
                    return;
                }
                if (control instanceof MeasurementService) {
                    MeasurementService measurement = (MeasurementService)control;
                    try {
                        if (channel == null && !transportMultiplex) {
                            Object measurementValue = measurement.read(channel, this.getReadTimeout());
                            if (value.equals(measurementValue)) {
                                this.report(null, 3016, measurement, value);
                                continue;
                            }
                            measurement.executeWrite(channel, value);
                            this.sleep(200L);
                            Object newMeasurementValue = measurement.read(channel, this.getReadTimeout());
                            if (this.equalsValue(value, newMeasurementValue)) {
                                this.report(null, 3014, measurement, value, measurementValue);
                                continue;
                            }
                            this.report(null, 3015, measurement, value, newMeasurementValue);
                            continue;
                        }
                        measurement.executeWrite(channel, value);
                    }
                    catch (RuntimeException exception) {
                        this.report(exception, 3013, measurement);
                    }
                    continue;
                }
                if (control instanceof CommandService) {
                    CommandService command = (CommandService)control;
                    try {
                        command.execute(channel, value);
                        this.report(null, 3014, command, value, null);
                    }
                    catch (RuntimeException exception) {
                        this.report(exception, 3013, command, value, null);
                    }
                    continue;
                }
                if (!(control instanceof SignalService)) continue;
                SignalService signal = (SignalService)control;
                try {
                    signal.trigger(channel, value);
                    this.handleError(null, 3014, new Object[]{signal, value});
                }
                catch (RuntimeException exception) {
                    this.handleError(exception, 3013, signal);
                }
            }
        }
    }

    public void stop() {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        buffer.append('=');
        buffer.append(Transport.STATE_STRINGS[this.getState()]);
        this.toStringInfo(buffer);
        return buffer.toString();
    }

    public void toStringInfo(StringBuffer buffer) {
        Dictionary configuration = this.getConfigurationInformation();
        if (configuration != null) {
            Object value = configuration.get("id");
            if (value != null) {
                buffer.append(',');
                buffer.append("id");
                buffer.append('=');
                buffer.append(value);
            } else {
                buffer.append(configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transportStartedWait() {
        TransportService transport = this.getTransport();
        if (transport != null) {
            while (transport != null && transport.getState() != 5 && this.isRunning()) {
                Object object = this.stateChanged;
                synchronized (object) {
                    try {
                        this.stateChanged.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                transport = this.getTransport();
            }
        }
    }

    public void unregister(NotificationListener pubSubListener) {
        this.getNotificationService().unregister(pubSubListener);
    }

    public void unsubscribe() {
        NotificationController notificationController = this.getNotificationController();
        if (notificationController != null) {
            notificationController.unregister();
        }
    }

    public void updateBroadcastCommandCount() {
        ++this.broadcastCommandCount;
    }

    public void updateBroadcastMeasurementCount() {
        ++this.broadcastMeasurementCount;
    }

    public void updateBroadcastSignalCount() {
        ++this.broadcastSignalCount;
    }

    public String validConfigurationId(String name) {
        int index = name.lastIndexOf(47);
        if (index < 0) {
            return name;
        }
        return name.substring(index + 1);
    }
}

