/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.command.service.MultiplexCommandListener;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;

public class CommandListeners
extends EscObject
implements MultiplexCommandListener {
    private CommandListener[] objects;

    public CommandListeners(CommandListener currentObject, CommandListener newObject) {
        if (currentObject instanceof CommandListeners) {
            CommandListeners currentMulticaster = (CommandListeners)currentObject;
            CommandListener[] oldList = currentMulticaster.getObjects();
            this.objects = new CommandListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new CommandListener[2];
            this.objects[0] = currentObject;
            this.objects[1] = newObject;
        }
    }

    public CommandListeners(CommandListener[] objects) {
        this.setObjects(objects);
    }

    public static CommandListener add(CommandListener currentObject, CommandListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new CommandListeners(currentObject, newObject);
    }

    public static CommandListener remove(CommandListener currentObject, CommandListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof CommandListeners) {
            return ((CommandListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public void commandExecuted(CommandService source, Object timestamp, ChannelService channel, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                CommandListener listener = this.objects[i];
                if (listener instanceof MultiplexCommandListener || channel != null) {
                    ((MultiplexCommandListener)listener).commandExecuted(source, timestamp, channel, data);
                } else {
                    listener.commandExecuted(source, timestamp, data);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        this.commandExecuted(source, timestamp, null, data);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].errorOccurred(source, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public CommandListener[] getObjects() {
        return this.objects;
    }

    protected CommandListener remove(CommandListener removeHandler) {
        CommandListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        CommandListener[] newList = new CommandListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new CommandListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(CommandListener[] objects) {
        this.objects = objects;
    }
}

