/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.command;

import org.eclipse.soda.dk.command.CommandListeners;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.command.service.MultiplexCommandListener;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Command
extends Control
implements CommandService,
MultiplexSignalListener,
MultiplexMeasurementListener {
    private transient CommandListener commandListener;

    public Command(String key) {
        super(key);
    }

    public synchronized void addCommandListener(CommandListener commandListener) {
        this.setCommandListener(CommandListeners.add(this.getCommandListener(), commandListener));
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(ChannelService channel) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireCommandExecuted(commandListener, Command.getCurrentTimestamp(), channel);
        }
    }

    public void execute(ChannelService channel, Object data) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireCommandExecuted(commandListener, EscObject.getCurrentTimestamp(), channel, data);
        }
    }

    public void execute(Object data) {
        this.execute(null, data);
    }

    public void fireCommandExecuted(CommandListener commandListener, Object timestamp) {
        this.fireCommandExecuted(commandListener, timestamp, null);
    }

    public void fireCommandExecuted(CommandListener commandListener, Object timestamp, ChannelService channel) {
        try {
            if (commandListener instanceof MultiplexCommandListener || channel != null) {
                ((MultiplexCommandListener)commandListener).commandExecuted((CommandService)this, timestamp, channel, null);
            } else {
                commandListener.commandExecuted((CommandService)this, timestamp, null);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 1);
        }
    }

    public void fireCommandExecuted(CommandListener commandListener, Object timestamp, ChannelService channel, Object data) {
        try {
            if (commandListener instanceof MultiplexCommandListener || channel != null) {
                ((MultiplexCommandListener)commandListener).commandExecuted((CommandService)this, timestamp, channel, data);
            } else {
                commandListener.commandExecuted((CommandService)this, timestamp, data);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 1);
        }
    }

    public void fireCommandExecuted(CommandListener commandListener, Object timestamp, Object data) {
        this.fireCommandExecuted(commandListener, timestamp, null, data);
    }

    protected void fireErrorOccurred(CommandListener commandListener, Object timestamp, Object data) {
        try {
            commandListener.errorOccurred((Object)this, timestamp, data);
        }
        catch (RuntimeException exception) {
            this.log(exception, 1);
        }
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireErrorOccurred(commandListener, Command.getCurrentTimestamp(), data);
        }
    }

    public CommandListener getCommandListener() {
        return this.commandListener;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        this.execute(null, newValue);
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.measurementChanged(source, timestamp, null, newValue, oldValue);
    }

    public synchronized void removeCommandListener(CommandListener commandListener) {
        this.setCommandListener(CommandListeners.remove(this.getCommandListener(), commandListener));
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        super.reportError(errorNumber, error, errorObjects);
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            this.fireErrorOccurred(commandListener, Command.getCurrentTimestamp(), error);
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
        this.execute(channel);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.signalOccurred(source, timestamp, null, data);
    }
}

