/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.wire;

import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.command.service.MultiplexCommandListener;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;

public class Wire
extends Control
implements MultiplexMeasurementListener,
MultiplexCommandListener,
MultiplexSignalListener {
    private ControlService source;
    private ControlService target;
    private TransformService transform;

    public Wire(String key, ControlService source, ControlService target, TransformService transform) {
        super(key);
        this.setSource(source);
        this.setTarget(target);
        this.transform = transform;
    }

    public void addSourceListener(ControlService source) {
        if (source instanceof SignalService) {
            ((SignalService)source).addSignalListener((SignalListener)this);
        }
        if (source instanceof MeasurementService) {
            ((MeasurementService)source).addMeasurementListener((MeasurementListener)this);
        }
        if (source instanceof CommandService) {
            ((CommandService)source).addCommandListener((CommandListener)this);
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, ChannelService channel, Object data) {
        this.execute(channel, data);
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        this.execute(null, data);
    }

    public void execute(ChannelService channel, Object data) {
        ControlService target = this.getTarget();
        if (target instanceof CommandService) {
            if (data == null) {
                ((CommandService)target).execute(channel);
            } else {
                ((CommandService)target).execute(channel, data);
            }
        } else if (target instanceof SignalService) {
            ((SignalService)target).trigger(channel, data);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void execute(Object data) {
        this.execute(null, data);
    }

    public ControlService getSource() {
        return this.source;
    }

    public ControlService getTarget() {
        return this.target;
    }

    public TransformService getTransform() {
        return this.transform;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        this.execute(channel, source);
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.execute(null, source);
    }

    protected void setSource(ControlService source) {
        this.source = source;
        this.addSourceListener(source);
    }

    protected void setTarget(ControlService target) {
        this.target = target;
    }

    public void setTransform(TransformService transform) {
        this.transform = transform;
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
        this.execute(channel, data);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.execute(null, data);
    }
}

