/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.signal;

import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class Signals
extends Signal
implements MultiplexSignalListener {
    private SignalService[] signals;

    public Signals(String key, SignalService[] signals) {
        super(key);
        this.setSignals(signals);
        this.addInternalSignalListener();
    }

    protected void addInternalSignalListener() {
        int length = this.signals.length;
        int i = 0;
        while (i < length) {
            this.signals[i].addSignalListener((SignalListener)this);
            ++i;
        }
    }

    public SignalService[] getSignals() {
        return this.signals;
    }

    protected void removeInternalSignalListener() {
        int length = this.signals.length;
        int i = 0;
        while (i < length) {
            this.signals[i].removeSignalListener((SignalListener)this);
            ++i;
        }
    }

    protected void setSignals(SignalService[] signals) {
        this.signals = signals;
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            try {
                if (channel == null || signalListener instanceof MultiplexSignalListener) {
                    ((MultiplexSignalListener)signalListener).signalOccurred((SignalService)this, timestamp, channel, data);
                } else {
                    signalListener.signalOccurred((SignalService)this, timestamp, data);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.signalOccurred(source, timestamp, null, data);
    }

    public void trigger(ChannelService channel) {
        int length = this.signals.length;
        int i = 0;
        while (i < length) {
            this.signals[i].trigger(channel);
            ++i;
        }
        super.trigger(channel);
    }

    public void trigger(ChannelService channel, Object object) {
        int length = this.signals.length;
        int i = 0;
        while (i < length) {
            this.signals[i].trigger(channel, object);
            ++i;
        }
        super.trigger(channel, object);
    }
}

