/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.MessageHandler;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.message.Messages;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.MessageListeners;
import org.eclipse.soda.dk.transport.service.MessageListener;
import org.eclipse.soda.dk.transport.service.MultiplexMessageListener;
import org.eclipse.soda.dk.transport.service.MultiplexTransportListener;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class TransportDevice
extends Device
implements TransportListener,
MultiplexTransportListener {
    private TransportService transport;
    private Map messageListeners;

    protected TransportDevice() {
    }

    protected TransportDevice(String capabilities, String status, String configuration, String metrics) {
        super(capabilities, status, configuration, metrics);
    }

    protected TransportDevice(String capabilities, String status, String configuration, String metrics, String channels, String channelChanged, String openChannel, String closeChannel) {
        super(capabilities, status, configuration, metrics, channels, channelChanged, openChannel, closeChannel);
    }

    public void activate() {
        Map channels;
        super.activate();
        TransportService transport = this.getTransport();
        if (transport != null && (channels = transport.getChannels()) != null) {
            this.getChannels().setValue(null, new HashMap(channels));
        }
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        ControlService control = this.get("error");
        if (control != null) {
            if (control instanceof CommandService) {
                ((CommandService)control).execute(null, source);
            }
            if (control instanceof SignalService) {
                ((SignalService)control).trigger(null, source);
            }
        }
        super.errorOccurred(source, timestamp, data);
    }

    public void exit() {
        super.exit();
        this.messageListeners = null;
        this.setTransport(null);
    }

    public abstract TransportService getDefaultTransport();

    public InterestService getInterest() {
        return null;
    }

    public Map getMessageListeners() {
        return this.messageListeners;
    }

    public TransportService getTransport() {
        return this.transport;
    }

    protected void load(ControlService control) {
        super.load(control);
        if (control instanceof MessageHandler) {
            MessageService messages = ((MessageHandler)control).getMessage();
            this.registerMessageHandler(messages, (MessageHandler)control);
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, ChannelService channel, MessageService message) {
        Object key = this.getMessageKey(message);
        if (key != null) {
            MessageListener messageListener = (MessageListener)this.getMessageListeners().get(key);
            if (messageListener instanceof MultiplexMessageListener) {
                try {
                    ((MultiplexMessageListener)messageListener).messageReceived(transportService, timestamp, channel, message);
                }
                catch (RuntimeException exception) {
                    this.handleError(exception, 1);
                }
            } else if (messageListener != null) {
                try {
                    if (channel != null) {
                        ((MultiplexMessageListener)messageListener).messageReceived(transportService, timestamp, channel, message);
                    } else {
                        messageListener.messageReceived(transportService, timestamp, message);
                    }
                }
                catch (RuntimeException exception) {
                    this.handleError(exception, 1);
                }
            }
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.messageReceived(transportService, timestamp, null, message);
    }

    public void register(TransportService transport) {
        if (transport != null) {
            if (this.messageListeners == null) {
                this.messageListeners = new HashMap(this.getMessageCapacity());
            }
            transport.addTransportListener((TransportListener)this);
        }
    }

    public void registerMessageHandler(MessageService message, MessageHandler value) {
        if (message instanceof Messages) {
            MessageService[] messages = ((Messages)message).getMessages();
            int j = 0;
            while (j < messages.length) {
                this.registerMessageHandler(messages[j], value);
                ++j;
            }
        } else {
            Object key = this.getMessageKey(message);
            if (key != null) {
                if (this.messageListeners == null) {
                    this.messageListeners = new HashMap(this.getMessageCapacity());
                }
                MessageListener messageListener = (MessageListener)this.messageListeners.get(key);
                this.messageListeners.put(key, MessageListeners.add((MessageListener)messageListener, (MessageListener)value));
            } else {
                throw new IllegalArgumentException(String.valueOf(message));
            }
        }
    }

    public void registerMessageHandler(MessageService[] messages, MessageHandler value) {
        int length = messages.length;
        int i = 0;
        while (i < length) {
            this.registerMessageHandler(messages[i], value);
            ++i;
        }
    }

    public void send(ChannelService channel, MessageService message) {
        if (channel == null) {
            this.send(message);
        } else {
            TransportService transport = this.getTransport();
            if (transport != null) {
                transport.send(channel, message);
            } else {
                throw new RuntimeException(this.getResource(3017));
            }
        }
    }

    public void send(ChannelService channel, MessageService message, ResponseListener responseListener) {
        if (channel == null) {
            this.send(message, responseListener);
        } else {
            TransportService transport = this.getTransport();
            if (transport != null) {
                transport.send(channel, message, responseListener);
            } else {
                throw new RuntimeException(this.getResource(3017));
            }
        }
    }

    public void send(MessageService message) throws RuntimeException {
        TransportService transport = this.getTransport();
        if (transport == null) {
            throw new RuntimeException(this.getResource(3017));
        }
        transport.send(message);
    }

    public void send(MessageService message, ResponseListener responseListener) {
        TransportService transport = this.getTransport();
        if (transport == null) {
            throw new RuntimeException(this.getResource(3017));
        }
        transport.send(message, responseListener);
    }

    public void setState(int state) {
        int transportState;
        if (state < 2) {
            super.setState(state);
            return;
        }
        TransportService transport = this.getTransport();
        if (transport != null && (transportState = transport.getState()) > 2) {
            super.setState(transportState);
            return;
        }
        super.setState(2);
    }

    public void setTransport(TransportService transport) {
        if (this.getState() >= 4) {
            this.stop();
            this.unregister(this.transport);
            this.transport = transport;
            this.start();
        } else {
            this.unregister(this.transport);
            this.transport = transport;
        }
        if (this.transport != null) {
            this.register(this.transport);
        }
    }

    public void setup() {
        super.setup();
        if (this.getTransport() == null) {
            this.setTransport(this.getDefaultTransport());
        }
    }

    public void start() {
        if (!this.isStarted()) {
            InterestService interest;
            super.start();
            TransportService transport = this.getTransport();
            if (transport != null && (interest = this.getInterest()) != null) {
                transport.addInterest(interest);
            }
        }
    }

    public synchronized void stop() {
        InterestService interest;
        TransportService transport = this.getTransport();
        if (transport != null && (interest = this.getInterest()) != null) {
            transport.removeInterest(interest);
        }
        this.setRunning(false);
        super.stop();
        if (transport != null) {
            transport.stop();
        }
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        int mystate = this.getState();
        if (mystate != newState && mystate > 1) {
            if (newState == 5) {
                if (this.isThreadNeeded()) {
                    super.setState(mystate);
                    this.restart();
                } else {
                    this.setState(5);
                }
            } else if (newState > 1) {
                super.setState(newState);
            } else {
                super.setState(2);
            }
        }
    }

    public void unregister(TransportService transport) {
        if (transport != null) {
            transport.removeTransportListener((TransportListener)this);
        }
    }
}

