/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement.testcases;

import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.command.DataCommand;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.filter.SimpleFilter;
import org.eclipse.soda.dk.filter.service.FilterService;
import org.eclipse.soda.dk.measurement.CommandMeasurement;
import org.eclipse.soda.dk.measurement.MeasurementFieldMeasurement;
import org.eclipse.soda.dk.measurement.SignalMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.ParameterMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MapParameters;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.signal.DataSignal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.IntegerTranslateTransform;
import org.eclipse.soda.dk.transform.ScaleTransform;
import org.eclipse.soda.dk.transform.Transforms;
import org.eclipse.soda.dk.transform.service.TransformService;

public class MapMeasurementTestcase
extends TestCase
implements MeasurementListener {
    private static final ParameterService AP110 = new SimpleParameter("P1", (TransformService)new Transforms(new TransformService[]{new IntegerTranslateTransform(-40), new ScaleTransform(9, 5), new IntegerTranslateTransform(32)}), 4, 1, 1);
    private static final ParameterService AP175 = new SimpleParameter("P2", (TransformService)new Transforms(new TransformService[]{new ScaleTransform(1, 32), new IntegerTranslateTransform(-40), new ScaleTransform(9, 5), new IntegerTranslateTransform(32)}), 6, 2, 35);
    private static final MessageService Multiple;
    private static final FilterService TwoByteFilter;
    private final DataCommand multiMapCommand = new DataCommand("MultiMapCommand", MapMeasurementTestcase.getMultiple());
    private final DataSignal multiMapSignal = new DataSignal("MultiMapSignal", MapMeasurementTestcase.getMultiple());
    private final SignalMeasurement multiMapZ = new CommandMeasurement("MultiMap", new HashMap(), null, null, (SignalService)this.multiMapSignal, null, (CommandService)this.multiMapCommand);
    private final MeasurementFieldMeasurement p1 = new MeasurementFieldMeasurement("P1", (MeasurementService)this.multiMapZ, "P1");
    private final MeasurementFieldMeasurement p2 = new MeasurementFieldMeasurement("P2", (Object)EscObject.createNumber((long)0L), (MeasurementService)this.multiMapZ, "P2");
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[12];
        byArray[1] = -2;
        byArray[2] = -18;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        Multiple = new ParameterMessage(byArray, MapMeasurementTestcase.getTwoByteFilter(), (ParameterService)new MapParameters("", new ParameterService[]{MapMeasurementTestcase.getP110(), MapMeasurementTestcase.getP175()}));
        TwoByteFilter = new SimpleFilter(1, 2);
    }

    public static MessageService getMultiple() {
        return Multiple;
    }

    public static ParameterService getP110() {
        return AP110;
    }

    public static ParameterService getP175() {
        return AP175;
    }

    public static FilterService getTwoByteFilter() {
        return TwoByteFilter;
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.measurement.testcases.MapMeasurementTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.exit(0);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        System.out.println("source,newValue " + source + " " + newValue);
    }

    public void testMult() {
        byte[] byArray = new byte[12];
        byArray[1] = -2;
        byArray[2] = -18;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        this.multiMapSignal.messageReceived(null, EscObject.getCurrentTimestamp(), (MessageService)message);
        this.multiMapZ.addMeasurementListener((MeasurementListener)this);
        this.p1.addMeasurementListener((MeasurementListener)this);
        this.p2.addMeasurementListener((MeasurementListener)this);
        this.multiMapSignal.messageReceived(null, EscObject.getCurrentTimestamp(), (MessageService)message);
        Integer value = new Integer(4660);
        this.p1.executeWrite((Object)value);
    }
}

