/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.swt;

import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.swt.Bridge;
import org.eclipse.soda.dk.device.swt.DeviceSwt;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;

public class MeasurementBridge
extends Bridge
implements MeasurementListener {
    public MeasurementBridge(DeviceSwt parent, TableItem tableItem, MeasurementService measurement) {
        super(parent, tableItem, (ControlService)measurement);
        this.setTimstamp(measurement.getTimestamp());
        this.setData(measurement.getValue());
    }

    public Image getImage() {
        return this.getParent().getMeasurementImage();
    }

    public MeasurementService getMeasurement() {
        return (MeasurementService)this.getControl();
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.updateCount();
        this.updateRefreshCount();
        if (timestamp instanceof Number) {
            this.setTimstamp(((Number)timestamp).longValue());
        }
        this.setData(newValue);
    }

    public void setControl(ControlService control) {
        super.setControl(control);
        if (control instanceof MeasurementService) {
            MeasurementService measurement = (MeasurementService)control;
            measurement.addMeasurementListener((MeasurementListener)this);
        }
    }
}

