/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform;

import org.eclipse.soda.dk.data.Fraction;
import org.eclipse.soda.dk.data.IntegerFraction;
import org.eclipse.soda.dk.data.Numeric;
import org.eclipse.soda.dk.transform.Transform;
import org.eclipse.soda.dk.transform.service.TransformService;

public class ScaleTransform
extends Transform
implements TransformService {
    private Fraction scale;
    private Fraction encodeScale;

    public ScaleTransform(int numerator, int denominator) throws IllegalArgumentException {
        if (denominator == 0) {
            throw new IllegalArgumentException(String.valueOf(denominator));
        }
        if (numerator == 0) {
            throw new IllegalArgumentException(String.valueOf(numerator));
        }
        this.scale = new IntegerFraction(numerator, denominator);
        this.encodeScale = new IntegerFraction(denominator, numerator);
    }

    public Object decode(Object value) throws ClassCastException {
        if (value instanceof Numeric) {
            return ((Numeric)value).multiply(this.getScale());
        }
        return this.getScale().multiply((Number)value);
    }

    public Object encode(Object value) throws ClassCastException {
        if (value instanceof Numeric) {
            return ((Numeric)value).divide(this.getScale());
        }
        return this.getEncodeScale().multiply((Number)value);
    }

    public Fraction getEncodeScale() {
        return this.encodeScale;
    }

    public Fraction getScale() {
        return this.scale;
    }
}

