/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Map;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.parameter.NumberParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class SimpleDoubleParameter
extends NumberParameter {
    public static final int DOUBLE_LENGTH = 64;

    public SimpleDoubleParameter(String key) {
        super(key);
    }

    public SimpleDoubleParameter() {
        this("Double");
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        long longValue = SimpleDoubleParameter.getLong(container, this.getOffsetAbsolute(cursor), this.getLength(cursor));
        return new Double(Double.longBitsToDouble(longValue));
    }

    public int getLength() {
        return 64;
    }

    public long longValue(Object data) {
        Object value = data;
        if (data instanceof Map) {
            Map map = (Map)data;
            String key = this.getKey();
            if (key != null && key.length() > 0) {
                value = map.get(key);
            }
        }
        double doubleValue = EscConfiguration.doubleValue(value);
        return Double.doubleToLongBits(doubleValue);
    }
}

