/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.script.testcase;

import java.util.Hashtable;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.script.ScriptManager;
import org.eclipse.soda.dk.script.SimpleScript;

public class SimpleScriptTestcase
extends TestCase {
    static /* synthetic */ Class class$0;

    public SimpleScriptTestcase() {
    }

    public SimpleScriptTestcase(String name) {
        super(name);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.script.testcase.SimpleScriptTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void test01() {
        SimpleScript simpleScript = new SimpleScript();
        List list = simpleScript.getTokens("(a + 3);a +4;");
        int i = 0;
        while (i < list.size()) {
            Object value = list.get(i);
            System.out.println("value " + value + " " + value.getClass());
            ++i;
        }
    }

    public void test02() {
        SimpleScript simpleScript = new SimpleScript("4;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("4;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test03() {
        SimpleScript simpleScript = new SimpleScript("i;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("i;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test04() {
        SimpleScript simpleScript = new SimpleScript("(2 + 3) + (i + 4);");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("(2 + 3) + (i + 4);", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test05() {
        SimpleScript simpleScript = new SimpleScript("(2 * 3) + (i * 4);");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("(2 * 3) + (i * 4);", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test06() {
        SimpleScript simpleScript = new SimpleScript("2 + 3 + i + 4;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("2 + 3 + i + 4;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test07() {
        SimpleScript simpleScript = new SimpleScript("(i * i) + (j + j);");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        variables.put("j", new Integer(4));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("(i * i) + (j + j);", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test08() {
        SimpleScript simpleScript = new SimpleScript("abc = 3;abc + 1;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        variables.put("j", new Integer(4));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("abc = 3;abc + 1;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test09() {
        SimpleScript simpleScript = new SimpleScript("1 == 2;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        variables.put("j", new Integer(4));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("1 == 2;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((Object)scriptResult, (Object)result);
    }

    public void test10() {
        SimpleScript simpleScript = new SimpleScript("a = 2; a+=3;a;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        variables.put("j", new Integer(4));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("a = 2; a+=3;a;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test11() {
        SimpleScript simpleScript = new SimpleScript("2 << 3;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        variables.put("j", new Integer(4));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("2 << 3;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test19() {
        SimpleScript simpleScript = new SimpleScript("antennaFactor = antennaReportCount * antennaReportCount; countFactor = count; peakRssiMaximumAdjusted = peakRSSIMaximum + 128; peakRssiFactor = peakRssiMaximumAdjusted * peakRssiMaximumAdjusted; durationFactor = duration / 100; confidence = antennaFactor * (countFactor + peakRssiFactor + durationFactor); confidence;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("antennaReportCount", new Integer(3));
        variables.put("count", new Integer(4));
        variables.put("peakRSSIMaximum", new Integer(-30));
        variables.put("duration", new Integer(101));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("antennaFactor = antennaReportCount * antennaReportCount; countFactor = count; peakRssiMaximumAdjusted = peakRSSIMaximum + 128; peakRssiFactor = peakRssiMaximumAdjusted * peakRssiMaximumAdjusted; durationFactor = duration / 100; confidence = antennaFactor * (countFactor + peakRssiFactor + durationFactor); confidence;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((long)((Number)scriptResult).longValue(), (long)((Number)result).longValue());
    }

    public void test21() {
        SimpleScript simpleScript = new SimpleScript("2 > 3;");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        Object result = simpleScript.evaluate(variables);
        Object scriptResult = ScriptManager.getInstance().createScript("2 > 3;", "js").evaluate(variables);
        SimpleScriptTestcase.assertEquals((Object)scriptResult, (Object)result);
    }
}

