/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.transform.NegativeTransform;

public class NegativeTransformTestcase
extends TestCase {
    private NegativeTransform transform;
    private Object obj;
    static /* synthetic */ Class class$0;

    public NegativeTransformTestcase(String name) {
        super(name);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transform.testcase.NegativeTransformTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDecodeForException() {
        this.transform = new NegativeTransform();
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.decode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        NegativeTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        NegativeTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testDecodeForProperValueWithNegative() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.decode((Object)new Integer(-1000));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", ((Integer)this.obj == 1000 ? 1 : 0) != 0);
    }

    public void testDecodeForProperValueWithPositive() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.decode((Object)new Integer(1000));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", ((Integer)this.obj == -1000 ? 1 : 0) != 0);
    }

    public void testDecodeForProperValueWithZero() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.decode((Object)new Integer(0));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", ((Integer)this.obj == 0 ? 1 : 0) != 0);
    }

    public void testDecodeForType() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.decode((Object)new Integer(1000));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testEncodeForException() {
        this.transform = new NegativeTransform();
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.encode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        NegativeTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        NegativeTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testEncodeForProperValueWithNegative() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.encode((Object)new Integer(-1000));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", ((Integer)this.obj == 1000 ? 1 : 0) != 0);
    }

    public void testEncodeForProperValueWithPositive() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.encode((Object)new Integer(1000));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", ((Integer)this.obj == -1000 ? 1 : 0) != 0);
    }

    public void testEncodeForProperValueWithZero() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.encode((Object)new Integer(0));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", ((Integer)this.obj == 0 ? 1 : 0) != 0);
    }

    public void testEncodeForType() {
        this.transform = new NegativeTransform();
        this.obj = this.transform.encode((Object)new Integer(1000));
        NegativeTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testTransformIntConstructor() {
        this.transform = new NegativeTransform();
        NegativeTransformTestcase.assertTrue((String)"NegativeTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
    }
}

