/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.connection;

import java.io.IOException;
import java.util.Map;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionService;
import org.eclipse.soda.dk.nls.Nls;

public class TraceConnection
extends Connection
implements MultiplexConnectionService {
    private ConnectionService connectionService;

    public TraceConnection(ConnectionService connectionService) {
        this.setConnectionService(connectionService);
    }

    public synchronized void close() throws IOException {
        this.connectionService.close();
    }

    public void exit() throws IOException {
        if (this.connectionService != null) {
            this.connectionService.exit();
            this.connectionService = null;
        }
    }

    public void flush() throws IOException {
        this.connectionService.flush();
    }

    public ChannelService getChannel(String channelId) {
        return this.getMultiplexConnectionService().getChannel(channelId);
    }

    public Map getChannels() {
        return this.getMultiplexConnectionService().getChannels();
    }

    public MultiplexConnectionListener getConnectionListener() {
        return this.getMultiplexConnectionService().getConnectionListener();
    }

    public ConnectionService getConnectionService() {
        return this.connectionService;
    }

    public MultiplexConnectionService getMultiplexConnectionService() {
        return (MultiplexConnectionService)this.getConnectionService();
    }

    public boolean isOpen() {
        return this.connectionService.isOpen();
    }

    public void open() throws IOException {
        this.connectionService.open();
    }

    public ChannelService openChannel(Map parameters) throws IOException {
        if (TraceConnection.getTraceLevel() >= 7) {
            this.report(null, 1016, parameters);
        }
        return this.getMultiplexConnectionService().openChannel(parameters);
    }

    public void processEvents() throws Exception {
        this.getMultiplexConnectionService().processEvents();
    }

    public int read(byte[] bytes) throws IOException {
        int result = this.connectionService.read(bytes);
        if (result > 0 && TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)result);
            this.report(null, 1005, details);
        }
        return result;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        int result = this.connectionService.read(bytes, offset, length);
        if (result > 0 && TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)result);
            this.report(null, 1005, details);
        }
        return result;
    }

    public int read(ChannelService channel, byte[] bytes) throws IOException {
        int result = this.getMultiplexConnectionService().read(channel, bytes);
        if (result > 0 && TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)result);
            this.report(null, 1017, channel, details);
        }
        return result;
    }

    public int read(ChannelService channel, byte[] bytes, int offset, int length) throws IOException {
        int result = this.getMultiplexConnectionService().read(channel, bytes, offset, length);
        if (result > 0 && TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)result);
            this.report(null, 1017, channel, details);
        }
        return result;
    }

    public void setConnectionListener(MultiplexConnectionListener listener) {
        this.getMultiplexConnectionService().setConnectionListener(listener);
    }

    public void setConnectionService(ConnectionService connectionService) throws IllegalArgumentException {
        if (connectionService == null) {
            throw new IllegalArgumentException();
        }
        this.connectionService = connectionService;
    }

    public String toString() {
        if (this.connectionService != null) {
            return this.connectionService.toString();
        }
        return super.toString();
    }

    public void write(byte[] bytes) throws IOException {
        this.connectionService.write(bytes);
        if (TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
            this.report(null, 1006, details);
        }
    }

    public void write(byte[] bytes, int offset, int count) throws IOException {
        this.connectionService.write(bytes, offset, count);
        if (TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)count);
            this.report(null, 1006, details);
        }
    }

    public void write(ChannelService channel, byte[] bytes) throws IOException {
        this.getMultiplexConnectionService().write(channel, bytes);
        if (TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
            this.report(null, 1018, channel, details);
        }
    }

    public void write(ChannelService channel, byte[] bytes, int offset, int count) throws IOException {
        this.getMultiplexConnectionService().write(channel, bytes, offset, count);
        if (TraceConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)count);
            this.report(null, 1018, channel, details);
        }
    }
}

