/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm;

import java.io.IOException;
import java.io.InputStream;
import javax.comm.CommPort;
import org.eclipse.soda.dk.comm.NSParallelPort;
import org.eclipse.soda.dk.comm.NSSerialPort;

public class NSDeviceInputStream
extends InputStream {
    int fd = -1;
    private int bufsize = 0;
    private int readCount = 0;
    private int bufferCount = 0;
    private int thc = -1;
    private int tmo = -1;
    private boolean tmoDone = false;
    private NSSerialPort sp = null;
    private NSParallelPort pp = null;
    private byte[] buffer = null;

    NSDeviceInputStream(CommPort port, int portType) {
        if (portType == 2) {
            this.pp = (NSParallelPort)port;
            this.bufsize = this.pp.insBufferSize;
            this.thc = this.pp.rcvThreshold;
        } else {
            this.sp = (NSSerialPort)port;
            this.bufsize = this.sp.insBufferSize;
            this.thc = this.sp.rcvThreshold;
        }
        this.buffer = new byte[this.bufsize];
    }

    public int available() throws IOException {
        int rc;
        int nbc = 0;
        if (this.bufferCount > this.readCount) {
            nbc += this.bufferCount - this.readCount;
        }
        if ((rc = this.getReadCountNC()) > 0) {
            nbc += rc;
        }
        return nbc;
    }

    private native int getReadCountNC() throws IOException;

    public int read() throws IOException {
        int rc;
        if (this.bufferCount > this.readCount) {
            rc = this.buffer[this.readCount++];
            if (this.readCount == this.bufferCount) {
                this.bufferCount = 0;
                this.readCount = 0;
            }
        } else {
            if (this.pp != null) {
                this.tmo = this.pp.rcvTimeout;
            } else if (this.sp != null) {
                this.tmo = this.sp.rcvTimeout;
            }
            rc = this.readDeviceOneByteNC();
        }
        return rc;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b, int off, int len) throws IOException {
        block13: {
            toff = off;
            tlen = len;
            excflag = false;
            rdc = 0;
            if (this.pp != null) {
                this.thc = this.pp.rcvThreshold;
                this.tmo = this.pp.rcvTimeout;
            } else if (this.sp != null) {
                this.thc = this.sp.rcvThreshold;
                this.tmo = this.sp.rcvTimeout;
            }
            if (this.thc > 0 && this.thc < tlen) {
                tlen = this.thc;
            }
            if (this.bufsize != 0) ** GOTO lbl49
            this.bufferCount = 0;
            this.readCount = 0;
            while (tlen != 0) {
                this.tmoDone = false;
                rc = this.readDeviceNC(b, toff, tlen);
                if (rc < 0) {
                    excflag = true;
                } else {
                    toff += rc;
                    tlen -= rc;
                    rdc += rc;
                    if (!(rc == 0 || this.thc < 0 || this.tmo > 0 && this.tmoDone)) {
                        continue;
                    }
                }
                break block13;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                this.tmoDone = false;
                if (this.bufferCount == 0) {
                    this.readCount = 0;
                    rc = this.readDeviceNC(this.buffer, 0, this.bufsize);
                    if (rc < 0) {
                        excflag = true;
                        break;
                    }
                    this.bufferCount = rc;
                    if (rc == 0) break;
                }
                cc = tlen <= this.bufferCount - this.readCount ? tlen : this.bufferCount - this.readCount;
                System.arraycopy(this.buffer, this.readCount, b, toff, cc);
                toff += cc;
                tlen -= cc;
                this.readCount += cc;
                rdc += cc;
                if (this.readCount == this.bufferCount) {
                    this.bufferCount = 0;
                    this.readCount = 0;
                }
                if (this.thc < 0 || this.tmo > 0 && this.tmoDone) break;
lbl49:
                // 2 sources

                ** while (tlen != 0)
            }
        }
        if (excflag) {
            e = new IOException();
            throw e;
        }
        return rdc;
    }

    private native int readDeviceNC(byte[] var1, int var2, int var3);

    private native int readDeviceOneByteNC() throws IOException;
}

