/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.barcode.reader.transport;

import org.eclipse.soda.dk.barcode.reader.transport.service.BarcodeReaderTransportService;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.serial.connection.SerialConnection;
import org.eclipse.soda.dk.serial.connection.service.SerialConnectionService;
import org.eclipse.soda.dk.tcpip.connection.TcpipConnection;
import org.eclipse.soda.dk.tcpip.connection.service.TcpipConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class BarcodeReaderTransport
extends ConnectionTransport
implements TransportService,
BarcodeReaderTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.barcode.reader.transport.BarcodeReaderTransport";
    private byte[] messageBegin = BarcodeReaderTransportService.MESSAGE_BEGIN_DEFAULT;
    private byte[] messageEnd = BarcodeReaderTransportService.MESSAGE_END_DEFAULT;
    private int messageMinimumSize = 1;

    public int beginIndex(byte[] bytes, int length, byte[] begin, int index) {
        int indexCurrent = index;
        while (indexCurrent < length - begin.length) {
            if (this.same(bytes, length, begin, indexCurrent)) {
                return indexCurrent;
            }
            ++indexCurrent;
        }
        return indexCurrent;
    }

    protected int processInput(byte[] bytes, int length) throws Exception {
        Object timestamp = null;
        byte[] begin = this.getMessageBegin();
        byte[] end = this.getMessageEnd();
        int lengthAvailable = length;
        int index = 0;
        int messageMinimumSize = Math.max(this.getMessageMinimumSize(), 1);
        while (lengthAvailable >= messageMinimumSize) {
            int indexDelta;
            int messageLength = lengthAvailable;
            if (begin.length > 0 && (indexDelta = this.beginIndex(bytes, length, begin, index) - index) > 0) {
                lengthAvailable -= indexDelta;
                messageLength -= indexDelta;
                index += indexDelta;
            }
            if (lengthAvailable < messageMinimumSize) continue;
            int cfr_ignored_0 = end.length;
            byte[] messageBytes = new byte[messageLength];
            System.arraycopy(bytes, index, messageBytes, 0, messageLength);
            Message message = new Message(messageBytes);
            if (timestamp == null) {
                timestamp = BarcodeReaderTransport.getCurrentTimestamp();
            }
            this.fireMessageReceived(timestamp, (MessageService)message);
            index += messageLength;
            lengthAvailable -= messageLength;
        }
        return index;
    }

    public boolean same(byte[] bytes, int length, byte[] begin, int index) {
        int i = 0;
        while (i < begin.length) {
            if (bytes[index + i] != begin[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ConnectionService getDefaultConnection() {
        String type = this.getString("barcodereadertransport.connection", "serial");
        if (type.equals("tcpip")) {
            return this.getDefaultTcpipConnection();
        }
        return this.getDefaultSerialConnection();
    }

    public SerialConnectionService getDefaultSerialConnection() {
        return new SerialConnection(this.getInt("barcodereadertransport.comport", 1), this.getInt("barcodereadertransport.baudrate", 9600), this.getInt("barcodereadertransport.databits", 8), this.getInt("barcodereadertransport.parity", 0), this.getInt("barcodereadertransport.stopbits", 1), this.getInt("barcodereadertransport.hardwareflowcontrol", 0), this.getInt("barcodereadertransport.softwareflowcontrol", 0), this.getLong("barcodereadertransport.readtotaltimeout", 1000L), this.getLong("barcodereadertransport.readintervaltimeout", 50L), this.getLong("barcodereadertransport.writetotaltimeout", 100L));
    }

    public TcpipConnectionService getDefaultTcpipConnection() {
        return new TcpipConnection(this.getString("barcodereadertransport.localhost", "0.0.0.0"), this.getInt("barcodereadertransport.localport", -1), this.getString("barcodereadertransport.remotehost", "localhost"), this.getInt("barcodereadertransport.remoteport", 8901), this.getInt("barcodereadertransport.readtimeout", 1000), this.getInt("barcodereadertransport.readsize", -1), this.getInt("barcodereadertransport.writesize", -1), this.getInt("barcodereadertransport.linger", -1));
    }

    public byte[] getMessageBegin() {
        return this.messageBegin;
    }

    public byte[] getMessageEnd() {
        return this.messageEnd;
    }

    public int getMessageMinimumSize() {
        return this.messageMinimumSize;
    }

    public void setMessageBegin(byte[] messageBegin) {
        this.messageBegin = messageBegin;
    }

    public void setMessageEnd(byte[] messageEnd) {
        this.messageEnd = messageEnd;
    }

    public void setMessageMinimumSize(int messageMinimumSize) {
        this.messageMinimumSize = messageMinimumSize;
    }

    public void setup() {
        super.setup();
        this.setMessageMinimumSize(this.getInt("barcodereadertransport.messageminimumsize", this.getMessageMinimumSize()));
        this.setMessageBegin(this.getByteArray("barcodereadertransport.messagebegin", this.getMessageBegin()));
        this.setMessageEnd(this.getByteArray("barcodereadertransport.messageend", this.getMessageEnd()));
        this.setRetryTime(this.getLong("barcodereadertransport.retrytime", this.getRetryTime()));
        this.setPriority(this.getInt("barcodereadertransport.priority", this.getPriority()));
        this.setNotificationPriority(this.getInt("barcodereadertransport.notificationpriority", this.getNotificationPriority()));
        this.setTransmitRetries(this.getInt("barcodereadertransport.transmitretries", this.getTransmitRetries()));
        this.setNoActivityTimeout(this.getLong("barcodereadertransport.noactivitytimeout", this.getNoActivityTimeout()));
    }
}

