/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.adapter.managed;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.adapter.Adapter;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.managed.CoreManaged;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceAdvisor;
import org.osgi.service.cm.ManagedService;

public abstract class AdapterManaged
extends CoreManaged
implements ManagedService,
IManagedServiceAdvisor {
    public static final String[] IMPORTED_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    public static final String[] OPTIONAL_SERVICE = new String[]{METATYPE_SERVICE};

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        AdapterService adapter = this.createService(manager);
        if (adapter != null) {
            if (adapter instanceof Adapter) {
                ((Adapter)adapter).setBundleContext(this.getBundleContext());
            }
            adapter.setConfigurationInformation(properties);
            NotificationService notificationService = (NotificationService)manager.getImportedService("org.eclipse.soda.dk.notification.service.NotificationService");
            adapter.setNotificationService(notificationService);
            try {
                adapter.start();
            }
            catch (RuntimeException exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getExportedServiceNames(pid, null, properties, manager), (Object)adapter, (Dictionary)serviceProperties);
        }
        return adapter;
    }

    public AdapterService createService(DeviceService device) {
        return null;
    }

    public AdapterService createService(IBundleActivationManager manager) {
        String interestServiceName = this.getInterestServiceName();
        if (interestServiceName != null && interestServiceName.length() > 0) {
            DeviceService device = (DeviceService)manager.getImportedService(interestServiceName);
            AdapterService adapter = this.createService(device);
            return adapter;
        }
        AdapterService adapter = this.createService((DeviceService)null);
        return adapter;
    }

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        AdapterService adapter = (AdapterService)object;
        try {
            adapter.exit();
            int count = 0;
            while (count < 20 && adapter.getState() != 0) {
                Thread.sleep(100L);
                ++count;
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
    }

    public String getDeviceServiceName() {
        return "";
    }

    public String[] getImportedServiceNames(String pid, Dictionary arg1, Dictionary arg2, IBundleActivationManager manager) {
        return IMPORTED_SERVICES;
    }

    public String getInterestServiceName() {
        return this.getDeviceServiceName();
    }

    protected String[] getOptionalImportedServiceNames() {
        return OPTIONAL_SERVICE;
    }

    public String[] getOptionalImportedServiceNames(String pid, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return BaseBundleActivator.NO_SERVICES;
    }

    public String getServiceName() {
        return DeviceService.SERVICE_NAME;
    }

    public String[] getServiceNames() {
        return new String[]{this.getServiceName()};
    }

    public synchronized Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        try {
            AdapterService adapter = (AdapterService)object;
            manager.removeExportedService(this.getServiceName(), object);
            Thread.yield();
            adapter.exit();
        }
        catch (Exception e) {
            EscObject.handleStaticException((Throwable)e);
        }
        return this.create(pid, properties, manager);
    }
}

