/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.generic.profile.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.generic.profile.wizard.GenericProfileMessages;
import org.eclipse.soda.devicekit.ui.profile.wizard.ProfilePage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class GenericProfileImplementationPage
extends ProfilePage {
    private static IWizardMessages messages = GenericProfileMessages.getInstance();

    public GenericProfileImplementationPage(String pageName, DkmlFileFinder finder) {
        super(pageName);
        this.setFinder(finder);
    }

    public GenericProfileImplementationPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createAnyImplementation(Composite composite) {
        super.createAnyImplementation(composite);
        this.createComboControl(composite, "profiletype", this.getProfiles(), 2048);
        final Button button = this.createCheckBoxControl(composite, "usegenericadapter");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean state = button.getSelection();
                ((Combo)GenericProfileImplementationPage.this.getWidget("genericadapter")).setEnabled(state);
            }
        });
        this.createComboControl(composite, "genericadapter", this.getGenericAdapters(), 2048);
    }

    protected void createCommonOptions(Composite composite) {
        String bundlelabelString = this.getString("bundleoptions");
        this.createCheckBoxControl(composite, "create.bundle", bundlelabelString);
        this.createCheckBoxControl(composite, "create.managed.bundle");
        this.createCheckBoxControl(composite, "create.managed.factory.bundle");
    }

    public String[] createSupportChoices() {
        if (this.isTest()) {
            return this.getNameShortProfileTestChoices();
        }
        return null;
    }

    public String[] getGenericAdapters() {
        return this.getNamesShort("GenericAdapter");
    }

    protected String getKey() {
        String profileType = this.getProfileType();
        if (profileType != null) {
            return profileType;
        }
        return super.getKey();
    }

    public String[] getNameChoices() {
        if (this.isTest()) {
            return this.getNameShortProfileTestChoices();
        }
        return this.getNameShortDevice();
    }

    protected String getProfileType() {
        String type = this.getWidgetText("profiletype");
        if (type != null && type.trim().length() > 0) {
            return type;
        }
        return null;
    }

    public String[] getProfiles() {
        return messages.getStringAsArray("genericprofiles");
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            return super.getString(key);
        }
    }

    protected boolean nameOk(String value, boolean output) {
        String projectName;
        String typeName = this.getTypeName();
        if (value.length() == 0) {
            String message = this.getString("name.empty");
            this.update(false, false, null, message);
            return false;
        }
        if (value.indexOf(46) > 0) {
            String errorMessage = this.getString("name.error");
            this.update(false, false, errorMessage, null);
            return false;
        }
        if (value.endsWith("Profile")) {
            String errorMessage = this.getString("name.end");
            this.update(false, false, errorMessage, null);
            return false;
        }
        if (!this.validName(value)) {
            return false;
        }
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(value);
        buffer.append(typeName);
        if (this.isTest()) {
            buffer.append("Test");
        }
        if (this.projectExists(projectName = this.transformToNewName(buffer.toString()))) {
            if (output) {
                String errorMessageUnformatted = this.getString("project.already.exists");
                String errorMessage = Nls.format((String)errorMessageUnformatted, (Object[])new String[]{projectName});
                this.update(false, false, errorMessage, null);
            }
            return false;
        }
        return true;
    }
}

