/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.generic.profile.operation;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.soda.devicekit.generator.constants.Types;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.ui.generic.profile.wizard.GenericProfileMessages;
import org.eclipse.soda.devicekit.ui.profile.operation.ProfileOperation;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;

public class GenericProfileImplementationOperation
extends ProfileOperation {
    public GenericProfileImplementationOperation(Map variables, DkmlFileFinder finder) {
        super(variables);
        this.setFinder(finder);
    }

    protected void addProfileDkmlBody(IXmlElement dkmlElement) {
        String superClass;
        String profileType;
        IXmlElement element = dkmlElement.add("profile");
        boolean abstractState = this.createCommonTop(element, true);
        boolean applyAdapter = true;
        String useGenericAdapter = (String)this.getVariables().get("usegenericadapter");
        if (useGenericAdapter != null && useGenericAdapter.equals("false")) {
            applyAdapter = false;
        }
        if (applyAdapter) {
            String adapterName = (String)this.getVariables().get("genericadapter");
            if (adapterName != null && adapterName.trim().length() > 0) {
                IXmlElement adapter = element.add("adapter");
                StringBuffer refBuffer = new StringBuffer(128);
                IFile file = this.getFinder().findFile("genericadapter", adapterName);
                if (file != null && file.exists()) {
                    String projectId = file.getProject().getName();
                    refBuffer.append(projectId);
                } else {
                    String packageBase = this.getPackageBase();
                    refBuffer.append(this.getNewBundleName(adapterName, packageBase));
                }
                refBuffer.append("/dk/genericadapter.xml#");
                refBuffer.append(adapterName);
                adapter.addAttribute("idref", refBuffer.toString());
            } else {
                applyAdapter = false;
            }
        }
        if ((profileType = (String)this.getVariables().get("profiletype")) != null && (superClass = Types.getString((String)(applyAdapter ? profileType : String.valueOf(profileType) + "NoAdapter"))) != null) {
            element.addAttribute("superclass", superClass);
        }
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected String getNameFull() {
        String name = (String)this.getVariables().get("name");
        Object profileType = this.getVariables().get("profiletype");
        if (profileType != null) {
            String profileName = GenericProfileMessages.getInstance().getString(profileType.toString());
            return String.valueOf(name) + profileName;
        }
        return super.getNameFull();
    }
}

