/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.device.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.soda.devicekit.ui.device.wizard.DeviceMessages;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitBasePage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.widgets.Composite;

public class DevicePage
extends DeviceKitBasePage {
    private static IWizardMessages messages = DeviceMessages.getInstance();

    public DevicePage(String pageName) {
        super(messages.getString("new.device"));
        this.setTitle(messages.getString("device"));
    }

    public DevicePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createCustomControl(Composite composite) {
        this.createSuperClassControl(composite);
        if (!this.isTest()) {
            this.createComboControl(composite, "transport.service", this.getTransportServices(), 2052);
            this.createComboControl(composite, "transport.implementation", this.getTransportImplementations(), 2052);
        }
        this.createCommonOptions(composite);
    }

    public String[] createSupportChoices() {
        if (this.isTest()) {
            return this.getNameShortDeviceTestChoices();
        }
        return this.getNameShortTransport();
    }

    protected String getKey() {
        return "device";
    }

    public String[] getNameChoices() {
        if (this.isTest()) {
            return this.getNameShortDeviceTestChoices();
        }
        return this.getNameShortDeviceChoices();
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            return super.getString(key);
        }
    }

    public String[] getSuperClasses() {
        String value = DeviceKitPreferenceInitializer.getPreferenceString((String)"device.superclass");
        if (value != null) {
            return DeviceKitPreferenceInitializer.parsePrefArray((String)value);
        }
        return new String[]{""};
    }
}

