/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import org.eclipse.soda.devicekit.generator.model.ConfigurationModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.ui.transport.wizard.DeviceKitConnectionPage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SerialConnectionPage
extends DeviceKitConnectionPage
implements SelectionListener {
    private IWizardMessages messages;
    private String defaultMessage;

    public SerialConnectionPage(String pageName, IWizardMessages messages, String defaultMessage, DeviceKitPage previousPage) {
        super(pageName, previousPage);
        this.messages = messages;
        this.defaultMessage = defaultMessage;
        this.setTitle(messages.getString(pageName));
        this.setMessage(defaultMessage);
    }

    public void createCustom(Composite composite) {
        ConfigurationModel model = ConfigurationModel.getConnection((String)"serial");
        ConfigurationField[] fields = model.getConfigurationFields();
        int i = 0;
        while (i < fields.length) {
            String description;
            String name;
            ConfigurationField field = fields[i];
            String key = name = field.getConfigurationName();
            String displayName = field.getDisplayName();
            String hint = description = field.getDescription();
            String defaultValue = field.getValue();
            CustomParameterElement customParameterElement = field.getCustomParameterElement();
            boolean required = customParameterElement != null ? "true".equals(customParameterElement.getRequired()) : false;
            String niceName = displayName != null ? displayName : name;
            Button label = new Button(composite, 16416);
            label.setData((Object)key);
            label.setEnabled(!required);
            label.setText(niceName);
            label.setSelection(required);
            label.addSelectionListener((SelectionListener)this);
            if (hint != null && hint.length() > 0) {
                label.setToolTipText(hint);
            }
            Combo text = new Combo(composite, 2048);
            String[] items = new String[]{"", defaultValue};
            text.setItems(items);
            GridData data = new GridData(4);
            data.horizontalSpan = 2;
            data.verticalSpan = 1;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            text.setLayoutData((Object)data);
            text.setToolTipText(hint);
            text.addListener(24, (Listener)this);
            this.putWidget(String.valueOf(key) + ".checkbox", (Widget)label);
            this.putWidget(key, (Widget)text);
            text.setText(defaultValue);
            text.setEnabled(required);
            ++i;
        }
    }

    protected String getKey() {
        return "serial";
    }

    public String getString(String key) {
        return this.messages.getString(key);
    }

    protected boolean updatePageErrors() {
        if (!this.isNumberTextEntry("connection.com.port", false)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.read.total.timeout", false)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.read.interval.timeout", false)) {
            return false;
        }
        if (!this.isNumberTextEntry("connection.write.total.timeout", false)) {
            return false;
        }
        this.update(true, false, null, this.defaultMessage);
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button button;
        Object data;
        if (e.widget instanceof Button && (data = (button = (Button)e.widget).getData()) != null) {
            Widget widget = this.getWidget(data.toString());
            System.out.print("widget " + widget + e.stateMask);
            if (widget instanceof Text) {
                ((Text)widget).setEditable(button.getSelection());
            } else if (widget instanceof Combo) {
                ((Combo)widget).setEnabled(button.getSelection());
            }
        }
    }
}

