/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.transport.wizard;

import org.eclipse.soda.devicekit.ui.transport.wizard.ConnectionModelPage;
import org.eclipse.soda.devicekit.ui.transport.wizard.TransportMessages;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;

public class Validator {
    public static final String VALIDATOR_BLANK = "validator.blank";
    public static final String VALIDATOR_INVALID = "validator.invalid";
    public static final String VALIDATOR_NUMBER = "validator.number";
    public static final String VALIDATOR_MIN = "validator.min";
    public static final String VALIDATOR_MAX = "validator.max";
    protected Button button;
    protected Combo combo;
    protected Label label;
    protected ConnectionModelPage connectionModelPage;
    protected Number minimum = new Long(Long.MIN_VALUE);
    protected Number maximum = new Long(Long.MAX_VALUE);

    public Validator(ConnectionModelPage connectionModelPage) {
        this.setConnectionModelPage(connectionModelPage);
    }

    public Button getButton() {
        return this.button;
    }

    public Combo getCombo() {
        return this.combo;
    }

    public ConnectionModelPage getConnectionModelPage() {
        return this.connectionModelPage;
    }

    public Label getLabel() {
        return this.label;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public String getString(String key) {
        try {
            return TransportMessages.getInstance().getString(key);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return key;
        }
    }

    public boolean isValid() {
        if (this.button.getSelection()) {
            String value = this.combo.getText();
            if (value.length() > 0) {
                return this.isValid(value);
            }
            this.updateError(VALIDATOR_BLANK, "");
            return false;
        }
        return true;
    }

    public boolean isValid(String value) {
        return true;
    }

    public void setButton(Button button) {
        this.button = button;
    }

    public void setCombo(Combo combo) {
        this.combo = combo;
    }

    public void setConnectionModelPage(ConnectionModelPage connectionModelPage) {
        this.connectionModelPage = connectionModelPage;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setMaximum(Number maximum) {
        this.maximum = maximum;
    }

    public void setMaximum(String maximum) {
        this.maximum = new Long(Long.parseLong(maximum));
    }

    public void setMinimum(Number minimum) {
        this.minimum = minimum;
    }

    public void setMinimum(String minimum) {
        this.minimum = new Long(Long.parseLong(minimum));
    }

    protected void updateError(String key, String value) {
        String pattern = this.getString(key);
        if (pattern != null) {
            Object[] objects = new Object[]{this.label.getText(), value, this.getMinimum(), this.getMaximum()};
            String errorMessage = Nls.format((String)pattern, (Object[])objects);
            this.connectionModelPage.update(false, false, errorMessage, null);
            return;
        }
        this.connectionModelPage.update(false, false, String.valueOf(this.label.getText()) + ' ' + key, null);
    }
}

