/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.connection.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.ui.operation.DeviceKitGenerateOperation;

public class ConnectionOperation
extends DeviceKitGenerateOperation {
    public ConnectionOperation(Map variables) {
        super(variables);
    }

    protected void addDeviceDkmlBody(IXmlElement dkmlElement) {
        IXmlElement element = dkmlElement.add("connection");
        boolean abstractState = this.createCommonTop(element, true);
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected void addDeviceTestDkmlBody(IXmlElement dkmlElement) {
        IXmlElement test = dkmlElement.add("connectiontest");
        String name = this.getName();
        this.addCommonTestTop(test);
        IXmlElement connection = test.add("connection");
        StringBuffer refBuffer = new StringBuffer(128);
        refBuffer.append(this.getProjectName());
        refBuffer.append("/dk/connection.xml#");
        refBuffer.append(name);
        connection.addAttribute("idref", refBuffer.toString());
        if (this.doGenerateTestcase()) {
            test.add("testcase");
        }
        this.addCommonBundle(test);
    }

    protected void addDkmlBody(IXmlElement element, int type) {
        switch (type) {
            case 0: {
                this.addDeviceDkmlBody(element);
                break;
            }
            case 1: {
                this.addDeviceTestDkmlBody(element);
            }
        }
    }

    protected IFile createDkmlFile(int type, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile;
        InputStream stream = null;
        try {
            String filename = "connection.xml";
            if (type == 1) {
                filename = "connection_test.xml";
            }
            XmlModel model = new XmlModel(filename);
            this.populateTemplateModel(model, type);
            String contents = model.getContents();
            stream = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes()));
            IFile file = folder.getFile(filename);
            file.create(stream, true, monitor);
            iFile = file;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
        catch (IOException iOException) {}
        return iFile;
    }

    protected String getName() {
        String name = (String)this.getVariables().get("name");
        name = String.valueOf(name) + "Connection";
        return name;
    }

    protected String[] getRequiredClasses() {
        return new String[0];
    }
}

