/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitTagConstants;
import org.eclipse.soda.devicekit.generator.model.BytesGenerator;
import org.eclipse.soda.devicekit.generator.model.TagException;
import org.eclipse.soda.devicekit.generator.model.elements.AsciiMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.DeprecatedElement;
import org.eclipse.soda.devicekit.generator.model.elements.DescriptionElement;
import org.eclipse.soda.devicekit.generator.model.elements.DisplayNameElement;
import org.eclipse.soda.devicekit.generator.model.elements.DkgElementsMessages;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.HistoryElement;
import org.eclipse.soda.devicekit.generator.model.elements.KeyElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.MultiplexElement;
import org.eclipse.soda.devicekit.generator.model.elements.OptionalElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecReferenceElement;
import org.eclipse.soda.devicekit.generator.model.elements.StringMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagCollection;
import org.eclipse.soda.devicekit.generator.model.elements.TagElementLink;
import org.eclipse.soda.devicekit.generator.model.elements.TransformItem;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.Utf8MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.ValueElement;
import org.eclipse.soda.devicekit.generator.model.elements.VersionElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitDefaults;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.soda.devicekit.util.AnchorUtil;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TagElement {
    public static final List EMPTY_SET = new ArrayList();
    public static TagCollection collection = new TagCollection();
    public static String fPackageBase;
    protected static List references;
    private Map fAttributes;
    private List fChildren;
    private String fDefaultPackage;
    private DeviceKitDefaults fDefaults;
    private String description = null;
    protected String deprecated = null;
    protected String displayName = null;
    private String fKey;
    private String tagName;
    private Node fNode;
    private TagElement fParent;
    private String fTextData;
    private String fType;
    private Map fVariables;
    private String packageBase;
    private boolean followReferences = true;
    private String initialVersion = null;
    private String version;

    protected TagElement(Node node, TagElement parent) {
        this(node, parent, null);
    }

    protected TagElement(Node node, TagElement parent, List references) {
        this(node, parent, references, true);
    }

    protected TagElement(Node node, TagElement parent, List references, boolean followReferences) {
        this.fNode = node;
        if (references != null) {
            TagElement.references = references;
        }
        this.initialize();
        this.followReferences = followReferences;
        this.fAttributes = new HashMap();
        this.fVariables = new HashMap();
        this.fChildren = new ArrayList();
        this.fDefaults = DeviceKitDefaults.getInstance();
        if (this.fNode != null) {
            this.setTagName(this.fNode.getNodeName());
            this.setParent(parent);
            this.buildData();
            this.buildAttributes();
            this.build();
        }
    }

    protected void addAttribute(String name, String value) {
        this.fAttributes.put(name, value);
    }

    protected void addChild(TagElement child) {
        this.fChildren.add(child);
    }

    public void addFieldExtraCommentMessages(StringBuffer buffer, String fieldName) {
        List messages;
        int parameterSize;
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = collection.getParameter(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        if ((parameterSize = (messages = realElement.getMessageChildren()).size()) > 0) {
            int i = 0;
            while (i < parameterSize) {
                TagElement tagElement = (TagElement)messages.get(i);
                tagElement.addFieldExtraCommentParameters(buffer, true, fieldName);
                ++i;
            }
        }
    }

    public void addFieldExtraCommentParameters(StringBuffer buffer, boolean full, String fieldName) {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = collection.getParameter(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        String keyThis = realElement.getAnyId();
        List parameters = realElement.getParameterChildren();
        int parameterSize = parameters.size();
        int count = 0;
        StringBuffer subbuffer = new StringBuffer(1024);
        if (parameterSize > 0) {
            int i = 0;
            while (i < parameterSize) {
                String key;
                TagElement tagElement = (TagElement)parameters.get(i);
                if (!tagElement.isConstantParameter() && (key = tagElement.getAnyId()) != null && key.length() > 0) {
                    if (fieldName.equals("") || fieldName.equals(key)) {
                        String unitsDocumentation;
                        if (count == 0) {
                            buffer.append("\n<ul>");
                        }
                        ++count;
                        buffer.append("\n<li>");
                        if (fieldName.equals(key)) {
                            buffer.append("<b>");
                            buffer.append(key);
                            buffer.append("</b>");
                        } else {
                            buffer.append(key);
                        }
                        String dataTypeDocumentation = tagElement.getParameterDataTypeDocumentation();
                        if (dataTypeDocumentation != null && dataTypeDocumentation.length() > 0) {
                            buffer.append(" <code>");
                            buffer.append(dataTypeDocumentation);
                            buffer.append("</code>");
                        }
                        if ((unitsDocumentation = tagElement.getUnitsDocumentation()) != null && unitsDocumentation.length() > 0) {
                            buffer.append(" ");
                            buffer.append(unitsDocumentation);
                        }
                        if (!tagElement.isRequiredParameter()) {
                            buffer.append(" <i>optional</i>");
                        }
                        buffer.append("</li>");
                        if (full && !keyThis.equals(key)) {
                            if (fieldName.equals(key)) {
                                tagElement.addFieldExtraCommentParameters(buffer, false, "");
                            } else {
                                tagElement.addFieldExtraCommentParameters(buffer, false, fieldName);
                            }
                        }
                    } else if (!keyThis.equals(key) && fieldName.length() > 0 && subbuffer.length() == 0) {
                        tagElement.addFieldExtraCommentParameters(subbuffer, true, fieldName);
                    }
                }
                ++i;
            }
            if (count > 0) {
                buffer.append("\n</ul>");
            } else if (subbuffer.length() > 0) {
                buffer.append(subbuffer.toString());
            }
        }
    }

    public void addTemplateVariable(String key, String value) {
        this.fVariables.put(key, value);
    }

    public void build() {
        if (this.fNode != null) {
            this.buildChildren();
            this.validate();
        }
    }

    protected void buildAttributes() {
        NamedNodeMap attributes = this.getNode().getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node node = attributes.item(i);
                if (node.getNodeType() == 2) {
                    if ("idref".equals(node.getNodeName())) {
                        Node nodeId;
                        NamedNodeMap parentAttributes;
                        boolean check = true;
                        String value = node.getNodeValue();
                        Node parent = this.getNode().getParentNode();
                        if (parent != null && (parentAttributes = parent.getAttributes()) != null && (nodeId = parentAttributes.getNamedItem("id")) != null) {
                            String parentId = nodeId.getNodeValue();
                            boolean bl = check = !value.equals(parentId);
                        }
                        if (check) {
                            this.checkValidReference(value);
                        }
                    }
                    this.addAttribute(node.getNodeName(), node.getNodeValue());
                }
                ++i;
            }
        }
    }

    protected void buildChildren() {
        NodeList children = this.getNode().getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node currentChild = children.item(i);
                if (this.isReferencedIdref(currentChild) && this.isFollowReferences()) {
                    if (this.checkLoop(currentChild, currentChild.getParentNode())) {
                        this.handleChild(currentChild);
                    } else {
                        Node child = this.handleReference(currentChild);
                        if (child != null) {
                            this.handleChild(child);
                        } else {
                            StringBuffer buffer = new StringBuffer(1024);
                            buffer.append("Can not find reference ");
                            buffer.append(AnchorUtil.getAnchorRefValue(children.item(i)));
                            buffer.append(" in ");
                            buffer.append(this.getTagName());
                            this.handleChild(currentChild);
                        }
                    }
                }
                this.handleChild(children.item(i));
                ++i;
            }
        }
    }

    protected void buildData() {
        this.setTextData(ParserUtilities.extractData(this.getNode()));
    }

    public boolean checkDisplayChildren() {
        return false;
    }

    public boolean checkLoop(Node node, Node parent) {
        Node idrefNode;
        NamedNodeMap nodeAttributes;
        if (parent != null && (nodeAttributes = node.getAttributes()) != null && (idrefNode = nodeAttributes.getNamedItem("idref")) != null) {
            String id;
            Node idNode;
            String idref = idrefNode.getNodeValue();
            NamedNodeMap parentAttributes = parent.getAttributes();
            if (parentAttributes != null && (idNode = parentAttributes.getNamedItem("id")) != null && (id = idNode.getNodeValue()).equals(idref)) {
                return true;
            }
            return this.checkLoop(node, parent.getParentNode());
        }
        return false;
    }

    protected void checkValidReference(String name) {
        TagElement element = null;
        switch (this.getTagCode()) {
            case 1: 
            case 19: 
            case 20: 
            case 43: 
            case 44: 
            case 45: 
            case 1001: {
                element = collection.getCommand(name);
                break;
            }
            case 3: 
            case 1003: {
                element = collection.getSignal(name);
                break;
            }
            case 2: {
                element = collection.getMeasurement(name);
                break;
            }
            case 4: 
            case 1004: {
                element = collection.getUnit(name);
                break;
            }
            case 7: 
            case 50: 
            case 152: 
            case 153: 
            case 154: 
            case 1007: {
                element = collection.getMessage(name);
                break;
            }
            case 6: 
            case 1006: {
                element = collection.getFilter(name);
                break;
            }
            case 5: 
            case 23: 
            case 1005: 
            case 1023: {
                element = collection.getParameter(name);
                break;
            }
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 1021: 
            case 1022: 
            case 1024: 
            case 1026: 
            case 1027: 
            case 1028: {
                element = collection.getTransform(name);
                break;
            }
            case 53: {
                element = collection.getPid(name);
                break;
            }
            case 60: {
                element = collection.getSend(name);
                break;
            }
            case 62: {
                element = collection.getMessage(name);
                if (element != null) break;
                element = collection.getMessage(String.valueOf(name) + "Message");
                break;
            }
            case 64: {
                element = collection.getSpec(name);
                break;
            }
            default: {
                return;
            }
        }
        if (element == null) {
            throw this.error(Nls.format(DkgElementsMessages.getString("TagElement.error.invalid.idref"), name));
        }
    }

    public int compare(Object object1, Object object2) {
        String string1 = object1.toString();
        String string2 = object2.toString();
        if (object1 instanceof TagElement && object2 instanceof TagElement) {
            string1 = ((TagElement)object1).getKey();
            if (string1 == null || string1.length() == 0) {
                string1 = object1.toString();
            }
            if ((string2 = ((TagElement)object2).getKey()) == null || string2.length() == 0) {
                string2 = object2.toString();
            }
        }
        return string1.compareTo(string2);
    }

    protected RuntimeException error(String message) {
        return new TagException(9, String.valueOf(message) + "\r\n" + this.toString(this));
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return this.getClassNameFull();
    }

    protected String format(String pattern, String[] values) {
        return Nls.format(pattern, values);
    }

    public List getAdapterChildren() {
        return this.getAllChildrenWithTagCode(72);
    }

    public List getAgentChildren() {
        return this.getAllChildrenWithTagCode(91);
    }

    public List getAllChildren(boolean includeRef, boolean includeLink) {
        ArrayList<TagElement> result = new ArrayList<TagElement>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.get(i);
            int tagCode = element.getTagCode();
            if (element instanceof MainTagElement) {
                result.add(element);
                return result;
            }
            boolean tagLink = tagCode >= 1000;
            String idref = element.getAttribute("idref");
            if (idref != null && idref.length() > 0) {
                if (includeRef) {
                    result.add(element);
                    if (!tagLink || includeLink && tagLink) {
                        result.addAll(element.getAllChildren(includeRef, includeLink));
                    }
                }
            } else {
                result.add(element);
                if (!tagLink || includeLink && tagLink) {
                    result.addAll(element.getAllChildren(includeRef, includeLink));
                }
            }
            ++i;
        }
        return result;
    }

    public List getAllChildrenWithTagCode(int code) {
        return this.getAllChildrenWithTagCode(code, true);
    }

    public List getAllChildrenWithTagCode(int code, boolean includeRef) {
        ArrayList<TagElement> result = new ArrayList<TagElement>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.get(i);
            int tagCode = element.getTagCode();
            if (tagCode == code) {
                result.add(element);
            } else if (tagCode == 82) {
                result.addAll(element.getAllChildrenWithTagCode(code, includeRef));
            } else if (tagCode == 1000 + code && includeRef) {
                result.add((TagElement)children.get(i));
            }
            ++i;
        }
        return result;
    }

    public List getAllChildrenWithTagCodes(int[] codes) {
        return this.getAllChildrenWithTagCodes(codes, true);
    }

    public List getAllChildrenWithTagCodes(int[] codes, boolean includeRef) {
        ArrayList<TagElement> result = new ArrayList<TagElement>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            int j = 0;
            while (j < codes.length) {
                int code = codes[j];
                TagElement element = (TagElement)children.get(i);
                int tagCode = element.getTagCode();
                if (tagCode == code) {
                    result.add(element);
                } else if (tagCode == 82) {
                    result.addAll(element.getAllChildrenWithTagCode(code, includeRef));
                } else if (tagCode == 1000 + code && includeRef) {
                    result.add((TagElement)children.get(i));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public List getAllChildrenWithTagCodes(int[] codes, int[] parentCodes) {
        ArrayList<TagElement> result = new ArrayList<TagElement>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            int j = 0;
            while (j < codes.length) {
                int code = codes[j];
                TagElement element = (TagElement)children.get(i);
                int tagCode = element.getTagCode();
                if (tagCode == code) {
                    result.add(element);
                }
                int k = 0;
                while (k < parentCodes.length) {
                    if (tagCode == parentCodes[k]) {
                        result.addAll(element.getAllChildrenWithTagCodes(new int[]{code}, parentCodes));
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public List getAllChildrenWithTagCodesAndId(int[] codes, int[] parentCodes) {
        List children = this.getChildren();
        int size = children.size();
        if (size > 0) {
            SortedSet result = new SortedSet();
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < codes.length) {
                    String id;
                    int code = codes[j];
                    TagElement element = (TagElement)children.get(i);
                    int tagCode = element.getTagCode();
                    if (tagCode == code && (id = element.getAnyId()) != null && id.length() > 0) {
                        result.add(element);
                    }
                    int k = 0;
                    while (k < parentCodes.length) {
                        List list;
                        if (tagCode == parentCodes[k] && !(list = element.getAllChildrenWithTagCodesAndId(new int[]{code}, parentCodes)).isEmpty()) {
                            result.addAll(list);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }
        return EMPTY_SET;
    }

    public List getAllSubChildrenWithTagCode(int code, boolean includeRef) {
        SortedSet result = new SortedSet();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.get(i);
            int tagCode = element.getTagCode();
            if (tagCode == code) {
                result.add(element);
                result.addAll((Collection)element.getAllSubChildrenWithTagCode(code, includeRef));
            } else if (tagCode == 1000 + code) {
                if (includeRef) {
                    result.add(children.get(i));
                }
            } else {
                result.addAll((Collection)element.getAllSubChildrenWithTagCode(code, includeRef));
            }
            ++i;
        }
        return result;
    }

    public List getAllSubChildrenWithTagCodeWithId(int code, boolean includeRef) {
        List children = this.getChildren();
        int size = children.size();
        if (size > 0) {
            SortedSet result = new SortedSet();
            int i = 0;
            while (i < size) {
                TagElement element = (TagElement)children.get(i);
                int tagCode = element.getTagCode();
                if (tagCode == code) {
                    List results;
                    String id = element.getIdRaw();
                    if (id != null && id.length() > 0) {
                        result.add(element);
                    }
                    if (!(results = element.getAllSubChildrenWithTagCodeWithId(code, includeRef)).isEmpty()) {
                        result.addAll((Collection)results);
                    }
                } else if (tagCode == 1000 + code) {
                    if (includeRef) {
                        result.add(children.get(i));
                    }
                } else {
                    List results = element.getAllSubChildrenWithTagCodeWithId(code, includeRef);
                    if (!results.isEmpty()) {
                        result.addAll((Collection)results);
                    }
                }
                ++i;
            }
            return result;
        }
        return EMPTY_SET;
    }

    public List getAllSubChildrenWithTagCodeWithId(int[] codes, boolean includeRef) {
        List children = this.getChildren();
        int size = children.size();
        if (size > 0) {
            SortedSet result = new SortedSet();
            int i = 0;
            while (i < size) {
                TagElement element = (TagElement)children.get(i);
                int tagCode = element.getTagCode();
                int j = 0;
                while (j < codes.length) {
                    int code = codes[j];
                    if (tagCode == code) {
                        List results;
                        String id = element.getIdRaw();
                        if (id != null && id.length() > 0) {
                            result.add(element);
                        }
                        if (!(results = element.getAllSubChildrenWithTagCodeWithId(codes, includeRef)).isEmpty()) {
                            result.addAll((Collection)results);
                        }
                    } else if (tagCode == 1000 + code) {
                        if (includeRef) {
                            result.add(children.get(i));
                        }
                    } else {
                        List results = element.getAllSubChildrenWithTagCodeWithId(codes, includeRef);
                        if (!results.isEmpty()) {
                            result.addAll((Collection)results);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }
        return EMPTY_SET;
    }

    public String getAnyId() {
        String key = this.getKey();
        if (key != null) {
            return key;
        }
        String idref = this.getIdRef();
        if (idref != null) {
            return idref;
        }
        return this.getTagName();
    }

    public String getAnyIdentifier() {
        int index;
        String id = this.getAnyId();
        if (id != null && (index = id.lastIndexOf(35)) >= 0) {
            return id.substring(index + 1);
        }
        return id;
    }

    public String getAnyName() {
        String name = this.getNameRaw();
        if (name != null && name.length() > 0) {
            return name;
        }
        String id = this.getAnyId();
        if (id != null && id.length() > 0) {
            return id;
        }
        return this.getTagName();
    }

    public String getAttribute(String name) {
        String attribute = (String)this.fAttributes.get(name);
        if (attribute != null) {
            return attribute;
        }
        return this.getDefaultAttribute(name);
    }

    public Iterator getAttributeNames() {
        return this.fAttributes.keySet().iterator();
    }

    public int getBase() {
        String format = this.getFormat();
        if ("decimal".equals(format)) {
            return 10;
        }
        if ("hex".equals(format)) {
            return 16;
        }
        if ("octal".equals(format)) {
            return 8;
        }
        if ("binary".equals(format)) {
            return 2;
        }
        return 0;
    }

    public int getBitLengthValue(int defaultValue) {
        int length;
        String lengthString;
        int size = -1;
        String name = this.getAttribute("type");
        if (name != null) {
            if ("boolean".equals(name) || name.endsWith("byte")) {
                size = 1;
            } else if (name.endsWith("short") || name.endsWith("char")) {
                size = 2;
            } else if (name.endsWith("int") || name.endsWith("float")) {
                size = 4;
            } else if (name.endsWith("long") || name.endsWith("double")) {
                size = 8;
            }
        }
        if ((lengthString = this.getLength()) == null) {
            lengthString = "-1";
        }
        if ((length = Integer.parseInt(lengthString)) == -1) {
            int xmlSize;
            String sizeString = this.getSize();
            if (sizeString != null && (xmlSize = Integer.parseInt(sizeString)) >= 0) {
                return xmlSize * 8;
            }
            if (size == -1) {
                return defaultValue;
            }
            return size * 8;
        }
        return length;
    }

    public int getBitOffsetValue(int defaultValue) {
        int index = this.getIndex() != null ? Integer.parseInt(this.getIndex()) : -1;
        int offset = this.getOffset() != null ? Integer.parseInt(this.getOffset()) : -1;
        if (offset == -1) {
            if (index == -1) {
                return defaultValue;
            }
            return index * 8;
        }
        return offset;
    }

    public String getBundleId() {
        String bundleId = this.getAttribute("bundleid");
        if (bundleId != null) {
            return bundleId;
        }
        if (this.getParent() != null) {
            return this.getParent().getBundleId();
        }
        return this.getId();
    }

    public String getBundleIdFull() {
        String name = this.getBundleId();
        return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
    }

    public String getBundleName() {
        String bundle = this.getAttribute("bundle");
        if (bundle != null) {
            return bundle;
        }
        if (this.getParent() != null) {
            return this.getParent().getBundleName();
        }
        String id = this.getId();
        if (id != null) {
            return id;
        }
        String idref = this.getAttribute("idref");
        int index = idref.indexOf(35);
        if (index < 0) {
            return idref;
        }
        return idref.substring(index + 1);
    }

    public List getByteChildren() {
        return this.getAllChildrenWithTagCodes(new int[]{12, 25, 40, 63, 696});
    }

    public List getChildren() {
        return this.fChildren;
    }

    public List getChildrenWithTagCode(int code) {
        ArrayList vector = new ArrayList();
        int i = 0;
        while (i < this.getChildren().size()) {
            if (((TagElement)this.getChildren().get(i)).getTagCode() == code) {
                vector.add(this.getChildren().get(i));
            } else if (((TagElement)this.getChildren().get(i)).getTagCode() == 1000 + code) {
                vector.add(this.getChildren().get(i));
            }
            ++i;
        }
        return vector;
    }

    public List getChildrenWithTagCodes(int[] codes) {
        ArrayList vector = new ArrayList();
        int i = 0;
        while (i < this.getChildren().size()) {
            int j = 0;
            while (j < codes.length) {
                if (((TagElement)this.getChildren().get(i)).getTagCode() == codes[j]) {
                    vector.add(this.getChildren().get(i));
                } else if (((TagElement)this.getChildren().get(i)).getTagCode() == 1000 + codes[j]) {
                    vector.add(this.getChildren().get(i));
                }
                ++j;
            }
            ++i;
        }
        return vector;
    }

    public String getClassNameFull() {
        int index;
        String name = this.getAttribute("implementation");
        if (name == null || name.length() == 0) {
            name = this.getAttribute("id");
            if (name == null) {
                name = this.getAttribute("idref");
            }
            if ((index = name.indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName;
                    String packageName = projectName = url.substring(0, sindex);
                    name = String.valueOf(packageName) + '.' + name;
                }
            } else {
                String prefix = this.getPackageBase();
                if (prefix != null) {
                    return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, prefix)) + '.' + name;
                }
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String getCodenameRaw() {
        return this.getAttribute("codename");
    }

    public List getConcreteChildren() {
        return this.getAllChildrenWithTagCode(18);
    }

    public ConfigurationField[] getConfigurationOptions() {
        return new ConfigurationField[0];
    }

    public String getConfigurationValue(String key, String value) {
        Object propertyValue = this.getProperties().get(key);
        if (propertyValue != null) {
            return propertyValue.toString();
        }
        return value;
    }

    public List getConfigurations() {
        return new ArrayList();
    }

    public String getConnectionTag() {
        return this.getTagName();
    }

    public String getConnectionType() {
        if (this.isMultiplex()) {
            return String.valueOf(this.getConnectionTag().toLowerCase()) + "multiplex";
        }
        return this.getConnectionTag().toLowerCase();
    }

    private String getDefaultAttribute(String name) {
        return this.fDefaults.getDefaultValue(name);
    }

    protected String getDefaultFieldComment() {
        String unitsDocumentation;
        String key = this.getKey();
        if (key == null) {
            key = this.getIdRef();
        }
        StringBuffer buffer = new StringBuffer(128);
        String dataTypeDocumentation = this.getParameterDataTypeDocumentation();
        if (dataTypeDocumentation != null && dataTypeDocumentation.length() > 0) {
            buffer.append(" <code>");
            buffer.append(dataTypeDocumentation);
            buffer.append("</code>");
        }
        if ((unitsDocumentation = this.getUnitsDocumentation()) != null && unitsDocumentation.length() > 0) {
            buffer.append(" ");
            buffer.append(unitsDocumentation);
        }
        if (!this.isRequiredParameter()) {
            buffer.append(" <i>optional</i>");
        }
        return this.format("Defines the {0} {1}{2}.", new String[]{key, this.getNiceName(), buffer.toString()});
    }

    public String getDefaultMeasurementValue() {
        return "null";
    }

    public String getDefaultPackage() {
        if (this.fDefaultPackage != null) {
            return this.fDefaultPackage;
        }
        if (this.getParent() != null) {
            return this.getParent().getDefaultPackage();
        }
        return null;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public List getDeviceChildren() {
        return this.getAllChildrenWithTagCode(8);
    }

    public String getDisplayLabel() {
        String text = this.getDisplayLabelRaw();
        if (text != null && text.length() > 0) {
            return text;
        }
        if (this.checkDisplayChildren()) {
            List list = this.getChildren();
            int i = 0;
            while (i < list.size()) {
                TagElement child = (TagElement)list.get(i);
                String childText = child.getDisplayLabelRaw();
                if (childText != null && childText.length() > 0) {
                    return childText;
                }
                ++i;
            }
        }
        return this.getTagName();
    }

    public String getDisplayLabelRaw() {
        String key = this.getKey();
        if (key != null) {
            return key;
        }
        String idref = this.getIdRef();
        if (idref != null) {
            int index = idref.lastIndexOf(35);
            if (index >= 0) {
                return idref.substring(index + 1);
            }
            return idref;
        }
        String text = ParserUtilities.extractData(this.getNode());
        if (text != null && text.length() > 0) {
            if (text.length() > 64) {
                return text.substring(0, 63);
            }
            return text;
        }
        return "";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TagElement getElement(String fieldName) {
        return null;
    }

    public String getExternalId() {
        String groupId;
        TagElement parent;
        String id = this.getId();
        if (id != null && (parent = this.getParent()) != null && (groupId = parent.getGroupId()) != null && groupId.length() > 0) {
            StringBuffer buffer = new StringBuffer(groupId.length() + 1 + id.length());
            buffer.append(groupId);
            buffer.append('/');
            buffer.append(id);
            return buffer.toString();
        }
        return id;
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getFactoryNameFull() {
        int index;
        String name = this.getAttribute("factory");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null && (index = (name = this.getAttribute("idref")).indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName = url.substring(0, sindex);
                    String packageName = String.valueOf(projectName) + ".factory";
                    name = String.valueOf(packageName) + '.' + name;
                }
            }
            if (name.length() > 0) {
                name = String.valueOf(name) + "Factory";
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String[] getFieldComment() {
        String fieldExtraComment = this.getFieldExtraComment("");
        StringBuffer buffer = new StringBuffer(512);
        if (this.getDescription() != null) {
            buffer.append(this.getDescription());
        } else {
            buffer.append(this.getDefaultFieldComment());
        }
        if (fieldExtraComment != null && fieldExtraComment.length() > 0) {
            buffer.append("\n<p>\n");
            buffer.append(fieldExtraComment);
            buffer.append("\n</p>");
        }
        return DeviceKitUtilities.convertStringToArray(buffer.toString());
    }

    public String getFieldExtraComment(String fieldName) {
        return "";
    }

    public List getFilterChildren() {
        return this.getAllChildrenWithTagCode(6);
    }

    public List getFilterChildren(boolean includeRef) {
        return this.getAllChildrenWithTagCode(6, includeRef);
    }

    public String getFormat() {
        TagElement parent;
        String format = this.getAttribute("format");
        if (format.length() == 0 && (parent = this.getParent()) != null) {
            return parent.getFormat();
        }
        return format;
    }

    public String getGroupId() {
        return "";
    }

    public List getHistoryChildren() {
        return this.getAllChildrenWithTagCode(147);
    }

    public String getId() {
        return this.getAttribute("id");
    }

    protected String getIdForMessage(String parentId, TagElement me) {
        if (parentId == null || me.getAttribute("idref") != null) {
            return null;
        }
        String messageId = String.valueOf(parentId) + "Message";
        if (collection.getMessage(messageId) != null) {
            int i = 0;
            while (i < 100) {
                messageId = String.valueOf(parentId) + i + "Message";
                if (collection.getMessage(messageId) == null) {
                    return messageId;
                }
                ++i;
            }
            return null;
        }
        return messageId;
    }

    public String getIdRaw() {
        return this.getAttribute("id");
    }

    public String getIdRef() {
        return this.getAttribute("idref");
    }

    public String getImplementation() {
        String implementation = this.getAttribute("implementation");
        if (implementation != null) {
            return implementation;
        }
        if (this.getParent() != null) {
            return this.getParent().getImplementation();
        }
        return this.getId();
    }

    public String getIndex() {
        return null;
    }

    public String getInitialVersion() {
        if (this.initialVersion == null) {
            List historyList = this.getHistoryChildren();
            int size = historyList.size();
            String bestVersion = null;
            int index = 0;
            while (index < size) {
                HistoryElement history = (HistoryElement)historyList.get(index);
                String version = history.getVersion();
                if (version != null) {
                    if (bestVersion == null) {
                        bestVersion = version;
                    } else if (bestVersion.compareTo(version) > 0) {
                        bestVersion = version;
                    }
                }
                ++index;
            }
            if (bestVersion == null) {
                bestVersion = "1.0";
            }
            this.initialVersion = bestVersion;
        }
        return this.initialVersion;
    }

    public String getInitialVersionSince() {
        String initialVersion = this.getInitialVersion();
        if (initialVersion == null || initialVersion.length() == 0) {
            return "1.0";
        }
        StringTokenizer tokenizer = new StringTokenizer(initialVersion, ".");
        int count = tokenizer.countTokens();
        if (count <= 2) {
            return initialVersion;
        }
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(tokenizer.nextToken());
        buffer.append('.');
        buffer.append(tokenizer.nextToken());
        return buffer.toString();
    }

    public int getInteger(String tagName, int defaultValue) {
        String string = this.getString(tagName);
        if (string == null) {
            return defaultValue;
        }
        return Integer.parseInt(string);
    }

    public String getKey() {
        if (this.fKey != null) {
            return this.fKey;
        }
        return this.getId();
    }

    protected String getKey(boolean noId) {
        if (noId) {
            return this.fKey;
        }
        return this.getKey();
    }

    protected String getLength() {
        return "-1";
    }

    public int getLengthDefault() {
        return 0;
    }

    public int getLengthDefault(Object value) {
        if (value instanceof Double) {
            return 64;
        }
        if (value instanceof Float) {
            return 32;
        }
        if (value instanceof Character) {
            return 16;
        }
        if (value instanceof Boolean) {
            return 1;
        }
        if (value instanceof Byte) {
            return 8;
        }
        if (value instanceof Boolean) {
            return 1;
        }
        if (value instanceof Short) {
            return 16;
        }
        if (value instanceof Integer) {
            return 32;
        }
        if (value instanceof Long) {
            return 64;
        }
        if (value instanceof Number) {
            return 32;
        }
        if (value instanceof BigInteger) {
            byte[] bytes = ((BigInteger)value).toByteArray();
            return bytes.length << 3;
        }
        if (value instanceof BigDecimal) {
            byte[] bytes = ((BigDecimal)value).toBigInteger().toByteArray();
            return bytes.length << 3;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes.length << 3;
        }
        if (value instanceof String) {
            byte[] bytes = value.toString().getBytes();
            return bytes.length << 3;
        }
        return 0;
    }

    public String getManagedNameFull() {
        int index;
        String name = this.getAttribute("factory");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null && (index = (name = this.getAttribute("idref")).indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName = url.substring(0, sindex);
                    String packageName = String.valueOf(projectName) + ".managed";
                    name = String.valueOf(packageName) + '.' + name;
                }
            }
            if (name.length() > 0) {
                name = String.valueOf(name) + "Managed";
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public List getMessageChildren() {
        return this.getAllChildrenWithTagCodes(new int[]{7, 152, 153, 154, 50});
    }

    public List getMessageChildren(boolean includeRef) {
        return this.getAllChildrenWithTagCodes(DeviceKitTagConstants.ALL_MESSAGE_CODES, includeRef);
    }

    public List getMessageClassElements() {
        List elements = new ArrayList();
        int i = 0;
        while (i < this.getChildren().size()) {
            if (((TagElement)this.getChildren().get(i)).isMessageClassElement() && ((TagElement)this.getChildren().get(i)).getId() != null) {
                elements.add(this.getChildren().get(i));
            }
            List childElements = ((TagElement)this.getChildren().get(i)).getMessageClassElements();
            elements = DeviceKitUtilities.mergeLists(elements, childElements);
            ++i;
        }
        return elements;
    }

    public String getNameRaw() {
        return this.getAttribute("name");
    }

    public String getNiceName() {
        return this.getNiceName(this.getTagName());
    }

    public String getNiceName(String name) {
        int length = name.length();
        if (name.endsWith("block")) {
            if (length > 5) {
                return String.valueOf(this.getNiceName(name.substring(0, length - 5))) + " block";
            }
        } else if (name.endsWith("segment")) {
            if (length > 7) {
                return String.valueOf(this.getNiceName(name.substring(0, length - 7))) + " segment";
            }
        } else if (name.endsWith("parameter")) {
            if (length > 9) {
                return String.valueOf(this.getNiceName(name.substring(0, length - 9))) + " parameter";
            }
        } else if (name.endsWith("ref")) {
            if (length > 9) {
                return String.valueOf(this.getNiceName(name.substring(0, length - 9))) + " reference";
            }
        } else if (name.startsWith("unsigned") && length > 8) {
            return "unsigned " + this.getNiceName(name.substring(8));
        }
        return name;
    }

    public Node getNode() {
        return this.fNode;
    }

    public String getOffset() {
        return null;
    }

    public List getOutlineChildren() {
        ArrayList<TagElement> result = new ArrayList<TagElement>();
        List children = this.getChildren();
        Node mynode = this.getNode();
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.get(i);
            Node childparent = element.getNode().getParentNode();
            if (mynode == childparent) {
                result.add(element);
            } else {
                TagElementLink link = new TagElementLink(element.getNode(), this);
                result.add(link);
            }
            ++i;
        }
        return result;
    }

    public String getPackageBase() {
        if (this.packageBase == null) {
            if (this.getParent() != null) {
                return this.getParent().getPackageBase();
            }
            return fPackageBase;
        }
        return this.packageBase;
    }

    public List getParameterChildren() {
        return this.getChildrenWithTagCodes(new int[]{23, 5});
    }

    public List getParameterChildrenAll() {
        return this.getAllChildrenWithTagCodes(new int[]{23, 5});
    }

    public String getParameterDataType() {
        String type = this.getAttribute("type");
        if (type != null) {
            return type;
        }
        return "";
    }

    public String getParameterDataTypeDocumentation() {
        return this.getParameterDataType();
    }

    public TagElement getParent() {
        return this.fParent;
    }

    public List getProfileChildren() {
        return this.getAllChildrenWithTagCode(74);
    }

    public String getProjectId() {
        String type = this.getType();
        if (type != null && type.indexOf(46) >= 0) {
            return DeviceKitUtilities.extractPackage(type);
        }
        return "";
    }

    public Map getProperties() {
        return new HashMap();
    }

    public TagElement getRealElement() {
        return this;
    }

    public List getRequiredBundles() {
        return new ArrayList();
    }

    public String[] getServiceFieldComment() {
        return this.getFieldComment();
    }

    public String getServiceName() {
        int index;
        String name = this.getAttribute("service");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null) {
                name = this.getAttribute("idref");
                if (name == null) {
                    name = this.getAttribute("id");
                }
                if (name != null && (index = name.indexOf(35)) >= 0) {
                    name = name.substring(index + 1);
                }
            }
            if (name != null && name.length() > 0) {
                name = String.valueOf(name) + "Service";
            }
        }
        if (name != null && name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String getServiceNameFull() {
        int index;
        String name = this.getAttribute("service");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null && (index = (name = this.getAttribute("idref")).indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName = url.substring(0, sindex);
                    String packageName = String.valueOf(projectName) + ".service";
                    name = String.valueOf(packageName) + '.' + name;
                }
            }
            if (name.length() > 0) {
                name = String.valueOf(name) + "Service";
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String getServiceType() {
        return this.getType();
    }

    protected String getSize() {
        return "-1";
    }

    public String getString(String tagName) {
        return this.getString(tagName, null);
    }

    public String getString(String tagName, String defaultString) {
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            if (tagName.equals(((TagElement)list.get(i)).getTagName())) {
                if (((TagElement)list.get(i)).getTextData() != null) {
                    return ((TagElement)list.get(i)).getTextData();
                }
                return defaultString;
            }
            ++i;
        }
        return defaultString;
    }

    public String getSuperclassFull() {
        int index;
        String name = this.getAttribute("superclass");
        if (name == null || name.length() == 0) {
            return this.getSuperclassFullDefault();
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String getSuperclassFullDefault() {
        return this.getType();
    }

    public abstract int getTagCode();

    public String getTagName() {
        return this.tagName;
    }

    public Map getTemplateVariables() {
        return this.fVariables;
    }

    public String getTextData() {
        return this.fTextData;
    }

    public String getTextDataFix() {
        String string = this.getTextData();
        if (string == null) {
            return new String();
        }
        if (string.length() == 1) {
            return string;
        }
        StringBuffer result = new StringBuffer(string.length());
        char[] array = string.toCharArray();
        int i = 0;
        block11: while (i < array.length) {
            if (array[i] == '\\') {
                if (++i > array.length) {
                    throw this.error("Invalid character sequence" + this.toString());
                }
                switch (array[i]) {
                    case 'b': {
                        result.append('\b');
                        ++i;
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        ++i;
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        ++i;
                        break;
                    }
                    case '\'': {
                        result.append('\'');
                        ++i;
                        break;
                    }
                    case '\"': {
                        result.append('\"');
                        ++i;
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        ++i;
                        break;
                    }
                    case 'u': {
                        throw this.error("Invalid character sequence" + this.toString());
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        result.append(array[i]);
                        if (++i < array.length) {
                            if (Character.isDigit(array[i])) {
                                result.append(array[i]);
                                ++i;
                            }
                        } else {
                            throw this.error("Invalid character sequence" + this.toString());
                        }
                        if (i < array.length) {
                            if (!Character.isDigit(array[i])) continue block11;
                            result.append(array[i]);
                            ++i;
                            break;
                        }
                        throw this.error("Invalid character sequence: " + this.toString());
                    }
                }
                continue;
            }
            result.append(array[i]);
            ++i;
        }
        return result.toString();
    }

    public List getTransformChildren() {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().get(i) instanceof TransformItem) {
                result.add(this.getChildren().get(i));
            }
            ++i;
        }
        return result;
    }

    public List getTransportServiceChildren() {
        return this.getAllChildrenWithTagCode(15);
    }

    public String getType() {
        if (this.fType == null) {
            this.fType = this.findType();
        }
        return this.fType;
    }

    public String getTypeWithoutPackage() {
        return DeviceKitUtilities.stripPackage(this.getType());
    }

    public String getUnits() {
        List list = this.getChildrenWithTagCode(4);
        if (list.size() > 0) {
            TagElement unitsElement = (TagElement)list.get(0);
            return unitsElement.getTextData();
        }
        return "";
    }

    public String getUnitsDocumentation() {
        List list = this.getChildrenWithTagCode(4);
        if (list.size() > 0) {
            TagElement unitsElement = (TagElement)list.get(0);
            String description = unitsElement.getDescription();
            if (description != null && description.length() > 0) {
                return description;
            }
            return unitsElement.getTextData();
        }
        return "";
    }

    public List getValueChildren() {
        return this.getChildrenWithTagCode(13);
    }

    public String getVersion() {
        return this.version;
    }

    public String getXmlLanguageRaw() {
        String lang = this.getAttribute("xml:lang");
        if (lang != null && lang.length() > 0) {
            return lang;
        }
        return this.getAttribute("lang");
    }

    protected void handleAsciiMessage(Node node) {
        AsciiMessageElement me = new AsciiMessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("description".equals(childNodeName)) {
            this.handleDescription(childNode);
        } else if ("version".equals(childNodeName)) {
            this.handleVersion(childNode);
        } else if ("deprecated".equals(childNodeName)) {
            this.handleDeprecated(childNode);
        } else if ("history".equals(childNodeName)) {
            this.handleHistory(childNode);
        } else if ("displayname".equals(childNodeName)) {
            this.handleDisplayName(childNode);
        } else if ("optional".equals(childNodeName)) {
            this.handleOptional(childNode);
        } else if ("units".equals(childNodeName)) {
            this.handleUnits(childNode);
        } else if ("specreference".equals(childNodeName)) {
            this.handleSpecReference(childNode);
        } else if ("key".equals(childNodeName)) {
            this.handleKey(childNode);
        } else if ("multiplex".equals(childNodeName)) {
            this.handleMultiplex(childNode);
        }
    }

    protected void handleDeprecated(Node node) {
        DeprecatedElement element = new DeprecatedElement(node, this);
        this.addChild(element);
        if (this.deprecated == null || this.deprecated.length() == 0) {
            this.setDeprecated(ParserUtilities.extractData(node));
        }
    }

    protected void handleDescription(Node node) {
        DescriptionElement element = new DescriptionElement(node, this);
        this.addChild(element);
        if (this.description == null || this.description.length() == 0) {
            this.setDescription(ParserUtilities.extractData(node));
        }
    }

    protected void handleDisplayName(Node node) {
        DisplayNameElement element = new DisplayNameElement(node, this);
        this.addChild(element);
        if (this.displayName == null || this.displayName.length() == 0) {
            this.setDisplayName(ParserUtilities.extractData(node));
        }
    }

    protected void handleHistory(Node node) {
        HistoryElement element = new HistoryElement(node, this);
        this.addChild(element);
        this.setInitialVersion(ParserUtilities.extractData(node));
    }

    protected void handleKey(Node node) {
        KeyElement element = new KeyElement(node, this);
        this.addChild(element);
        this.setKey(ParserUtilities.extractData(node));
    }

    protected void handleMessage(Node node) {
        MessageElement me = new MessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleMultiplex(Node node) {
        MultiplexElement element = new MultiplexElement(node, this);
        this.addChild(element);
    }

    protected void handleOptional(Node node) {
        OptionalElement element = new OptionalElement(node, this);
        this.addChild(element);
    }

    protected Node handleReference(Node node) {
        int i = 0;
        while (i < references.size()) {
            ArrayList small = new ArrayList();
            small.add(references.get(i));
            AnchorUtil util = new AnchorUtil(node, small);
            InputStream stream = null;
            try {
                stream = util.getAnchorFile();
                Document refDoc = ParserUtilities.parse(stream);
                stream.close();
                Node rnode = util.findAnchor(refDoc);
                if (rnode != null) {
                    return rnode;
                }
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
            ++i;
        }
        return null;
    }

    protected void handleSignal(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new SignalLinkElement(node, this));
        } else {
            SignalElement se = new SignalElement(node, this);
            this.addChild(se);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    collection.addSignal(se.getId(), se);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    protected void handleSpecReference(Node node) {
        SpecReferenceElement element = new SpecReferenceElement(node, this);
        String id = element.getId();
        if (id != null) {
            this.addChild(element);
            try {
                collection.addSpecReference(id, element);
            }
            catch (Exception exception) {}
        } else {
            SpecReferenceElement realSpec;
            String idref = element.getAttribute("idref");
            if (idref != null && (realSpec = (SpecReferenceElement)collection.getSpecReference(idref)) != null) {
                this.addChild(realSpec);
            }
        }
    }

    protected void handleStringMessage(Node node) {
        StringMessageElement me = new StringMessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleUnits(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new UnitsLinkElement(node, this));
        } else {
            UnitsElement element = new UnitsElement(node, this);
            this.addChild(element);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    collection.addUnits(element.getId(), element);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    protected void handleUtf8Message(Node node) {
        Utf8MessageElement me = new Utf8MessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleValue(Node node) {
        ValueElement element = new ValueElement(node, this);
        this.addChild(element);
    }

    protected void handleVersion(Node node) {
        VersionElement element = new VersionElement(node, this);
        this.addChild(element);
        this.setVersion(ParserUtilities.extractData(node));
    }

    public boolean hasChildWithTagCode(int code) {
        int i = 0;
        while (i < this.getChildren().size()) {
            if (((TagElement)this.getChildren().get(i)).getTagCode() == code) {
                return true;
            }
            if (((TagElement)this.getChildren().get(i)).getTagCode() == 1000 + code) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasChildWithTagCode(int[] codes) {
        int index = 0;
        while (index < codes.length) {
            int code = codes[index];
            int i = 0;
            while (i < this.getChildren().size()) {
                if (((TagElement)this.getChildren().get(i)).getTagCode() == code) {
                    return true;
                }
                if (((TagElement)this.getChildren().get(i)).getTagCode() == 1000 + code) {
                    return true;
                }
                ++i;
            }
            ++index;
        }
        return false;
    }

    public boolean hasTransformChild() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof TransformItem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initialize() {
    }

    public boolean isChildOfCode(int code) {
        TagElement parent = this.getParent();
        while (parent != null) {
            if (parent.getTagCode() == code) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public boolean isChildOfCode(int[] codes) {
        TagElement parent = this.getParent();
        while (parent != null) {
            int i = 0;
            while (i < codes.length) {
                int code = codes[i];
                if (parent.getTagCode() == code) {
                    return true;
                }
                ++i;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public boolean isConstantParameter() {
        return true;
    }

    public boolean isFilterValid() {
        return true;
    }

    public boolean isFollowReferences() {
        return this.followReferences;
    }

    public boolean isLittleEndian() {
        return this.getAllChildrenWithTagCode(41).size() > 0;
    }

    public boolean isMessageClassElement() {
        return false;
    }

    public boolean isMultiplex() {
        return this.getAllChildrenWithTagCode(103).size() > 0;
    }

    public boolean isOld() {
        String old = this.getAttribute("old");
        if (old != null) {
            return Boolean.valueOf(old);
        }
        return DeviceKitPlugin.getGenerateOld();
    }

    public boolean isOptional() {
        return this.getAllChildrenWithTagCode(102).size() > 0;
    }

    public boolean isReferencedIdref(Node node) {
        return DkmlReferenceResolver.hasReferenceRef(node);
    }

    public boolean isRequiredParameter() {
        return true;
    }

    public final TagElement lookupField(String fieldName) {
        TagElement tagElement;
        String any = this.getAnyId();
        if (fieldName.equals(any)) {
            return this;
        }
        List list = this.getRealElement().getChildren();
        int i = 0;
        while (i < list.size()) {
            tagElement = (TagElement)list.get(i);
            String key = tagElement.getAnyId();
            if (key != null && key.length() > 0 && fieldName.equals(key)) {
                return tagElement;
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            TagElement fieldControl;
            tagElement = (TagElement)list.get(i);
            String controlKey = tagElement.getAnyId();
            if (any != null && !any.equals(controlKey) && (fieldControl = tagElement.lookupField(fieldName)) != null) {
                return fieldControl;
            }
            ++i;
        }
        return this.getRealElement().getElement(fieldName);
    }

    protected void setAttribute(String name, String value) {
        this.fAttributes.put(name, value);
    }

    protected void setChildren(TagElement[] children) {
        this.fChildren = new ArrayList();
        int i = 0;
        while (i < children.length) {
            this.fChildren.add(children[i]);
            ++i;
        }
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setFollowReferences(boolean followReferences) {
        this.followReferences = followReferences;
    }

    public void setInitialVersion(String initialVersion) {
        this.initialVersion = initialVersion;
    }

    protected void setKey(String key) {
        this.fKey = key;
    }

    protected void setPackageBase(String packageBase) {
        fPackageBase = packageBase;
        this.packageBase = packageBase;
        this.fDefaultPackage = packageBase;
    }

    protected void setParent(TagElement parent) {
        this.fParent = parent;
    }

    protected void setTagName(String tagName) {
        this.tagName = tagName;
    }

    protected void setTextData(String data) {
        this.fTextData = data;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    protected String toNewArrayString(String type) {
        return String.valueOf(this.toNewString(type)) + "[]";
    }

    protected String toNewString(String type) {
        return "new " + DeviceKitUtilities.stripPackage(type);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getNode() != null) {
            Node parent = this.getNode().getParentNode();
            if (parent instanceof TagElement) {
                buffer.append(this.toString((TagElement)((Object)parent)));
                buffer.append("\r\n");
            }
            buffer.append("<");
            buffer.append(this.getTagName());
            Iterator map = this.getAttributeNames();
            while (map.hasNext()) {
                String name = (String)map.next();
                buffer.append(' ');
                buffer.append(String.valueOf(name) + " = \"" + this.getAttribute(name));
                buffer.append('\"');
            }
            String key = this.getKey();
            if (key != null && key.length() > 0) {
                buffer.append(" key=");
                buffer.append(key);
            }
            buffer.append(">");
        } else {
            TagElement parent = this.getParent();
            if (parent != null) {
                buffer.append(parent.toString());
                buffer.append("\r\n");
            }
        }
        return buffer.toString();
    }

    public String toString(TagElement element) {
        StringBuffer buffer = new StringBuffer();
        int parentCount = 0;
        TagElement temp = element;
        while (temp.getParent() != null) {
            ++parentCount;
            temp = temp.getParent();
        }
        TagElement parent = element.getParent();
        if (parent != null) {
            buffer.append(this.toString(parent));
            buffer.append("\r\n");
        }
        int i = 0;
        while (i < parentCount) {
            buffer.append(' ');
            ++i;
        }
        buffer.append("<");
        buffer.append(element.getTagName());
        if (element.getAttribute("id") != null) {
            buffer.append(" id=\"");
            buffer.append(element.getAttribute("id"));
            buffer.append('\"');
        }
        buffer.append(">");
        return buffer.toString();
    }

    public final void updateBytes(BytesGenerator bytesGenerator) {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = collection.getParameter(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        if (!this.isFilterValid()) {
            bytesGenerator.setFilterValid(false);
        }
        realElement.updateBytes(bytesGenerator, this.isFilterValid());
    }

    public void updateBytes(BytesGenerator bytesGenerator, boolean filterValid) {
        int length = this.getBitLengthValue(this.getLengthDefault());
        if (length > 0 && this.getOffset() == null & this.getIndex() == null) {
            String comment = this.getId();
            if (comment == null && (comment = this.getIdRef()) == null) {
                comment = "";
            }
            bytesGenerator.add(length, 0L, false, comment);
        }
        this.updateBytesChildren(bytesGenerator, filterValid);
    }

    public void updateBytesChildren(BytesGenerator bytesGenerator, boolean filterValid) {
        if (filterValid && this.isFilterValid()) {
            List parameters = this.getParameterChildren();
            int parameterSize = parameters.size();
            int newCode = 0;
            if (parameterSize > 0) {
                int i = 0;
                while (i < parameterSize) {
                    TagElement tagElement = (TagElement)parameters.get(i);
                    if (tagElement instanceof GeneralParameterElement) {
                        ++newCode;
                    }
                    tagElement.updateBytes(bytesGenerator);
                    ++i;
                }
            }
        }
    }

    protected void validate() {
    }
}

