/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.internal.model.java.Parameter;
import org.eclipse.soda.devicekit.generator.metadata.MetaDataUtility;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.FactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestAgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestCaseElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.save.java.eclipse.DeviceKitResourceBundleSaver;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTestAgentGenerator
extends AbstractDkGenerator {
    protected static int DEFAULT_MSG_START_KEY = 1000;
    protected int bundleType = 0;
    protected int currentMsgKey;
    protected Properties dkMessages = new MessageProperties();
    protected JavaFileModel fResourceBundle_en_USModel;
    protected JavaFileModel fResourceBundleModel;
    protected TestAgentElement fTest;
    protected JavaFileModel fTestModel;
    protected JavaFileModel fTestSuiteModel;
    private String pack;
    protected List testcases = new ArrayList();

    protected DkTestAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap());
    }

    protected DkTestAgentGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void addTestcase(JavaFileModel testcase) {
        this.testcases.add(testcase);
    }

    protected void cleanup() {
        EscPropertiesModel.getModel(this).addProperty("esc.tracelevel", "0");
    }

    protected void codeBAActivate(IType ba) {
        String[] comment = new String[]{"Activates the bundle.", "@see " + this.getMainFqn()};
        String contents = this.getBAActivateContents();
        this.codeMethod(ba, "activate", comment, "void", 4L, contents);
    }

    protected void codeBAFields(IType ba) {
        super.codeBAFields(ba);
    }

    protected void codeBAGetImportedServiceNames(IType ba) {
        this.codeBAGetImportedServiceNames(this.fTest.getBundleName(), ba);
    }

    protected void codeBAGetMatchDeviceClasses(IType ba) {
        this.codeBAMatchingDevicesField(ba, this.quote(this.getMainClassName()));
        StringBuffer comment = new StringBuffer(32);
        comment.append("Return the match strings.\n");
        comment.append("@return Array of Strings containing ");
        comment.append(this.getNonTestClass());
        comment.append('.');
        this.codeBAGetMatchingDevicesMethod(ba, comment.toString());
    }

    protected void codeBAMethods(IType ba) {
    }

    protected void codeConstructorTestcase(IType test) {
        String name = DeviceKitUtilities.stripPackage(test.getName());
        String comment = "Constructs a new instance of the " + name + " class.";
        KeyValuePair arg = new KeyValuePair(DkUtilities.stripPackage("String"), "name");
        this.codeMethod(test, name, comment, null, 1L, "super(name);\n", new KeyValuePair[]{arg}, null);
    }

    protected void codeConstructors(IType test) {
        String name = DeviceKitUtilities.stripPackage(test.getName());
        String comment = "Constructs a new instance of the " + name + " class.";
        this.codeMethod(test, name, comment, null, 1L, "super();\n");
    }

    protected void codeDefaultResourceBundleField(IType test) {
        String fieldValue = "Nls.getResourceBundle(" + this.getResourceBundleClassName() + ".class)";
        this.codeField(test, "DefaultResourceBundle", "ResourceBundle", 49L, "", fieldValue);
    }

    protected void codeDescriptionMsgKeyField(IType test) {
        String msgKey = this.consumeMsgKey();
        this.codeField(test, "DESCRIPTION_KEY", "int", 49L, "Define the DESCRIPTION_KEY constant.", msgKey);
        String description = this.getDescription();
        this.dkMessages.put(msgKey, description);
    }

    protected void codeErrorOccurred(IType test, String header, String argument) {
        String contents = this.getErrorOccurredContents(header, argument);
        KeyValuePair parameter1 = new KeyValuePair("Object", argument);
        KeyValuePair parameter2 = new KeyValuePair("Object", "timestamp");
        KeyValuePair parameter3 = new KeyValuePair("Object", "data");
        KeyValuePair[] parameters = new KeyValuePair[]{parameter1, parameter2, parameter3};
        this.codeMethod(test, "errorOccurred", "The errorOccurred method is called when an error occurs.", "void", 1L, contents, parameters, null);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
    }

    protected void codeExtraMsgFields(IType test) {
        String[][] fieldValuePairs = this.getExtraMsgFieldValues();
        int i = 0;
        while (i < fieldValuePairs.length) {
            String comment = "Define the " + fieldValuePairs[i][1] + " (" + "int" + ") constant.";
            String msgKey = this.consumeMsgKey();
            this.codeField(test, fieldValuePairs[i][0], "int", 49L, comment, msgKey);
            this.dkMessages.setProperty(msgKey, fieldValuePairs[i][1]);
            ++i;
        }
    }

    protected void codeFields(IType test) {
        this.codeClassNameField(test, this.getMainFqn());
        this.codeDefaultResourceBundleField(test);
        this.codeDescriptionMsgKeyField(test);
    }

    protected void codeGetDescription(IType test) {
        String contents = "return " + this.getServiceClass() + ".SERVICE_DESCRIPTION;\n";
        this.codeMethod(test, "getDescription", "Gets the description (String) value.", "String", 1L, contents);
    }

    protected void codeGetKeyMethod(IType resourceBundle) {
        String[] exceptions = new String[]{"IndexOutOfBoundsException"};
        KeyValuePair[] keyValuePairs = new KeyValuePair[]{new KeyValuePair("int", "keyNumber")};
        StringBuffer content = new StringBuffer();
        content.append("final int index = Arrays.binarySearch(INTEGER_KEYS, keyNumber);\n");
        content.append("return KEYS[index];\n");
        this.codeMethod(resourceBundle, "getKey", "", "String", 17L, content.toString(), keyValuePairs, exceptions);
    }

    protected void codeGetKeysMethod(IType resourceBundle) {
        String[] exceptions = new String[]{};
        KeyValuePair[] keyValuePairs = new KeyValuePair[]{};
        StringBuffer content = new StringBuffer();
        content.append("\tfinal Enumeration enumeration = new Enumeration() {\n");
        content.append("\tprivate int index = 0;\n");
        content.append("\tpublic Object nextElement() {\n");
        content.append("\t\treturn KEYS[this.index++];\n");
        content.append("\t}\n");
        content.append("\t\tpublic boolean hasMoreElements() {\n");
        content.append("\t\treturn this.index < Values.length;\n");
        content.append("\t}\n");
        content.append("};\n");
        content.append("return enumeration;\n");
        this.codeMethod(resourceBundle, "getKeys", "", "Enumeration", 1L, content.toString(), keyValuePairs, exceptions);
    }

    protected void codeGetThread(IType test) {
        this.codeMethod(test, "getThread", "Gets the thread to be used in testing.", "Thread", 1L, "return this.thread;\n");
    }

    protected void codeHandleGetObjectMethod(IType resourceBundleClass) {
        String[] exceptions = new String[]{"MissingResourceException"};
        KeyValuePair[] keyValuePairs = new KeyValuePair[]{new KeyValuePair("String", "key")};
        StringBuffer content = new StringBuffer(1024);
        content.append("try {\n");
        content.append("\tfinal int index = Arrays.binarySearch(KEYS, key);\n");
        content.append("\treturn Values[index];\n");
        content.append("} catch (final RuntimeException exception) {\n");
        content.append("\tthrow new MissingResourceException(key, getClass().getName(), key);\n");
        content.append("}\n");
        this.codeMethod(resourceBundleClass, "handleGetObject", "", "Object", 4L, content.toString(), keyValuePairs, exceptions);
    }

    protected void codeIsActive(IType test) {
        String contents = this.getIsActiveContents();
        this.codeMethod(test, "isActive", "Gets the active status.  If true, then tests are running.", "boolean", 1L, contents);
    }

    protected void codeLoadClass(IType test) {
        String contents = "return " + this.getSuiteClassName() + ".class;\n";
        this.codeMethod(test, "loadTestClass", "Load test class and return the Class result.", "Class", 1L, contents);
    }

    protected void codeMain(IType test) {
        String targetClass = this.fTest.getImplementation();
        if (targetClass.indexOf(46) == -1) {
            String tcPack = DeviceKitUtilities.getPackageFromClassName(targetClass, this.getPackageBase());
            targetClass = String.valueOf(tcPack) + '.' + targetClass;
        }
        String[] comment = new String[]{"Main method to run tests in a stand alone mode.", "", "@param arguments", "@see " + targetClass};
        String contents = this.getMainContents();
        KeyValuePair parameter = new KeyValuePair("String[]", "arguments");
        String methodKey = MetaDataUtility.createMethodKeyFromRawData("main", null, new Parameter[]{new Parameter("String[]", "arguments")}, null);
        if (!this.useExistingMethod(test, methodKey)) {
            this.codeMethod(test, "main", comment, "void", 17L, contents, new KeyValuePair[]{parameter}, null, false);
        }
    }

    protected void codeMainTestcase(IType test) {
        String targetClass = this.fTest.getImplementation();
        if (targetClass.indexOf(46) == -1) {
            String tcPack = DeviceKitUtilities.getPackageFromClassName(targetClass, this.getPackageBase());
            targetClass = String.valueOf(tcPack) + '.' + targetClass;
        }
        String[] comment = new String[]{"Main method to run tests in a stand alone mode.", "", "@param arguments", "@see " + targetClass};
        String contents = this.getMainTestcaseContents(test);
        KeyValuePair parameter = new KeyValuePair("String[]", "arguments");
        this.codeMethod(test, "main", comment, "void", 17L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeMethods(IType test) {
        this.codeMain(test);
        this.codeLoadClass(test);
        this.codeGetDescription(test);
    }

    protected void codeResourceBundleFields(IType resourceBundleClass) {
        String key;
        this.codeClassNameField(resourceBundleClass, String.valueOf(resourceBundleClass.getPackage()) + '.' + resourceBundleClass.getName());
        StringBuffer values_local_value = new StringBuffer("new String[] {\n");
        StringBuffer keys_value = new StringBuffer("new String[] {\n");
        StringBuffer integer_keys_value = new StringBuffer("new int[] {\n");
        SortedSet keySet = new SortedSet();
        Iterator<Object> keys = this.dkMessages.keySet().iterator();
        while (keys.hasNext()) {
            String sortKey = key = String.valueOf(keys.next());
            keySet.add(sortKey);
        }
        keys = keySet.iterator();
        while (keys.hasNext()) {
            key = (String)keys.next();
            String fieldName = "MESSAGE_" + key;
            String fieldValue = "\"" + this.dkMessages.getProperty(key) + "\"";
            this.codeField(resourceBundleClass, fieldName, "String", 50L, "", fieldValue);
            values_local_value.append(fieldName);
            keys_value.append("\"" + key + "\"");
            integer_keys_value.append(key);
            if (keys.hasNext()) {
                values_local_value.append(',');
                keys_value.append(',');
                integer_keys_value.append(',');
            }
            values_local_value.append('\n');
            keys_value.append('\n');
            integer_keys_value.append('\n');
        }
        values_local_value.append("};");
        keys_value.append("};");
        integer_keys_value.append("};");
        this.codeField(resourceBundleClass, "VALUE_LOCAL", "String[]", 52L, "", values_local_value.toString());
        this.codeField(resourceBundleClass, "KEYS", "String[]", 52L, "", keys_value.toString());
        this.codeField(resourceBundleClass, "INTEGER_KEYS", "int[]", 52L, "", integer_keys_value.toString());
        this.codeField(resourceBundleClass, "Values", "String[]", 49L, "", "VALUE_LOCAL;");
    }

    protected void codeResourceBundleMethods(IType resourceBundleClass) {
        this.codeHandleGetObjectMethod(resourceBundleClass);
        this.codeGetKeyMethod(resourceBundleClass);
        this.codeGetKeysMethod(resourceBundleClass);
    }

    protected void codeRun(IType test) {
        String comment = "Run tests for the " + this.getTargetType() + '.';
        String contents = this.getRunContents();
        this.codeMethod(test, "run", comment, "void", 1L, contents);
    }

    protected void codeServiceFields(IType service) {
        super.codeServiceFields(service);
        String description_value = String.valueOf(this.getMainClassName()) + ".DefaultResourceBundle.getString(Integer.toString(" + this.getMainClassName() + ".DESCRIPTION_KEY))";
        this.codeDescriptionField(service, "SERVICE_DESCRIPTION", description_value);
    }

    protected void codeSetActive(IType test) {
        KeyValuePair parameter = new KeyValuePair("boolean", "active");
        this.codeMethod(test, "setActive", "Sets the active status.", "void", 1L, "this.active = active;\n", new KeyValuePair[]{parameter}, null);
    }

    protected void codeSetThread(IType test) {
        KeyValuePair parameter = new KeyValuePair("Thread", "thread");
        this.codeMethod(test, "setThread", "Sets the thread.", "void", 1L, "this.thread = thread;\n", new KeyValuePair[]{parameter}, null);
    }

    protected void codeStart(IType test) {
        String contents = this.getStartContents();
        this.codeMethod(test, "start", "Start the test case.", "void", 1L, contents);
    }

    protected void codeStop(IType test) {
        String contents = this.getStopContents();
        this.codeMethod(test, "stop", "Stops the test case.", "void", 1L, contents);
    }

    protected void codeSuiteMethod(IType test) throws Exception {
        String className = test.getName();
        this.fTestSuiteModel.addImport("junit.framework.Test");
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("final ");
        buffer.append(className);
        buffer.append(" suite = new ");
        buffer.append(className);
        buffer.append("();\n");
        List list = this.getMainElement().getAllChildrenWithTagCode(71);
        int i = 0;
        while (i < list.size()) {
            TestCaseElement testcase = (TestCaseElement)list.get(i);
            String testcaseId = testcase.getId();
            if (!testcaseId.equals(this.getTestcaseClassName("Abstract"))) {
                buffer.append("suite.addTest(");
                buffer.append(testcaseId);
                buffer.append(".class);\n");
            }
            ++i;
        }
        buffer.append("return suite;\n");
        this.codeMethod(test, "suite", "Create a suite and return the Test Suite result.", DeviceKitUtilities.stripPackage("junit.framework.Test"), 17L, buffer.toString());
    }

    protected void codeTest(IType test) {
        String comment = "Tests the " + this.getTargetType() + '.';
        String contents = this.getTestContents();
        this.codeMethod(test, "test", comment, "void", 1L, contents);
    }

    protected void codeTestCount(IType test) {
        String cValue = null;
        if (cValue == null) {
            cValue = "1";
        }
        String value = this.getConfStaticInt(this.getTestAgentElement(), "testcount", cValue);
        this.codeField(test, "testCount", "int", 2L, "Specifies the number of times to execute the test methods.\n", value);
    }

    protected String consumeMsgKey() {
        int result = this.currentMsgKey++;
        return String.valueOf(result);
    }

    protected IType createBundleActivatorType() throws Exception {
        String baName = this.getBundleActivatorClass();
        String baPackage = this.getBundleActivatorPackage();
        this.fBundleActivatorModel = new JavaFileModel(baName);
        this.fBundleActivatorModel.setComment(this.getCopyright());
        this.fBundleActivatorModel.setPackage(baPackage);
        IType baType = this.createClass(this.fBundleActivatorModel, baPackage, baName, this.getSourceFolderName());
        baType.setComment(this.getMainClassComment());
        String baSuperClass = this.getBASuperClass();
        baType.setSuperClass(DeviceKitUtilities.stripPackage(baSuperClass));
        this.fBundleActivatorModel.addImport(baSuperClass);
        baType.setComment(this.getBundleActivatorComment());
        return baType;
    }

    protected IType createResourceBundleType() throws Exception {
        String className = this.getResourceBundleClassName();
        String testPack = this.getMainPackage();
        this.fResourceBundleModel = new JavaFileModel(className);
        this.fResourceBundleModel.setComment(this.getCopyright());
        this.fResourceBundleModel.setPackage(testPack);
        IType resourceBundleClass = this.createClass(this.fResourceBundleModel, testPack, className, this.getSourceFolderName());
        resourceBundleClass.setComment(this.getMainClassComment());
        resourceBundleClass.setSuperClass("java.util.ResourceBundle");
        this.fResourceBundleModel.addImport("java.util.Enumeration");
        this.fResourceBundleModel.addImport("java.util.Arrays");
        this.fResourceBundleModel.addImport("java.util.MissingResourceException");
        this.codeResourceBundleFields(resourceBundleClass);
        this.codeResourceBundleMethods(resourceBundleClass);
        return resourceBundleClass;
    }

    protected IType createResourceBundle_en_USType() throws Exception {
        String className = String.valueOf(this.getResourceBundleClassName()) + "_en_US";
        String testPack = this.getMainPackage();
        this.fResourceBundle_en_USModel = new JavaFileModel(className);
        this.fResourceBundle_en_USModel.setComment(this.getCopyright());
        this.fResourceBundle_en_USModel.setPackage(testPack);
        IType resourceBundle_en_USClass = this.createClass(this.fResourceBundle_en_USModel, testPack, className, this.getSourceFolderName());
        resourceBundle_en_USClass.setComment(this.getMainClassComment());
        resourceBundle_en_USClass.setSuperClass(this.getResourceBundleClassName());
        this.codeConstructors(resourceBundle_en_USClass);
        return resourceBundle_en_USClass;
    }

    protected IType createTestSuiteType() throws Exception {
        String testName = this.getSuiteClassName();
        String testPack = this.getMainPackage();
        this.fTestSuiteModel = new JavaFileModel(testName);
        this.fTestSuiteModel.setComment(this.getCopyright());
        this.fTestSuiteModel.setPackage(testPack);
        this.fTestSuiteModel.addImport(this.getServiceFqn());
        IType test = this.createClass(this.fTestSuiteModel, testPack, testName, this.getSourceFolderName());
        test.setComment(this.getMainClassComment());
        this.fTestSuiteModel.addImport(DeviceKitGenerationConstants.CLASS_CONFIGURED_TEST_SUITE);
        this.fTestSuiteModel.addImport(DeviceKitGenerationConstants.CLASS_TEST_AGENT);
        String superClass = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONFIGURED_TEST_SUITE);
        test.setSuperClass(superClass);
        this.generateCustomItems(test);
        return test;
    }

    protected IType createTestType() throws Exception {
        String testName = this.getMainClassName();
        String testPack = this.getMainPackage();
        this.fTestModel = new JavaFileModel(testName);
        this.fTestModel.setComment(this.getCopyright());
        this.fTestModel.setPackage(testPack);
        this.fTestModel.addImport(this.getServiceFqn());
        IType test = this.createClass(this.fTestModel, testPack, testName, this.getSourceFolderName());
        test.setComment(this.getMainClassComment());
        this.fTestModel.addImport(this.fTest.getSuperClass());
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_RESOURCE_BUNDLE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CORE_NLS);
        String superClass = DeviceKitUtilities.stripPackage(this.fTest.getSuperClass());
        test.setSuperClass(superClass);
        String[] interfaces = this.getImplementedInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].indexOf(46) != -1) {
                this.fTestModel.addImport(interfaces[i]);
            }
            test.addSuperInterface(DeviceKitUtilities.stripPackage(interfaces[i]));
            ++i;
        }
        return test;
    }

    protected IType createTestcaseType(TestCaseElement element) throws Exception {
        String className;
        String testName = className = element.getId();
        String testPack = this.getMainPackage();
        JavaFileModel testcaseModel = new JavaFileModel(testName);
        testcaseModel.setComment(this.getCopyright());
        testcaseModel.setPackage(testPack);
        testcaseModel.addImport(this.getMainClassName());
        IType test = this.createClass(testcaseModel, testPack, testName, this.getSourceFolderName());
        test.setComment(this.getMainClassComment());
        testcaseModel.addImport("junit.framework.Test");
        testcaseModel.addImport(DeviceKitGenerationConstants.CLASS_TEST_AGENT);
        this.codeMainTestcase(test);
        this.codeConstructorTestcase(test);
        List testMethods = element.getAllChildrenWithTagCode(93);
        String[] exceptions = new String[]{"Exception"};
        int i = 0;
        while (i < testMethods.size()) {
            String methodName = ((TagElement)testMethods.get(i)).getAnyName();
            String methodKey = MetaDataUtility.createMethodKeyFromRawData(methodName, null, null, exceptions);
            if (!this.useExistingMethod(test, methodKey)) {
                this.codeMethod(test, methodName, "", "void", 1L, "// TODO Implement the test method", null, exceptions, false);
            }
            ++i;
        }
        String superClassFull = element.getSuperclassFull();
        String superClass = DeviceKitUtilities.stripPackage(superClassFull);
        if (!superClass.equals(this.getTestcaseClassName("Abstract"))) {
            testcaseModel.addImport(superClassFull);
        }
        test.setSuperClass(superClass);
        this.addTestcase(testcaseModel);
        this.generateCustomItems(test);
        return test;
    }

    public void generate() throws Exception {
        this.fTest = this.getTestAgentElement();
        this.setMainTagElement(this.fTest);
        this.initialize();
        if (this.isAbstract()) {
            this.generateOtherFiles();
            return;
        }
        super.generate();
        this.generateXml(0);
    }

    protected void generateBundleActivatorClass() throws Exception {
    }

    public void generateOtherFiles() throws Exception {
        super.generateOtherFiles();
        this.generateXml(0);
        this.generateLaunchCfg(0);
    }

    protected void generateSpecificClass() throws JavaModelException {
        try {
            IType test = this.createTestType();
            this.codeConstructors(test);
            this.codeFields(test);
            this.codeMethods(test);
            this.codeExtraMsgFields(test);
            this.generateCustomMainItems();
            this.generateTestCases();
            this.createResourceBundleType();
            this.createResourceBundle_en_USType();
            IType testSuite = this.createTestSuiteType();
            this.codeConstructors(testSuite);
            this.codeMainTestcase(testSuite);
            this.codeSuiteMethod(testSuite);
        }
        catch (Exception e) {
            throw new JavaModelException(e.getMessage());
        }
        this.cleanup();
    }

    protected void generateTestCases() throws Exception {
        List list = this.getMainElement().getAllChildrenWithTagCode(71);
        int i = 0;
        while (i < list.size()) {
            TestCaseElement testcase = (TestCaseElement)list.get(i);
            this.createTestcaseType(testcase);
            ++i;
        }
    }

    protected String getBAActivateContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("if (testCase != null)\n");
        buffer.append("\ttestCase.start();\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_TEST_AGENT_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_TEST_AGENT_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_TEST_AGENT_BUNDLE_ACTIVATOR;
    }

    protected String getBundleActivatorComment() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected String getCommonClassComment() {
        StringBuffer buffer = new StringBuffer(128);
        String importedServices = this.getImportedServiceComment();
        buffer.append(importedServices);
        if (importedServices.length() > 0) {
            buffer.append(" \n");
        }
        String exportedServices = this.getExportedServiceComment();
        buffer.append(exportedServices);
        if (exportedServices.length() > 0) {
            buffer.append(" \n");
        }
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected String getErrorOccurredContents(String header, String argument) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\tbuffer.append(\"" + header + ": \");\n");
        buffer.append("\tbuffer.append(" + argument + ");\n");
        buffer.append("\tbuffer.append(\"\\r\\n\terror: \");\n");
        buffer.append("\tbuffer.append(data);\n");
        buffer.append("\tbuffer.append(\" at: \");\n");
        buffer.append("\tbuffer.append(timestamp);\n");
        buffer.append("\tbuffer.append('.');\n");
        buffer.append("\tlog(");
        buffer.append(String.valueOf(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE)) + ".LOG_ERROR");
        buffer.append(", ");
        buffer.append("buffer.toString());\n");
        return buffer.toString();
    }

    protected String getExportedServiceComment() {
        StringBuffer buffer = new StringBuffer(32);
        List exports = this.getExportedServices();
        if (exports.size() > 0) {
            buffer.append("<p>The list of exported services:\n");
            int i = 0;
            while (i < exports.size()) {
                buffer.append("@see " + exports.get(i) + "\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getExportedServices() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getServiceFqn());
        return result;
    }

    protected String[][] getExtraMsgFieldValues() {
        return new String[0][0];
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{this.getServiceClass()};
    }

    private List getImportPackages(JavaFileModel fModel) {
        ArrayList<String> importPkgs = new ArrayList<String>();
        if (fModel != null) {
            String[] imports = fModel.getImports();
            int i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    importPkgs.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        return importPkgs;
    }

    protected String getImportedServiceComment() {
        StringBuffer buffer = new StringBuffer(32);
        List imports = this.getImportedServices();
        if (imports.size() > 0) {
            buffer.append("<p>The list of imported services:\n");
            int i = 0;
            while (i < imports.size()) {
                buffer.append("@see " + imports.get(i) + "\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getImportedServices() {
        ArrayList<String> result = new ArrayList<String>();
        List children = this.fTest.getAllChildrenWithTagCodes(new int[]{8, 9, 97, 15});
        int i = 0;
        while (i < children.size()) {
            String service = ((TagElement)children.get(i)).getAttribute("service");
            if (service != null) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                result.add(service);
            } else {
                String bundle = ((TagElement)children.get(i)).getAttribute("bundle");
                if (bundle != null) {
                    if (!bundle.endsWith("Service")) {
                        bundle = String.valueOf(bundle) + "Service";
                    }
                    if (bundle.indexOf(46) == -1) {
                        String pack = DeviceKitUtilities.getPackageFromClassName(bundle, this.getPackageBase());
                        bundle = String.valueOf(pack) + '.' + bundle;
                    }
                    result.add(bundle);
                }
            }
            ++i;
        }
        return result;
    }

    protected String getIsActiveContents() {
        return "";
    }

    protected String getMainClassComment() {
        return this.getAuthor_Version();
    }

    protected String getMainContents() {
        return "runMain(arguments);";
    }

    public JavaFileModel getMainModel() {
        return this.fTestModel;
    }

    protected String getMainTestcaseContents(IType test) {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("TestAgent.main(new String [] {");
        buffer.append(test.getName());
        buffer.append(".class.getName()});");
        return buffer.toString();
    }

    protected String[] getManifestCategories() {
        return new String[]{"device", "testing", "example"};
    }

    protected List getManifestExportPackages() {
        IPackageFragment packageFragment;
        List vector = super.getManifestExportPackages();
        String mainPackage = this.getMainPackage();
        vector.add(mainPackage);
        String baPackage = this.getBundleActivatorPackage();
        IJavaProject javaProject = CoreUtility.getJavaProject(this.getSourceFolderName());
        if (javaProject != null && (packageFragment = CoreUtility.getPackageInProject(javaProject, baPackage)) != null) {
            try {
                if (packageFragment.exists()) {
                    packageFragment.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (org.eclipse.jdt.core.JavaModelException e) {
                e.printStackTrace();
            }
        }
        vector.add(this.getServicePackage());
        return vector;
    }

    protected List getManifestExportServices() {
        ArrayList<String> vector = new ArrayList<String>();
        List list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.get(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.add(service);
            }
            ++i;
        }
        vector.add(this.getServiceFqn());
        return vector;
    }

    protected List getManifestImportPackages() {
        ArrayList vector = new ArrayList();
        vector.addAll(this.getImportPackages(this.fTestModel));
        vector.addAll(this.getImportPackages(this.fServiceModel));
        vector.addAll(this.getImportPackages(this.fTestSuiteModel));
        int i = 0;
        while (i < this.testcases.size()) {
            vector.addAll(this.getImportPackages((JavaFileModel)this.testcases.get(i)));
            ++i;
        }
        vector.addAll(this.getImportPackages(this.fBundleActivatorModel));
        return vector;
    }

    protected List getManifestImportServices() {
        List vector = super.getManifestImportServices();
        return vector;
    }

    public List getManifestRequiredBundles() {
        List result = super.getManifestRequiredBundles();
        String targetId = this.getMainElement().getProjectId();
        boolean isConnection = targetId.endsWith(".connection");
        switch (this.bundleType) {
            case 1: {
                if (isConnection) break;
                result.add(String.valueOf(targetId) + ".bundle");
                break;
            }
            case 2: {
                result.add(String.valueOf(targetId) + ".managed");
                break;
            }
            case 3: {
                result.add(String.valueOf(targetId) + ".factory");
            }
        }
        List required = this.getMainElement().getRequiredBundles();
        int i = 0;
        while (i < required.size()) {
            TagElement element = (TagElement)required.get(i);
            String bundleId = element.getProjectId();
            if (bundleId != null && bundleId.length() > 0) {
                String id = bundleId;
                result.add(id);
                isConnection = id.endsWith(".connection");
                switch (this.bundleType) {
                    case 1: {
                        if (isConnection) break;
                        result.add(String.valueOf(id) + ".bundle");
                        break;
                    }
                    case 2: {
                        result.add(String.valueOf(id) + ".managed");
                        break;
                    }
                    case 3: {
                        result.add(String.valueOf(id) + ".factory");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected String getMetaDataProperties() {
        FactoryMetaDataBuilder builder = new FactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    protected String getModelName() {
        return "";
    }

    protected String getNonTestClass() {
        String mainClass = this.getMainClassName();
        if (mainClass.endsWith("Test")) {
            mainClass = mainClass.substring(0, mainClass.length() - 4);
        }
        return mainClass;
    }

    public String getResourceBundleClassName() {
        return String.valueOf(this.getMainClassName()) + "ResourceBundle";
    }

    protected String getRunContents() {
        return "";
    }

    protected String getServiceFileComment() {
        StringBuffer buffer = new StringBuffer(32);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(this.getImportedServiceComment());
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected List getServices() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.fTest != null) {
            String service = this.fTest.getAttribute("service");
            if (service != null) {
                result.add(service);
            } else {
                String bundle = this.fTest.getAttribute("bundle");
                if (bundle != null) {
                    if (!bundle.endsWith("Service")) {
                        bundle = String.valueOf(bundle) + "Service";
                    }
                    result.add(bundle);
                }
            }
        }
        return result;
    }

    protected String getStartContents() {
        return "";
    }

    protected String getStopContents() {
        return "";
    }

    public String getSuiteClassName() {
        String mainName = this.getMainClassName();
        if (mainName.endsWith("TestAgent")) {
            return String.valueOf(mainName.substring(0, mainName.length() - 9)) + "TestSuite";
        }
        return String.valueOf(mainName) + "Suite";
    }

    protected String getTargetType() {
        return "";
    }

    protected TestAgentElement getTestAgentElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (87 == ((TagElement)children.get(i)).getTagCode()) {
                return (TestAgentElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected String getTestContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (getThread() == null) {\n");
        buffer.append("\tsetThread(new Thread(this, ");
        buffer.append(this.quote(this.getUserName(this.fTest)));
        buffer.append("));\n");
        buffer.append("\tgetThread().setPriority(");
        buffer.append(this.getConfInt(this.fTest, "priority", "Thread.NORM_PRIORITY - 2"));
        buffer.append(");\n");
        buffer.append("\tgetThread().start();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public String getTestcaseClassName(String testcaseName) {
        String mainName = this.getMainClassName();
        if (mainName.endsWith("TestAgent")) {
            return String.valueOf(mainName.substring(0, mainName.length() - 9)) + testcaseName + "TestCase";
        }
        return String.valueOf(mainName) + testcaseName + "AbstractTestCase";
    }

    protected List getTestcases() {
        return this.testcases;
    }

    protected int getUserMessageBase() {
        String userMessageBase = ((TestAgentElement)this.getMainElement()).getUserMessageBase();
        if (userMessageBase != null) {
            return Integer.valueOf(userMessageBase);
        }
        return DEFAULT_MSG_START_KEY;
    }

    protected void initialize() {
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.fTest);
        this.setMainClassName(className);
        this.setPackageBase(this.fTest.getPackageBase());
        this.pack = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
        this.setMainPackage(this.pack);
        this.currentMsgKey = this.getUserMessageBase();
        super.initialize();
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        this.fTestModel.setSaver(this.getSaver());
        this.fTestModel.setSortOrder(3L);
        Object test = this.fTestModel.save(progressMonitor);
        if (test != null) {
            result.add(test);
        }
        this.fTestSuiteModel.setSaver(this.getSaver());
        this.fTestSuiteModel.setSortOrder(3L);
        Object testSuite = this.fTestSuiteModel.save(progressMonitor);
        if (testSuite != null) {
            result.add(testSuite);
        }
        int i = 0;
        while (i < this.testcases.size()) {
            JavaFileModel testcase = (JavaFileModel)this.testcases.get(i);
            testcase.setSaver(this.getSaver());
            testcase.setSortOrder(3L);
            Object testcaseSaved = testcase.save(progressMonitor);
            if (testcaseSaved != null) {
                result.add(testcaseSaved);
            }
            ++i;
        }
        this.fResourceBundleModel.setSaver(new DeviceKitResourceBundleSaver(this.getSaver(), this.dkMessages));
        this.fResourceBundleModel.setSortOrder(3L);
        Object resourceBundle = this.fResourceBundleModel.save(progressMonitor);
        if (resourceBundle != null) {
            result.add(resourceBundle);
        }
        this.fResourceBundle_en_USModel.setSaver(this.getSaver());
        Object resourceBundle_en_US = this.fResourceBundle_en_USModel.save(progressMonitor);
        if (resourceBundle_en_US != null) {
            result.add(resourceBundle_en_US);
        }
        List supersResult = super.save(progressMonitor);
        return DeviceKitUtilities.mergeLists(result, supersResult);
    }

    protected void saveBuildProperties(IProgressMonitor progressMonitor) throws Exception {
        String[] additionalBundles = DeviceKitGenerationConstants.TESTAGENT_ADDITIONALBUNDLES;
        if (additionalBundles != null) {
            int i = 0;
            while (i < additionalBundles.length) {
                this.getBuildModel().addAdditionalBundles(additionalBundles[i]);
                ++i;
            }
        }
        super.saveBuildProperties(progressMonitor);
    }

    public void setBundleType(int bundleType) {
        this.bundleType = bundleType;
    }

    protected void setTestAgentElement(TestAgentElement element) {
        this.fTest = element;
    }

    static class MessageProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        MessageProperties() {
        }

        public synchronized Enumeration keys() {
            ArrayList<Object> tempList = Collections.list(super.keys());
            Collections.sort(tempList);
            return Collections.enumeration(tempList);
        }
    }
}

