/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkConnectionGenerator
extends DkDeviceGenerator {
    protected int bundleType = 0;

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    protected void codeBACreateService(IType ba) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE));
        String contents = this.getBACreateServiceContents();
        String[] comment = new String[]{"Creates the connection service using the specified property dictionary.", "", "@param dictionary The dictionary properties used to create the connection service.", "@return Object The connection service created by this bundle.", "@see " + this.getMainFqn()};
        KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage("java.util.Dictionary"), "dictionary");
        this.fBundleActivatorModel.addImport("java.util.Dictionary");
        this.codeMethod(ba, "createService", comment, returnType, 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeCommandsSignalsMeasurementsFields(IType device) {
    }

    protected void codeConstructors(IType connection) throws IOException {
        MainTagElement element = this.getMainElement();
        String serviceName = this.getServiceClass();
        String typeDescription = element.getDescription();
        List customParameters = element.getAllChildrenWithTagCode(46, false);
        int count = customParameters.size();
        int parameterCount = 0;
        int i = 0;
        while (i < count) {
            CustomParameterElement customParameter = (CustomParameterElement)customParameters.get(i);
            String deprecated = customParameter.getDeprecated();
            if (deprecated == null) {
                ++parameterCount;
            }
            ++i;
        }
        String name = connection.getName();
        StringBuffer commentBuffer = new StringBuffer(1024);
        commentBuffer.append("Constructs an instance of the " + name + " class from the specified parameters.\n");
        commentBuffer.append(typeDescription);
        if (!typeDescription.endsWith(".")) {
            commentBuffer.append('.');
        }
        commentBuffer.append('\n');
        StringBuffer codeBuffer = new StringBuffer(1024);
        codeBuffer.append("final Hashtable table = new Hashtable(23);\n");
        KeyValuePair[] parameters = new KeyValuePair[parameterCount];
        int parameterIndex = 0;
        int i2 = 0;
        while (i2 < count) {
            CustomParameterElement customParameter = (CustomParameterElement)customParameters.get(i2);
            String deprecated = customParameter.getDeprecated();
            if (deprecated == null) {
                boolean required = "true".equals(customParameter.getRequired());
                ConfigurationField configurationField = new ConfigurationField(customParameter);
                String parameterName = configurationField.getConfigurationName();
                String codeName = String.valueOf(serviceName) + '.' + configurationField.getCodeName();
                String codeDefaultName = String.valueOf(serviceName) + '.' + configurationField.getCodeDefaultName();
                String codeType = configurationField.getCodeType();
                String description = configurationField.getDescription();
                parameters[parameterIndex++] = new KeyValuePair(codeType, parameterName);
                if (!required) {
                    if ("String".equals(codeType)) {
                        codeBuffer.append("if ((");
                        codeBuffer.append(parameterName);
                        codeBuffer.append(" != ");
                        codeBuffer.append("null) && (!");
                        codeBuffer.append(codeDefaultName);
                        codeBuffer.append(".equals(");
                        codeBuffer.append(parameterName);
                        codeBuffer.append("))) {");
                    } else {
                        codeBuffer.append("if (");
                        codeBuffer.append(parameterName);
                        codeBuffer.append(" != ");
                        codeBuffer.append(codeDefaultName);
                        codeBuffer.append(") {");
                    }
                }
                codeBuffer.append("table.put(");
                codeBuffer.append(codeName);
                codeBuffer.append(", ");
                if ("int".equals(codeType) || "char".equals(codeType) || "byte".equals(codeType) || "short".equals(codeType)) {
                    codeBuffer.append("createInteger(");
                    codeBuffer.append(parameterName);
                    codeBuffer.append("));\n");
                } else if ("boolean".equals(codeType)) {
                    codeBuffer.append("createBoolean(");
                    codeBuffer.append(parameterName);
                    codeBuffer.append("));\n");
                } else if ("long".equals(codeType)) {
                    codeBuffer.append("createLong(");
                    codeBuffer.append(parameterName);
                    codeBuffer.append("));\n");
                } else {
                    codeBuffer.append(parameterName);
                    codeBuffer.append(");\n");
                }
                if (!required) {
                    codeBuffer.append("}\n");
                }
                commentBuffer.append("@param ");
                commentBuffer.append(parameterName);
                commentBuffer.append('\n');
                commentBuffer.append("\t\t");
                if (description != null && description.length() > 0) {
                    commentBuffer.append(description);
                    if (!description.endsWith(".")) {
                        commentBuffer.append('.');
                    }
                } else {
                    commentBuffer.append(CodeUtilities.betterName(configurationField.getName(), false));
                }
                commentBuffer.append('\n');
            }
            ++i2;
        }
        codeBuffer.append("setConfigurationService(new EscConfiguration(table));\n");
        String comment = commentBuffer.toString();
        String contents = codeBuffer.toString();
        KeyValuePair[] parametersConf = new KeyValuePair[]{new KeyValuePair("ConfigurationService", "configuration")};
        String commentConf = "Constructs an instance of the " + name + " class from the specified configuration parameter.";
        this.codeMethod(connection, name, commentConf, null, 1L, "super(configuration);", parametersConf, null);
        KeyValuePair[] parametersDictionary = new KeyValuePair[]{new KeyValuePair("Dictionary", "properties")};
        String commentDictionary = "Constructs an instance of the " + name + " class from the specified properties parameter.";
        this.codeMethod(connection, name, commentDictionary, null, 1L, "this(new EscConfiguration(properties));", parametersDictionary, null);
        this.codeMethod(connection, name, comment, null, 1L, contents, parameters, new String[]{"IllegalArgumentException"});
    }

    protected void codeDescriptionField(IType type, String fieldName) {
        super.codeDescriptionField(type, fieldName);
        String value = this.getConnectionType();
        this.codeField(type, "CONNECTION_TYPE", "String", 49L, "Define the connection type (String) constant.", this.quote(value));
    }

    protected void codeInitialize(IType device) {
    }

    protected void codeMethods(IType device) throws Exception {
    }

    protected void codeSetup(IType device) {
    }

    protected ConnectionElement findConnectionElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (36 == ((TagElement)children.get(i)).getTagCode()) {
                return (ConnectionElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void generateEscProperties() {
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        String type = this.getMainElement().getType();
        this.fBundleActivatorModel.addImport(type);
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append(" connection = new ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append("(dictionary);\n");
        buffer.append("return connection;\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_CONNECTION_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_CONNECTION_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_BA;
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected TagElement getConnectionElement(TagElement parent) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (36 == ((TagElement)children.get(i)).getTagCode()) {
                return (TagElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    public String getConnectionType() {
        ConnectionElement connectionElement = this.findConnectionElement();
        if (connectionElement != null) {
            return connectionElement.getConnectionType();
        }
        return null;
    }

    protected List getImportedServices() {
        return new ArrayList();
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected List getManifestExportPackages() {
        List vector = super.getManifestExportPackages();
        vector.add(DeviceKitUtilities.extractPackage(this.getMainElement().getType()));
        vector.add(this.getServicePackage());
        return vector;
    }

    public Map getOtherManifestFiles() {
        return this.otherManifestFiles;
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE;
    }

    protected void initialize() {
        List connections = this.getRootElement().getAllChildrenWithTagCode(36);
        ConnectionElement connection = (ConnectionElement)connections.get(0);
        this.setDevice(connection);
        this.setMainTagElement(connection);
        String className = DeviceKitUtilities.getClassNameFromTagElement(connection);
        this.setMainClassName(className);
        this.setPackageBase(connection.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        this.setupExportedPackages();
        this.initializeGet();
    }

    public void setBundleType(int bundleType) {
        this.bundleType = bundleType;
    }

    public void setOtherManifestFiles(Map otherManifestFiles) {
        this.otherManifestFiles = otherManifestFiles;
    }
}

