/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.ant;

import java.util.List;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntPrinter;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntPropertyPrinter;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntTaskPrinter;
import org.eclipse.soda.devicekit.generator.model.ant.IAntElement;
import org.eclipse.soda.devicekit.generator.model.ant.IAntProperty;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTarget;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTask;

public class AntTargetPrinter
extends AntPrinter {
    private IAntTarget target;

    public AntTargetPrinter(int indentation, IAntTarget target) {
        super(indentation);
        this.target = target;
        this.print();
    }

    protected void endTarget() {
        this.decrementIndent();
        this.printIndentation();
        this.endTag("target");
    }

    protected IAntTarget getTarget() {
        return this.target;
    }

    protected void print() {
        this.startTarget();
        this.printTargetBody();
        this.endTarget();
        this.printNewLine();
    }

    protected void printProperty(IAntProperty property) {
        AntPropertyPrinter printer = new AntPropertyPrinter(this.getCurrentIndentenation(), false, property);
        this.print(printer.getContents());
    }

    protected void printTargetBody() {
        List elements = this.getTarget().getElements();
        int i = 0;
        while (i < elements.size()) {
            IAntElement element = (IAntElement)elements.get(i);
            switch (element.getElementType()) {
                case 0: {
                    this.printProperty((IAntProperty)element);
                    break;
                }
                case 1: {
                    this.printTask((IAntTask)element);
                }
            }
            ++i;
        }
    }

    protected void printTask(IAntTask task) {
        AntTaskPrinter printer = new AntTaskPrinter(this.getCurrentIndentenation(), task);
        this.print(printer.getContents());
    }

    protected void startTarget() {
        this.printNewLine();
        this.printIndentation();
        this.startTag("target");
        this.printAttribute("name", this.getTarget().getName());
        String[] attNames = this.getTarget().getAttributeNames();
        int i = 0;
        while (i < attNames.length) {
            String value = this.getTarget().getAttribute(attNames[i]);
            this.printAttribute(attNames[i], value);
            ++i;
        }
        this.endTag();
        this.incrementIndent();
    }
}

