/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.html;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.template.TemplateInputStream;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class HtmlGenerator {
    public HashMap variables = new HashMap();
    protected PrintWriter printWriter = null;
    protected StringWriter stringWriter = new StringWriter(4096);
    protected String layerClass = "unknown";
    private String feature = "";
    protected Properties layerProperties = HtmlGenerator.loadLayerProperties();
    static /* synthetic */ Class class$0;

    protected static Properties loadLayerProperties() {
        Properties properties = new Properties();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.html.HtmlGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream is = clazz.getResourceAsStream("layers.properties");
            properties.load(is);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties;
    }

    protected void addCommonVariables() {
        this.variables.put("feature", this.getFeature());
        this.variables.put("provider", DeviceKitPlugin.getProvider());
        this.variables.put("Provider", DeviceKitPlugin.getProvider());
        this.variables.put("vendors", DeviceKitPlugin.getVendors());
        this.variables.put("Vendors", DeviceKitPlugin.getVendors());
        this.variables.put("vendor", DeviceKitPlugin.getVendor());
        this.variables.put("Vendor", DeviceKitPlugin.getVendor());
        this.variables.put("version", DeviceKitPlugin.getVersion());
        this.variables.put("Version", DeviceKitPlugin.getVersion());
        this.variables.put("year", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("Year", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("years", Integer.toString(Calendar.getInstance().get(1)));
        this.variables.put("Years", Integer.toString(Calendar.getInstance().get(1)));
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(year);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        buffer.append('-');
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        this.variables.put("Date", buffer.toString());
        this.variables.put("date", buffer.toString());
        if (this.variables.get("EclipseVersion") == null) {
            this.variables.put("EclipseVersion", DeviceKitPlugin.getEclipseVersion());
        }
        this.variables.put("stylesheet", "stylesheet.css");
        this.variables.put("layerClass", this.getLayerClass());
    }

    public void addVariable(String key, String value) {
        this.getVariables().put(key, value);
    }

    public int compare(Object o1, Object o2) {
        String e0 = ((TagElement)o1).getExternalId();
        String e1 = ((TagElement)o2).getExternalId();
        if (e0 != null && e1 != null) {
            String s0 = CodeUtilities.betterName(e0, false).toLowerCase();
            String s1 = CodeUtilities.betterName(e1, false).toLowerCase();
            StringTokenizer st0 = new StringTokenizer(s0, " ");
            StringTokenizer st1 = new StringTokenizer(s1, " ");
            int st0Count = st0.countTokens();
            int st1Count = st1.countTokens();
            int min = Math.min(st0Count, st1Count);
            int i = 0;
            while (i < min) {
                String token1;
                String token0 = st0.nextToken();
                int result = token0.compareTo(token1 = st1.nextToken());
                if (result != 0) {
                    try {
                        long i0 = Long.parseLong(token0);
                        long i1 = Long.parseLong(token1);
                        return (int)(i0 - i1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return result;
                    }
                }
                ++i;
            }
            return st0Count - st1Count;
        }
        return 0;
    }

    public StringWriter createStringWriter() {
        return new StringWriter(40960);
    }

    public String getFeature() {
        return this.feature;
    }

    public String getLayerClass() {
        return this.layerClass;
    }

    public Properties getLayerProperties() {
        return this.layerProperties;
    }

    public String getLayerType(String name) {
        Properties properties = this.getLayerProperties();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!name.endsWith(key)) continue;
            return value;
        }
        return "unknown";
    }

    public PrintWriter getPrintWriter() {
        if (this.printWriter == null) {
            this.stringWriter = this.createStringWriter();
            this.printWriter = new PrintWriter(this.stringWriter);
        }
        return this.printWriter;
    }

    public StringWriter getStringWriter() {
        return this.stringWriter;
    }

    public HashMap getVariables() {
        return this.variables;
    }

    public void print(char character) {
        this.getPrintWriter().print(character);
    }

    public void print(String string) {
        this.getPrintWriter().print(string);
    }

    public void println(String string) {
        this.getPrintWriter().println(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(IFile file, StringWriter writer, IProgressMonitor progressMonitor) {
        SubProgressMonitor subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
        try {
            String name = file.getName();
            subMonitor.subTask(name);
            try {
                String data = writer.getBuffer().toString();
                if (data != null) {
                    ByteArrayInputStream source = new ByteArrayInputStream(data.getBytes());
                    if (file.exists()) {
                        file.setContents((InputStream)source, true, true, (IProgressMonitor)subMonitor);
                    } else {
                        file.create((InputStream)source, true, (IProgressMonitor)subMonitor);
                    }
                }
                writer.close();
                this.stringWriter = null;
                this.printWriter = null;
            }
            catch (Exception exception) {
                System.out.println(name);
                System.out.println(exception);
                exception.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            subMonitor.done();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        subMonitor.done();
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public void setLayerClass(String layerClass) {
        this.layerClass = layerClass;
    }

    public void setLayerClassEntity(String name) {
        String layerClass = this.getLayerType(name);
        this.setLayerClass(layerClass);
        this.addVariable("layerClass", layerClass);
    }

    public void setLayerProperties(Properties layerProperties) {
        this.layerProperties = layerProperties;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setStringWriter(StringWriter stringWriter) {
        this.stringWriter = stringWriter;
    }

    public void setVariables(HashMap variables) {
        this.variables = variables;
    }

    public void template(String template) {
        try {
            InputStream stream = this.getClass().getResourceAsStream(template);
            String templateData = DeviceKitUtilities.getStringFromStream(stream);
            TemplateInputStream tis = new TemplateInputStream(new ByteArrayInputStream(templateData.getBytes()));
            tis.setEntities(this.getVariables());
            this.println(DeviceKitUtilities.getStringFromStream(tis));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

