/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.ant;

import java.io.File;
import java.util.List;
import org.eclipse.soda.devicekit.generator.ant.JUnitSaver;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.ant.AntModel;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTarget;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTask;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkJunitAntGenerator {
    private String projectName;
    private JUnitSaver fSaver;
    private AntModel fModel;
    private DeviceKitTagModel tagModel;
    private String[] classPath;
    private String iveLocation;

    public DkJunitAntGenerator(DeviceKitTagModel model, String projectName, int type) {
        this.tagModel = model;
        this.setProjectName(projectName);
    }

    protected void createJunitBuildTestTarget(AntModel model) {
        IAntTarget target = model.createAntTarget(model.getDefaultTarget());
        IAntTask junit = target.createAntTask("junit");
        junit.addAttribute("fork", "yes");
        junit.addAttribute("jvm", String.valueOf(this.getIveLocation()) + File.separatorChar + "bin" + File.separatorChar + "j9");
        junit.addAttribute("haltonfailure", "true");
        IAntTask jvmArg = junit.createAntTask("jvmarg");
        jvmArg.addAttribute("value", "-Duser.dir=${basedir}");
        IAntTask classPath = junit.createAntTask("classpath");
        classPath.addAttribute("refid", "classpath");
        IAntTask test = junit.createAntTask("test");
        test.addAttribute("name", this.getJunitTestName());
        IAntTask formatter = test.createAntTask("formatter");
        formatter.addAttribute("type", "brief");
        formatter.addAttribute("usefile", "false");
        IAntTask task = target.createAntTask("eclipse.refreshLocal");
        task.addAttribute("resource", "../${ant.project.name}");
        task.addAttribute("depth", "infinite");
    }

    protected void createPath(AntModel model) {
        IAntTask task = model.createAntTask("path");
        task.addAttribute("id", "classpath");
        int i = 0;
        while (i < this.getClassPath().length) {
            IAntTask cpEntry = task.createAntTask("pathelement");
            cpEntry.addAttribute("path", this.getClassPath()[i]);
            ++i;
        }
    }

    protected void createTargets(AntModel model) {
        this.createJunitBuildTestTarget(model);
    }

    public void generate() {
        this.fModel = new AntModel(this.getFileName(), "junit.build.test", this.getProjectName(), "..");
        this.createPath(this.fModel);
        this.createTargets(this.fModel);
    }

    protected AntModel getAntModel() {
        return this.fModel;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    protected String getFileName() {
        return String.valueOf(DeviceKitUtilities.stripPackage(this.getJunitTestName())) + ".xml";
    }

    public String getIveLocation() {
        return this.iveLocation;
    }

    protected String getJunitTestName() {
        List tests = this.tagModel.getRoot().getAllChildrenWithTagCode(10);
        if (tests.size() > 0) {
            TagElement te = (TagElement)tests.get(0);
            String pb = te.getPackageBase();
            String defClassName = DeviceKitUtilities.getClassNameFromTagElement(te);
            defClassName = DeviceKitUtilities.removeLastOccurence(defClassName, "Test");
            defClassName = String.valueOf(defClassName) + "JunitTest";
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(defClassName, pb)) + '.' + defClassName;
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void save() throws Exception {
        if (this.fSaver != null) {
            this.getAntModel().setSaver(this.fSaver);
            if (this.getAntModel() != null) {
                this.getAntModel().save();
            }
        }
    }

    public void setClassPath(String[] classPath) {
        this.classPath = classPath;
    }

    public void setIveHome(String iveLocation) {
        this.iveLocation = iveLocation;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected void setSaver(JUnitSaver saver) {
        this.fSaver = saver;
    }
}

