/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;

public class ProjectUtil {
    public static final int MAX_LOOP = 5;

    public static boolean compareErrors(String[] old, String[] current) {
        int i = 0;
        while (i < old.length) {
            if (!old[i].equals(current[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ICompilationUnit findCompilationUnit(IPackageFragment pkg, String name) {
        String javaName = String.valueOf(name) + ".java";
        ICompilationUnit cu = pkg.getCompilationUnit(javaName);
        if (cu.exists()) {
            return cu;
        }
        try {
            ICompilationUnit[] cus = pkg.getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                IType[] types = cus[i].getAllTypes();
                int j = 0;
                while (j < types.length) {
                    if (name.equals(types[j].getTypeQualifiedName())) {
                        return cus[i];
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] getProjectErrors(IJavaProject project) {
        return ProjectUtil.getProjectErrors(project.getProject(), "org.eclipse.jdt.core.problem");
    }

    public static String[] getProjectErrors(IProject project, String type) {
        IMarker[] markers = null;
        String[] errors = null;
        try {
            markers = project.findMarkers(type, true, 2);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (markers == null || markers.length == 0) {
            return new String[0];
        }
        errors = new String[markers.length];
        try {
            int i = 0;
            while (i < markers.length) {
                errors[i] = (String)markers[i].getAttribute("message");
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new String[0];
        }
        return errors;
    }
}

