/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.visitor;

import org.eclipse.soda.devicekit.generator.visitor.Visitor;

public class HtmlVisitor
extends Visitor {
    private String javadocDir = "../classes/";

    public static String getXmlString(Object value) {
        return HtmlVisitor.getXmlString(String.valueOf(value));
    }

    public static String getXmlString(String string) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(i);
            if (character == '&') {
                buffer.append("&amp;");
            } else if (character == '<') {
                buffer.append("&lt;");
            } else if (character == '>') {
                buffer.append("&gt;");
            } else {
                buffer.append(character);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getJavadocDir() {
        return this.javadocDir;
    }

    public void printComment(String data) {
        this.print("<font color=\"teal\">");
        this.print(HtmlVisitor.getXmlString(data));
        this.println("</font>");
    }

    public void printJavadoc(String data) {
        this.print("<font color=\"red\">");
        this.print(HtmlVisitor.getXmlString(data));
        this.println("</font>");
    }

    public void printKeyword(String data) {
        this.print("<font color=\"navy\">");
        this.print(data);
        this.print("</font>");
    }

    public void printLiteral(String string) {
        this.print("<font color=\"green\">");
        this.print(string);
        this.print("</font>");
    }

    public void printMethod(String string) {
        this.print("<b>");
        this.print(string);
        this.print("</b>");
    }

    public void printPackage(String data) {
        this.print("<a href=\"");
        this.print(this.getJavadocDir());
        this.print(data.replace('.', '/'));
        this.print("/package-summary.html\">");
        this.print(data);
        this.print("</a>");
    }

    public void printType(String data, String packageName) {
        this.print("<a href=\"");
        this.print(this.getJavadocDir());
        this.print(packageName.replace('.', '/'));
        this.print('/');
        this.print(data);
        this.print(".html\">");
        this.print(data);
        this.print("</a>");
    }

    public void printType(String data) {
        this.print("<a href=\"");
        this.print(this.getJavadocDir());
        this.print(data.replace('.', '/'));
        this.print(".html\">");
        this.print(data);
        this.print("</a>");
    }

    public void printVariable(String string) {
        this.print("<i>");
        this.print(string);
        this.print("</i>");
    }

    public void setJavadocDir(String javadocDir) {
        this.javadocDir = javadocDir;
    }
}

