/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.operation;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.model.operation.IModelOperation;
import org.eclipse.soda.devicekit.generator.util.PreGenElementHolder;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;

public class GenerateModelOperation
implements IModelOperation {
    private Map properties;
    private IFile[] files;
    private PreGenElementHolder customElements;
    private boolean custom;

    public GenerateModelOperation(Map variables, IFile[] files, boolean custom) {
        this.files = files;
        this.custom = custom;
    }

    public PreGenElementHolder getCustomElements() {
        return this.customElements;
    }

    private Map getMethodProperties() {
        return this.properties;
    }

    private List getReferencedFiles(IFile file) throws Exception {
        DkmlReferenceResolver resolver = new DkmlReferenceResolver(file);
        return resolver.getReferences();
    }

    public void run() throws Exception {
        this.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void run(IProgressMonitor progressMonitor) throws Exception {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        int i = 0;
        while (i < this.files.length) {
            DeviceKitGenerator dkg = new DeviceKitGenerator(monitor, this.files[i], this.getReferencedFiles(this.files[i]), this.custom, true);
            dkg.setMethodProperties(this.getMethodProperties());
            String schema = null;
            dkg.setSchema(schema);
            dkg.generate(monitor);
            this.customElements = dkg.getCustomHolder();
            ++i;
        }
    }

    public void setMethodProperties(Map properties) {
        this.properties = properties;
    }
}

