/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitTagConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.DataElement;
import org.eclipse.soda.devicekit.generator.model.elements.DkgElementsMessages;
import org.eclipse.soda.devicekit.generator.model.elements.MaximumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MinimumElement;
import org.eclipse.soda.devicekit.generator.model.elements.NegativeElement;
import org.eclipse.soda.devicekit.generator.model.elements.NotElement;
import org.eclipse.soda.devicekit.generator.model.elements.OffsetElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParametersElement;
import org.eclipse.soda.devicekit.generator.model.elements.PidElement;
import org.eclipse.soda.devicekit.generator.model.elements.PidMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.ScaleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ShiftElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TranslateElement;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class SignalElement
extends ControlItem {
    private String fOffset;

    public SignalElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.getParent().getTagCode() == 18) {
            if (this.getField() != null && this.getField().length() > 0) {
                return DeviceKitGenerationConstants.CLASS_SIGNAL_FIELD_CONCRETE;
            }
            return DeviceKitGenerationConstants.CLASS_SIGNAL_CONCRETE;
        }
        if (this.hasChildWithTagCode(5) || this.hasChildWithTagCode(23)) {
            return DeviceKitGenerationConstants.CLASS_SIGNAL_PARAMETER;
        }
        if (this.hasTransformChild()) {
            return DeviceKitGenerationConstants.CLASS_SIGNAL_TRANSFORM;
        }
        if (this.hasChildWithTagCode(DeviceKitTagConstants.ALL_MESSAGE_CODES)) {
            List messages = this.getAllChildrenWithTagCodes(DeviceKitTagConstants.ALL_MESSAGE_CODES);
            TagElement me = (TagElement)messages.get(0);
            if (me.hasChildWithTagCode(5) || me.hasChildWithTagCode(23)) {
                return DeviceKitGenerationConstants.CLASS_SIGNAL_DATA;
            }
            return DeviceKitGenerationConstants.CLASS_SIGNAL_MESSAGE;
        }
        if (this.hasMethodChild()) {
            return DeviceKitGenerationConstants.CLASS_METHOD_SIGNAL;
        }
        if (this.getField() != null && this.getField().length() > 0) {
            return DeviceKitGenerationConstants.CLASS_SIGNAL_FIELD_SIGNAL;
        }
        return DeviceKitGenerationConstants.CLASS_SIGNAL;
    }

    public String getFieldExtraComment(String fieldName) {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = TagElement.collection.getSignal(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        List listParameter = realElement.getChildrenWithTagCode(5);
        StringBuffer buffer = new StringBuffer(1024);
        if (realElement.getMessageChildren().size() > 0 && listParameter.size() == 0) {
            realElement.addFieldExtraCommentMessages(buffer, fieldName);
        } else {
            List list = realElement.getChildrenWithTagCode(3);
            if (list.size() == 1) {
                SignalElement child = (SignalElement)list.get(0);
                String field = this.getField();
                if (field == null || field.length() == 0) {
                    field = child.getField();
                }
                if (field != null && field.length() > 0) {
                    return ((TagElement)list.get(0)).getFieldExtraComment(field);
                }
                return child.getFieldExtraComment(fieldName);
            }
            List listMessage = realElement.getChildrenWithTagCodes(DeviceKitTagConstants.ALL_MESSAGE_CODES);
            if (listMessage.size() > 0) {
                String field = this.getField();
                if (field == null && listParameter.size() == 1) {
                    field = ((ParameterElement)listParameter.get(0)).getField();
                }
                if (field != null && field.length() > 0) {
                    return ((TagElement)listMessage.get(0)).getFieldExtraComment(field);
                }
                return ((TagElement)listMessage.get(0)).getFieldExtraComment(fieldName);
            }
            if (listParameter.size() == 1) {
                String field = this.getField();
                if (field != null && field.length() > 0) {
                    return ((TagElement)listParameter.get(0)).getFieldExtraComment(field);
                }
                return ((TagElement)listParameter.get(0)).getFieldExtraComment(fieldName);
            }
        }
        return buffer.toString();
    }

    public String getOffset() {
        return this.fOffset;
    }

    public String getParameterDataType() {
        TagElement realElement = this.getRealElement();
        List messages = realElement.getMessageChildren();
        if (messages.size() > 0) {
            return ((TagElement)messages.get(0)).getParameterDataType();
        }
        List list = realElement.getChildrenWithTagCode(3);
        if (list.size() == 1) {
            TagElement fieldControl;
            String field = this.getField();
            if (field != null && field.length() > 0 && (fieldControl = ((TagElement)list.get(0)).lookupField(field)) != null) {
                return fieldControl.getParameterDataType();
            }
            return ((TagElement)list.get(0)).getParameterDataType();
        }
        return super.getParameterDataType();
    }

    public String getParameterDataTypeDocumentation() {
        TagElement realElement = this.getRealElement();
        List listParameter = realElement.getChildrenWithTagCode(5);
        if (listParameter.size() > 0) {
            return ((TagElement)listParameter.get(0)).getParameterDataTypeDocumentation();
        }
        List messages = realElement.getMessageChildren();
        if (messages.size() > 0) {
            return ((TagElement)messages.get(0)).getParameterDataTypeDocumentation();
        }
        List list = realElement.getChildrenWithTagCode(3);
        if (list.size() == 1) {
            TagElement fieldControl;
            String field = this.getField();
            if (field != null && field.length() > 0 && (fieldControl = ((TagElement)list.get(0)).lookupField(field)) != null) {
                return fieldControl.getParameterDataTypeDocumentation();
            }
            return ((TagElement)list.get(0)).getParameterDataTypeDocumentation();
        }
        return super.getParameterDataTypeDocumentation();
    }

    public TagElement getRealElement() {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = TagElement.collection.getSignal(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
                return realElement;
            }
            throw new IllegalArgumentException(idref);
        }
        return this;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_SIGNAL_SERVICE;
    }

    public int getTagCode() {
        return 3;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("parameter".equals(childNodeName)) {
            this.handleParameter(childNode);
        } else if ("parameters".equals(childNodeName)) {
            this.handleParameters(childNode);
        } else if ("data".equals(childNodeName)) {
            this.handleData(childNode);
        } else if ("maximum".equals(childNodeName)) {
            this.handleMaximum(childNode);
        } else if ("minimum".equals(childNodeName)) {
            this.handleMinimum(childNode);
        } else if ("negative".equals(childNodeName)) {
            this.handleNegative(childNode);
        } else if ("not".equals(childNodeName)) {
            this.handleNot(childNode);
        } else if ("offset".equals(childNodeName)) {
            this.handleOffset(childNode);
        } else if ("scale".equals(childNodeName)) {
            this.handleScale(childNode);
        } else if ("shift".equals(childNodeName)) {
            this.handleShift(childNode);
        } else if ("translate".equals(childNodeName)) {
            this.handleTranslate(childNode);
        } else if ("field".equals(childNodeName)) {
            this.handleField(childNode);
        } else if ("signal".equals(childNodeName)) {
            this.handleSignal(childNode);
        } else if ("pid".equals(childNodeName)) {
            this.handlePid(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleData(Node node) {
        DataElement pe = new DataElement(node, this);
        this.addChild(pe);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addData(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleMaximum(Node node) {
        MaximumElement element = new MaximumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleMinimum(Node node) {
        MinimumElement element = new MinimumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNegative(Node node) {
        NegativeElement element = new NegativeElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNot(Node node) {
        NotElement element = new NotElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleOffset(Node node) {
        this.setOffset(ParserUtilities.extractData(node));
        OffsetElement element = new OffsetElement(node, this);
        this.addChild(element);
    }

    private void handleParameter(Node node) {
        ParameterElement pe = new ParameterElement(node, this);
        this.addChild(pe);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addParameter(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleParameters(Node node) {
        ParametersElement element = new ParametersElement(node, this);
        this.addChild(element);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addParameter(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handlePid(Node node) {
        PidElement pid = null;
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                pid = new PidElement(node, this);
                TagElement.collection.addPid(pid.getId(), pid);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        } else {
            String idref = ParserUtilities.getAttribute("idref", node);
            pid = (PidElement)TagElement.collection.getPid(idref);
            if (pid == null) {
                throw this.error(Nls.format(DkgElementsMessages.getString("TagElement.error.invalid.idref"), "pid"));
            }
        }
        PidMessageElement me = new PidMessageElement(node, pid);
        if (this.getId() != null) {
            String messageId = String.valueOf(this.getId()) + "Message";
            int i = 0;
            while (i < 100) {
                String incMessageId = String.valueOf(messageId) + i;
                if (TagElement.collection.getMessage(incMessageId) != null) {
                    messageId = incMessageId;
                    break;
                }
                ++i;
            }
            me.setAttribute("id", messageId);
            try {
                TagElement.collection.addMessage(messageId, me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
        this.addChild(me);
    }

    private void handleScale(Node node) {
        ScaleElement element = new ScaleElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleShift(Node node) {
        ShiftElement element = new ShiftElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleTranslate(Node node) {
        TranslateElement element = new TranslateElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void setOffset(String offset) {
        this.fOffset = offset;
    }
}

