/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkTransportGenerator;
import org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;

public class DkTransportBundleGenerator
extends DkTransportGenerator {
    private int bundleType;

    public DkTransportBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map properties, int bundleType) {
        super(model, generatedInfo, properties);
        this.bundleType = bundleType;
        this.otherManifestFiles = new HashMap();
    }

    private IType createBundleActivatorType() throws Exception {
        String baName = this.getBundleActivatorClass();
        String baPackage = this.getBundleActivatorPackage();
        this.fBundleActivatorModel = new JavaFileModel(baName);
        this.fBundleActivatorModel.setComment(this.getCopyright());
        this.fBundleActivatorModel.setPackage(baPackage);
        IType baType = this.createClass(this.fBundleActivatorModel, baPackage, baName, this.getSourceFolderName());
        String baSuperClass = this.getBASuperClass();
        baType.setSuperClass(DeviceKitUtilities.stripPackage(baSuperClass));
        this.fBundleActivatorModel.addImport(baSuperClass);
        baType.addSuperInterface(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR));
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR);
        baType.setComment(this.getBundleActivatorComment());
        return baType;
    }

    public void generate() throws Exception {
        this.initialize();
        if (this.getManifestModel() != null) {
            this.getManifestModel().addImportPackage(this.getMainPackage());
            this.getBuildModel().addAdditionalBundles(this.getMainPackage());
        }
        if (!this.isAbstract() && this.doGenerateBundleActivator()) {
            this.generateBundleActivatorClass();
        }
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected void generateBundleActivatorClass() throws Exception {
        IType baType = this.createBundleActivatorType();
        this.codeBAFields(baType);
        this.codeBAMethods(baType);
        this.generateCustomBundleActivatorItems();
    }

    protected void generateOtherFiles() {
        switch (this.bundleType) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                String metaData = this.getMetaDataContents();
                if (metaData == null) break;
                this.otherManifestFiles.put("OSGI-INF/metatype/Metadata.xml", metaData);
            }
        }
        String properties = this.getMetaDataProperties();
        if (properties != null) {
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle.properties", properties);
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle_en.properties", properties);
        }
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_MANAGED_FACTORY_BA;
            }
        }
        if (this.getTransportElement().getTransportServiceChildren().size() > 0) {
            return DeviceKitGenerationConstants.CLASS_TRANSPORT_BA_TUNNEL;
        }
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_BA;
    }

    protected String getBundleActivatorClass() {
        switch (this.bundleType) {
            case 2: {
                return String.valueOf(this.getMainClassName()) + "Managed";
            }
            case 3: {
                return String.valueOf(this.getMainClassName()) + "Factory";
            }
        }
        return String.valueOf(this.getMainClassName()) + "Bundle";
    }

    protected String getBundleActivatorFqn() {
        return String.valueOf(this.getBundleActivatorPackage()) + "." + this.getBundleActivatorClass();
    }

    protected String getBundleActivatorPackage() {
        switch (this.bundleType) {
            case 2: {
                return String.valueOf(this.getMainPackage()) + "." + "managed";
            }
            case 3: {
                return String.valueOf(this.getMainPackage()) + "." + "factory";
            }
        }
        return String.valueOf(this.getMainPackage()) + "." + "bundle";
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getBundleActivatorClass();
    }

    protected String getManifestDescription() {
        TagElement element = null;
        MainTagElement mainElement = this.getMainElement();
        String mainElementDescription = mainElement.getDescription();
        String mainElementId = mainElement.getId();
        String ending = null;
        switch (this.bundleType) {
            case 1: {
                List bundles = this.getMainElement().getAllChildrenWithTagCode(66);
                element = (TagElement)bundles.get(0);
                ending = " Bundle";
                break;
            }
            case 2: {
                List managed = this.getMainElement().getAllChildrenWithTagCode(67);
                element = (TagElement)managed.get(0);
                ending = " Managed";
                break;
            }
            case 3: {
                List factory = this.getMainElement().getAllChildrenWithTagCode(68);
                element = (TagElement)factory.get(0);
                ending = " Factory";
                break;
            }
            default: {
                return super.getManifestDescription();
            }
        }
        if (element != null && element.getDescription() != null) {
            return element.getDescription();
        }
        if (mainElementDescription != null) {
            return String.valueOf(mainElementDescription) + ending;
        }
        return String.valueOf(mainElementId) + ending;
    }

    protected List getManifestExportPackages() {
        ArrayList<String> result = new ArrayList<String>();
        String bap = this.getBundleActivatorPackage();
        result.add(bap);
        return result;
    }

    protected List getManifestExportServices() {
        List vector = super.getManifestExportServices();
        String[] services = this.getTransportElement().getImplementedInterfaces();
        int i = 0;
        while (i < services.length) {
            vector.add(services[i]);
            ++i;
        }
        List list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i2 = 0;
        while (i2 < list.size()) {
            String service = ((TagElement)list.get(i2)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.add(service);
            }
            ++i2;
        }
        vector.add(this.getServiceFqn());
        return vector;
    }

    protected List getManifestImportPackages() {
        String serviceDevicePack;
        List result = super.getManifestImportPackages();
        switch (this.bundleType) {
            case 2: {
                String managedDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_MANAGED_BA);
                if (result.contains(managedDevicePack)) break;
                result.add(managedDevicePack);
                break;
            }
            case 3: {
                String factoryDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_MANAGED_FACTORY_BA);
                if (result.contains(factoryDevicePack)) break;
                result.add(factoryDevicePack);
            }
        }
        String baseBundleActivatorPack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR);
        if (!result.contains(baseBundleActivatorPack)) {
            result.add(baseBundleActivatorPack);
        }
        if (!result.contains(serviceDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE))) {
            result.add(serviceDevicePack);
        }
        List importedServices = this.getImportedServices();
        int i = 0;
        while (i < importedServices.size()) {
            String serviceFqn = (String)importedServices.get(i);
            String servicePackage = DeviceKitUtilities.extractPackage(serviceFqn);
            result.add(servicePackage);
            ++i;
        }
        return result;
    }

    protected List getManifestImportServices() {
        List connections;
        List result = super.getManifestImportServices();
        if ((this.bundleType == 2 || this.bundleType == 3) && this.getTransportElement() != null && (connections = this.getTransportElement().getConnectionChildren()).size() > 0) {
            result.add(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        }
        return result;
    }

    public List getManifestRequiredBundles() {
        List result = super.getManifestRequiredBundles();
        switch (this.bundleType) {
            case 1: {
                break;
            }
            case 2: {
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
                break;
            }
            case 3: {
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
            }
        }
        return result;
    }

    private String getMetaDataContents() {
        TransportFactoryMetaDataBuilder builder = new TransportFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataXmlContents();
    }

    protected String getMetaDataProperties() {
        TransportFactoryMetaDataBuilder builder = new TransportFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    public Map getOtherManifestFiles() {
        return this.otherManifestFiles;
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getBundleActivatorPackage();
        return sfName;
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save(progressMonitor);
            if (ba != null) {
                result.add(ba);
            }
        }
        this.saveCommon(progressMonitor);
        return result;
    }
}

