/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.constants.Types;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.FactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.TestAgentFactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestAgentElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTestAgentBundleGenerator
extends DkDeviceGenerator {
    private TestAgentElement fTest;
    private int testType;

    public DkTestAgentBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkTestAgentBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, int bundleType) {
        super(model, generatedInfo, new HashMap(), bundleType);
    }

    protected boolean addTypePackageToBuildModel() {
        return false;
    }

    protected void codeBACreateService(IType ba) {
        String returnType = DeviceKitGenerationConstants.CLASS_TEST_AGENT;
        String[] comment = new String[]{"Creates the test for the specified " + this.getTargetType() + '.', "", "@return " + returnType + " The " + this.getTargetType() + " test.", "@see " + this.getMainFqn()};
        this.fBundleActivatorModel.addImport(returnType);
        String contents = this.getBACreateServiceContents();
        this.codeMethod(ba, "createService", comment, DeviceKitUtilities.stripPackage(returnType), 1L, contents, new KeyValuePair[0], null);
        this.fBundleActivatorModel.addImport(this.getMainFqn());
    }

    protected void codeBAGetImportedServiceNames(IType ba) {
        this.codeBAGetImportedServiceNames(this.fTest.getBundleName(), ba);
    }

    protected void codeBAGetInterestServiceName(IType ba) {
    }

    public void generate() throws Exception {
        this.initialize();
        if (this.getManifestModel() != null) {
            this.getManifestModel().addImportPackage(this.getMainPackage());
        }
        this.generateBundleActivatorClass();
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected void generateOtherFiles() throws Exception {
        switch (this.bundleType) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                String metaData = this.getMetaDataContents();
                if (metaData == null) break;
                this.otherManifestFiles.put("OSGI-INF/metatype/Metadata.xml", metaData);
            }
        }
        String property = this.getMetaDataProperties();
        if (property != null) {
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle.properties", property);
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle_en.properties", property);
        }
        this.generateXml(this.bundleType);
    }

    protected void generateSpecificClass() throws Exception {
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(" test = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("return test;\n");
        return buffer.toString();
    }

    protected String getBAGetInterestServiceNameContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return " + this.getModelServiceName() + ".SERVICE_NAME;\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_TEST_AGENT_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_TEST_AGENT_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_TEST_AGENT_BUNDLE_ACTIVATOR;
    }

    protected List getImportedServices() {
        return new ArrayList();
    }

    public JavaFileModel getMainModel() {
        return null;
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getBundleActivatorClass();
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected List getManifestExportPackages() {
        ArrayList<String> result = new ArrayList<String>();
        String bap = this.getBundleActivatorPackage();
        result.add(bap);
        return result;
    }

    protected List getManifestExportServices() {
        List vector = super.getManifestExportServices();
        vector.add(DeviceKitGenerationConstants.CLASS_TEST_AGENT_SERVICE);
        List list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.get(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.add(service);
            }
            ++i;
        }
        vector.add(this.getServiceFqn());
        return vector;
    }

    protected List getManifestImportPackages() {
        String packageName;
        List result = super.getManifestImportPackages();
        if (result.contains(packageName = Types.getPackage("TransportBundle"))) {
            result.remove(packageName);
        }
        switch (this.bundleType) {
            case 2: {
                String managedDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TEST_AGENT_MANAGED_BA);
                if (result.contains(managedDevicePack)) break;
                result.add(managedDevicePack);
                break;
            }
            case 3: {
                String factoryDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TEST_AGENT_MANAGED_FACTORY_BA);
                if (result.contains(factoryDevicePack)) break;
                result.add(factoryDevicePack);
            }
        }
        String corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT);
        if (result.contains(corePack)) {
            result.remove(corePack);
        }
        List importedServices = this.getImportedServices();
        int i = 0;
        while (i < importedServices.size()) {
            String serviceFqn = (String)importedServices.get(i);
            String servicePackage = DeviceKitUtilities.extractPackage(serviceFqn);
            result.add(servicePackage);
            ++i;
        }
        return result;
    }

    protected List getManifestImportServices() {
        List vector = super.getManifestImportServices();
        vector.add(DeviceKitGenerationConstants.CLASS_NOTIFICATION_SERVICE);
        return vector;
    }

    public List getManifestRequiredBundles() {
        List result = super.getManifestRequiredBundles();
        String targetId = this.getMainElement().getProjectId();
        boolean isConnection = targetId.endsWith(".connection");
        switch (this.bundleType) {
            case 1: {
                if (isConnection) break;
                result.add(String.valueOf(targetId) + ".bundle");
                break;
            }
            case 2: {
                result.add(String.valueOf(targetId) + ".managed");
                break;
            }
            case 3: {
                result.add(String.valueOf(targetId) + ".factory");
            }
        }
        List required = this.getMainElement().getRequiredBundles();
        int i = 0;
        while (i < required.size()) {
            TagElement element = (TagElement)required.get(i);
            String bundleId = element.getProjectId();
            if (bundleId != null && bundleId.length() > 0) {
                String id = bundleId;
                result.add(id);
                isConnection = id.endsWith(".connection");
                switch (this.bundleType) {
                    case 1: {
                        if (isConnection) break;
                        result.add(String.valueOf(id) + ".bundle");
                        break;
                    }
                    case 2: {
                        result.add(String.valueOf(id) + ".managed");
                        break;
                    }
                    case 3: {
                        result.add(String.valueOf(id) + ".factory");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected String getMetaDataContents() {
        TestAgentFactoryMetaDataBuilder builder = new TestAgentFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataXmlContents();
    }

    protected String getMetaDataProperties() {
        FactoryMetaDataBuilder builder = new FactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    protected String getModelServiceName() {
        List devices = this.fTest.getAllChildrenWithTagCode(this.testType);
        String service = null;
        TagElement device = (TagElement)devices.get(0);
        service = device.getAttribute("service") != null ? device.getAttribute("service") : device.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getBundleActivatorPackage();
        return sfName;
    }

    protected String getTargetType() {
        switch (this.testType) {
            case 9: {
                return "transport";
            }
            case 97: {
                return "transport";
            }
            case 8: {
                return "device";
            }
            case 72: {
                return "adapter";
            }
            case 74: {
                return "profile";
            }
        }
        return "";
    }

    protected TestAgentElement getTestAgentElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (87 == ((TagElement)children.get(i)).getTagCode()) {
                return (TestAgentElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void initialize() {
        this.fTest = this.getTestAgentElement();
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.fTest);
        this.setMainClassName(className);
        this.setPackageBase(this.fTest.getPackageBase());
        String pack = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
        this.setMainPackage(pack);
        this.setDevice(this.fTest);
        this.setMainTagElement(this.fTest);
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save(progressMonitor);
            if (ba != null) {
                result.add(ba);
            }
        }
        this.saveCommon(progressMonitor);
        this.generateXml(this.bundleType, progressMonitor);
        this.generateLaunchCfg(this.bundleType, progressMonitor);
        return result;
    }

    protected void saveBuildProperties(IProgressMonitor progressMonitor) throws Exception {
        String[] additionalBundles;
        switch (this.getBundleType()) {
            case 1: {
                additionalBundles = DeviceKitGenerationConstants.TESTAGENT_BUNDLE_ADDITIONALBUNDLES;
                break;
            }
            case 3: {
                additionalBundles = DeviceKitGenerationConstants.TESTAGENT_MANAGED_ADDITIONALBUNDLES;
                break;
            }
            case 2: {
                additionalBundles = DeviceKitGenerationConstants.TESTAGENT_FACTORY_ADDITIONALBUNDLES;
                break;
            }
            default: {
                additionalBundles = new String[]{};
            }
        }
        if (additionalBundles != null) {
            int i = 0;
            while (i < additionalBundles.length) {
                this.getBuildModel().addAdditionalBundles(additionalBundles[i]);
                ++i;
            }
        }
        super.saveBuildProperties(progressMonitor);
    }
}

