/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;

public class ConfigurationModel {
    public static Map ConnectionMap = ConfigurationModel.createConnectionMap();
    public static Map ConfigurationMap = ConfigurationModel.createConfigurationMap();
    public static String[] CONNECTION_KEYS = new String[]{"file", "randomaccessfile", "serial", "ssl", "tcpip", "tcpipserver", "tcpipmultiplex", "tcpipservermultiplex", "udp", "udpserver", "udpmultiplex", "udpservermultiplex", "url"};
    public static String[] CONFIGURATION_KEYS = new String[]{"transport"};
    public String type;
    protected DeviceKitTagModel tagModel;
    static /* synthetic */ Class class$0;

    public ConfigurationModel() {
    }

    public ConfigurationModel(DeviceKitTagModel tagModel) {
        this.setTagModel(tagModel);
    }

    public ConfigurationModel(String type) {
        this(ConfigurationModel.createTagModel(type));
        this.setType(type);
    }

    public ConfigurationModel(String type, String path) {
        this(ConfigurationModel.createTagModel(type, path));
        this.setType(type);
    }

    public static Map createConfigurationMap() {
        Hashtable map;
        ConfigurationMap = map = new Hashtable(101);
        ConfigurationModel.updateConfigurationMap("transport");
        return map;
    }

    public static Map createConnectionMap() {
        Hashtable map;
        ConnectionMap = map = new Hashtable(101);
        ConfigurationModel.updateConnectionMap("file", "file");
        ConfigurationModel.updateConnectionMap("randomaccessfile", "random.access.file");
        ConfigurationModel.updateConnectionMap("serial", "serial");
        ConfigurationModel.updateConnectionMap("ssl", "ssl");
        ConfigurationModel.updateConnectionMap("tcpip", "tcpip");
        ConfigurationModel.updateConnectionMap("tcpipserver", "tcpip.server");
        ConfigurationModel.updateConnectionMap("tcpipmultiplex", "tcpip.multiplex");
        ConfigurationModel.updateConnectionMap("tcpipservermultiplex", "tcpip.server.multiplex");
        ConfigurationModel.updateConnectionMap("udp", "udp");
        ConfigurationModel.updateConnectionMap("udpserver", "udp.server");
        ConfigurationModel.updateConnectionMap("udpmultiplex", "udp.multiplex");
        ConfigurationModel.updateConnectionMap("udpservermultiplex", "udp.server.multiplex");
        ConfigurationModel.updateConnectionMap("url", "url");
        return map;
    }

    protected static DeviceKitTagModel createTagModel(String type) {
        return ConfigurationModel.createTagModel(type, type, type);
    }

    protected static DeviceKitTagModel createTagModel(String type, String path) {
        return ConfigurationModel.createTagModel(type, String.valueOf(path) + ".connection", "connection");
    }

    protected static DeviceKitTagModel createTagModel(String type, String path, String fileName) {
        try {
            ArrayList references = new ArrayList();
            String pathFull = "org.eclipse.soda.dk." + path;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.model.ConfigurationModel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream stream = clazz.getResource(String.valueOf(pathFull) + "/dk/" + fileName + ".txt").openStream();
            DeviceKitTagModel deviceKitTagModel = new DeviceKitTagModel(stream, references);
            deviceKitTagModel.build(true);
            try {
                stream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return deviceKitTagModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }

    public static ConfigurationModel getConfiguration(String type) {
        return (ConfigurationModel)ConfigurationMap.get(type);
    }

    public static ConfigurationModel getConnection(String type) {
        return (ConfigurationModel)ConnectionMap.get(type);
    }

    public static Map getConnectionMap() {
        if (ConnectionMap == null) {
            ConnectionMap = ConfigurationModel.createConnectionMap();
        }
        return ConnectionMap;
    }

    public static String getValidMetaType(String type) {
        String ttype = type.toLowerCase();
        if (type.endsWith("[]")) {
            ttype = ttype.substring(0, ttype.length() - 2);
        }
        if ("string".equals(ttype)) {
            return "String";
        }
        if ("int".equals(ttype) || "integer".equals(ttype)) {
            return "Integer";
        }
        if ("boolean".equals(ttype) || "bool".equals(ttype)) {
            return "Boolean";
        }
        if ("char".equals(ttype) || "character".equals(ttype)) {
            return "Char";
        }
        if ("long".equals(ttype)) {
            return "Long";
        }
        if ("float".equals(ttype)) {
            return "Float";
        }
        if ("double".equals(ttype)) {
            return "Double";
        }
        if ("short".equals(ttype)) {
            return "Short";
        }
        if ("byte".equals(ttype)) {
            return "Byte";
        }
        if ("biginteger".equals(ttype)) {
            return "BigInteger";
        }
        if ("bigdecimal".equals(ttype)) {
            return "BigDecimal";
        }
        return type;
    }

    public static void main(String[] arguments) {
        String[] keys = CONNECTION_KEYS;
        int j = 0;
        while (j < keys.length) {
            String key = keys[j];
            ConfigurationModel connectionModel = ConfigurationModel.getConnection(key);
            System.out.println(connectionModel.getDescription());
            ConfigurationField[] fields = connectionModel.getConfigurationFields();
            int i = 0;
            while (i < fields.length) {
                System.out.println(fields[i].getConfigurationName());
                ++i;
            }
            ++j;
        }
        System.out.println("map " + ConnectionMap);
        String[] ckeys = CONFIGURATION_KEYS;
        int j2 = 0;
        while (j2 < ckeys.length) {
            String key = ckeys[j2];
            ConfigurationModel connectionModel = ConfigurationModel.getConfiguration(key);
            System.out.println(connectionModel.getDescription());
            ConfigurationField[] fields = connectionModel.getConfigurationFields();
            int i = 0;
            while (i < fields.length) {
                System.out.println(fields[i].getConfigurationName());
                ++i;
            }
            ++j2;
        }
    }

    public static void setConnectionMap(Map connectionMap) {
        ConnectionMap = connectionMap;
    }

    public static void updateConfigurationMap(String type) {
        ConfigurationMap.put(type, new ConfigurationModel(type));
    }

    public static void updateConnectionMap(String type) {
        ConnectionMap.put(type, new ConfigurationModel(type));
    }

    public static void updateConnectionMap(String type, String path) {
        ConnectionMap.put(type, new ConfigurationModel(type, path));
    }

    public ConfigurationField[] getConfigurationFields() {
        try {
            DeviceKitTagModel deviceKitTagModel = this.getTagModel();
            MainTagElement mainElement = deviceKitTagModel.getMainElement();
            List list = mainElement.getAllChildrenWithTagCode(46);
            int size = list.size();
            ConfigurationField[] configurationFields = new ConfigurationField[size];
            int i = 0;
            while (i < size) {
                CustomParameterElement customParameterElement = (CustomParameterElement)list.get(i);
                ConfigurationField configurationField = new ConfigurationField(customParameterElement);
                configurationField.setQualifiedName(this.type);
                configurationFields[i] = configurationField;
                ++i;
            }
            return configurationFields;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ConfigurationField[0];
        }
    }

    public CustomParameterElement[] getCustomParameterElements() {
        try {
            DeviceKitTagModel deviceKitTagModel = this.getTagModel();
            MainTagElement mainElement = deviceKitTagModel.getMainElement();
            List list = mainElement.getAllChildrenWithTagCode(46);
            int size = list.size();
            CustomParameterElement[] customParametersElements = new CustomParameterElement[size];
            customParametersElements = list.toArray(customParametersElements);
            return customParametersElements;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new CustomParameterElement[0];
        }
    }

    public String getDescription() {
        MainTagElement mainElement;
        if (this.tagModel != null && (mainElement = this.tagModel.getMainElement()) != null) {
            String description = mainElement.getDescription();
            if (description != null) {
                return description;
            }
            String id = mainElement.getAnyId();
            if (id != null) {
                return id;
            }
        }
        return this.getType();
    }

    public String getMetadataAttributes() {
        StringBuffer buffer = new StringBuffer(4096);
        try {
            CustomParameterElement[] list = this.getCustomParameterElements();
            int listSize = list.length;
            int i = 0;
            while (i < listSize) {
                CustomParameterElement element = list[i];
                String name = element.getKey();
                String key = name.toLowerCase();
                String displayName = element.getDisplayName();
                if (displayName != null && displayName.length() > 0) {
                    name = displayName;
                }
                buffer.append("\t\t<AD id=\"");
                buffer.append(key);
                buffer.append("\"\r\n");
                buffer.append("\t\t\tname=\"%");
                buffer.append(key);
                buffer.append("\"\r\n");
                String description = element.getDescription();
                if (description == null) {
                    description = "";
                }
                buffer.append("\t\t\tdescription=\"%");
                buffer.append(key);
                buffer.append("_description");
                buffer.append("\"\r\n");
                String type = element.getType();
                String validType = ConfigurationModel.getValidMetaType(type);
                buffer.append("\t\t\ttype=\"");
                buffer.append(validType);
                buffer.append("\"\r\n");
                String cardinality = element.getCardinality();
                String size = element.getSize();
                String requiredValue = element.getRequired();
                String min = element.getMinimum();
                String max = element.getMaximum();
                String defaultValue = element.getDefaultValue();
                if (defaultValue != null) {
                    buffer.append("\t\t\tdefault=\"");
                    buffer.append(defaultValue);
                    buffer.append("\"\r\n");
                } else if (cardinality == null) {
                    buffer.append("\t\t\tdefault=\"\"\r\n");
                }
                if (cardinality != null) {
                    buffer.append("\t\t\tcardinality=\"");
                    if ("ARRAY".equals(cardinality)) {
                        if (size != null) {
                            buffer.append(size);
                        } else {
                            buffer.append(Integer.MAX_VALUE);
                        }
                    } else if (size != null) {
                        buffer.append('-');
                        buffer.append(size);
                    } else {
                        buffer.append(Integer.MIN_VALUE);
                    }
                    buffer.append("\"\r\n");
                } else {
                    buffer.append("\t\t\tcardinality=\"0\"\r\n");
                }
                if (min == null || min.length() > 0) {
                    buffer.append("\t\t\tmin=\"");
                    buffer.append(min);
                    buffer.append("\"\r\n");
                }
                if (max == null || max.length() > 0) {
                    buffer.append("\t\t\tmax=\"");
                    buffer.append(max);
                    buffer.append("\"\r\n");
                }
                buffer.append("\t\t\trequired=\"");
                if (requiredValue == null || requiredValue.length() == 0) {
                    buffer.append("false");
                } else {
                    buffer.append(requiredValue);
                }
                buffer.append('\"');
                boolean done = true;
                List enums = element.getAllChildrenWithTagCode(77);
                if (enums != null && enums.size() > 0) {
                    int j = 0;
                    while (j < enums.size()) {
                        EnumElement enumElement = (EnumElement)enums.get(j);
                        String enumKey = enumElement.getLabel();
                        String value = enumElement.getValue();
                        if (value == null) {
                            value = Integer.toString(j);
                        }
                        if (done) {
                            buffer.append(">\r\n");
                            done = false;
                        }
                        buffer.append("\t\t\t<Option value=\"");
                        buffer.append(value);
                        buffer.append("\" label=\"");
                        buffer.append(enumKey);
                        buffer.append("\"/>\r\n");
                        ++j;
                    }
                }
                if (done) {
                    buffer.append("/>\r\n");
                } else {
                    buffer.append("\t\t</AD>\r\n");
                }
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return buffer.toString();
    }

    public String getMetadataProperties() {
        StringBuffer buffer = new StringBuffer(4096);
        try {
            CustomParameterElement[] list = this.getCustomParameterElements();
            int listSize = list.length;
            int i = 0;
            while (i < listSize) {
                CustomParameterElement element = list[i];
                String name = element.getKey();
                String key = name.toLowerCase();
                String displayName = element.getDisplayName();
                if (displayName != null && displayName.length() > 0) {
                    name = displayName;
                }
                buffer.append(key);
                buffer.append('=');
                buffer.append(name);
                buffer.append('\r');
                buffer.append('\n');
                String description = element.getDescription();
                if (description == null) {
                    description = "";
                }
                buffer.append(key);
                buffer.append("_description");
                buffer.append('=');
                buffer.append(description);
                buffer.append('\r');
                buffer.append('\n');
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return buffer.toString();
    }

    public DeviceKitTagModel getTagModel() {
        return this.tagModel;
    }

    public String getType() {
        return this.type;
    }

    public void setTagModel(DeviceKitTagModel tagModel) {
        this.tagModel = tagModel;
    }

    public void setType(String type) {
        this.type = type;
    }
}

