/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.manifest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.pde.internal.ui.wizards.tools.IOrganizeManifestsSettings;
import org.eclipse.soda.devicekit.generator.constants.ManifestConstants;
import org.eclipse.soda.devicekit.generator.manifest.EclipseManifestSaver;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.util.JREPreferenceUtil;
import org.eclipse.swt.widgets.Display;

public class SourceFolderManifestSaver
extends EclipseManifestSaver {
    private IJavaProject project;
    private boolean create;
    private Map extraFiles;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SourceFolderManifestSaver(IJavaProject project, String sourceFolderName, boolean create, Map extraManifestFiles) {
        super(null);
        this.project = project;
        this.create = true;
        this.extraFiles = extraManifestFiles;
    }

    static IDialogSettings getSettings() {
        DialogSettings settings = new DialogSettings("");
        settings.put("OrganizeManifests.ExportedPackages.addMissing", false);
        settings.put("OrganizeManifests.ExportedPackages.makeInternal", true);
        settings.put("OrganizeManifests.ExportedPackages.removeUnresolved", true);
        settings.put("OrganizeManifests.AddDependencies", true);
        settings.put("OrganizeManifests.RequireImport.modifyDep", true);
        settings.put("OrganizeManifests.RequireImport.resolve:markOptional", true);
        settings.put("OrganizeManifests.RequireImport.findRemoveUnused", false);
        settings.put("OrganizeManifests.General.cleanup", true);
        return settings;
    }

    protected boolean contentsChanged(String oldStream, String newStream) throws IOException {
        boolean result = !this.isEqualString(oldStream, newStream);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createOtherOsgiFiles(IContainer parent, IProgressMonitor progressMonitor) throws Exception {
        SubProgressMonitor subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
        try {
            subMonitor.subTask(parent.getFullPath().toString());
            super.createOtherOsgiFiles(parent, progressMonitor);
            if (this.extraFiles != null) {
                Iterator keys = this.extraFiles.keySet().iterator();
                while (keys.hasNext()) {
                    IFile file;
                    String fileName = (String)keys.next();
                    int index = fileName.indexOf(47);
                    if (index >= 0) {
                        this.saveAllDirectory(fileName, parent.getProject(), (IProgressMonitor)subMonitor);
                        file = parent.getProject().getFile((IPath)new Path(fileName));
                    } else {
                        file = parent.getFile((IPath)new Path(fileName));
                    }
                    String newString = (String)this.extraFiles.get(fileName);
                    if (newString == null || newString.length() <= 0) continue;
                    if (!file.exists() && this.create) {
                        ByteArrayInputStream stream = new ByteArrayInputStream(newString.getBytes());
                        file.create((InputStream)stream, true, (IProgressMonitor)subMonitor);
                        continue;
                    }
                    String oldString = DeviceKitUtilities.getStringFromStream(file.getContents(true));
                    if (!this.create || !this.contentsChanged(oldString, newString)) continue;
                    ByteArrayInputStream stream = new ByteArrayInputStream(newString.getBytes());
                    file.setContents((InputStream)stream, true, true, (IProgressMonitor)subMonitor);
                }
                this.extraFiles = null;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            subMonitor.done();
            throw throwable;
        }
        subMonitor.done();
    }

    protected IJavaProject getProject() {
        return this.project;
    }

    protected Map getTemplateVariables(ManifestModel model) {
        HashMap<String, String> map = new HashMap<String, String>(101);
        String year = String.valueOf(Calendar.getInstance().get(1));
        String vendor = model.getVendor();
        map.put("vendor", vendor);
        String vendors = model.getVendors();
        map.put("vendors", vendors);
        map.put("year", year);
        map.put("years", year);
        map.put("provider", vendor);
        map.put("packagebase", "packagebase");
        String version = model.getVersion();
        map.put("version", version);
        return map;
    }

    private boolean isIgnoredKey(Attributes.Name key) {
        int i = 0;
        while (i < ManifestConstants.IGNORED_KEYS.length) {
            if (ManifestConstants.IGNORED_KEYS[i].equals(key.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean manifestChanged(IFile eclipseManifest, ManifestModel manifestModel) throws CoreException, IOException {
        boolean bl;
        block2: {
            InputStream currentStream = null;
            try {
                currentStream = eclipseManifest.getContents(true);
                Manifest currentManifest = new Manifest(currentStream);
                Manifest newManifest = manifestModel.getManifest();
                bl = this.manifestChanged(currentManifest, newManifest);
                Object var6_7 = null;
                if (currentStream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_8 = null;
                    if (currentStream == null) break block3;
                    currentStream.close();
                    currentStream = null;
                }
                throw throwable;
            }
            currentStream.close();
            currentStream = null;
        }
        return bl;
    }

    private boolean manifestChanged(Manifest currentManifest, Manifest newManifest) {
        Attributes newAttributes = newManifest.getMainAttributes();
        Attributes currAttributes = currentManifest.getMainAttributes();
        Iterator<Object> newKeys = newAttributes.keySet().iterator();
        while (newKeys.hasNext()) {
            int newNumber;
            Attributes.Name key = (Attributes.Name)newKeys.next();
            if (this.isIgnoredKey(key)) continue;
            String newValue = newAttributes.getValue(key);
            String currValue = currAttributes.getValue(key);
            if (newValue == null) {
                newValue = "";
            }
            if (currValue == null) {
                currValue = "";
            }
            StringTokenizer currSt = new StringTokenizer(currValue, ",");
            StringTokenizer newSt = new StringTokenizer(newValue, ",");
            int currNumber = currSt.countTokens();
            if (currNumber != (newNumber = newSt.countTokens())) {
                return true;
            }
            String[] currArray = new String[currNumber];
            int i = 0;
            while (currSt.hasMoreTokens()) {
                currArray[i++] = currSt.nextToken();
            }
            String[] newArray = new String[newNumber];
            i = 0;
            while (newSt.hasMoreTokens()) {
                newArray[i++] = newSt.nextToken();
            }
            boolean found = false;
            int j = 0;
            while (j < newArray.length) {
                int k = 0;
                while (k < currArray.length) {
                    if (newArray[j].equals(currArray[k])) {
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public Object organize(IGeneratorModel object, IProgressMonitor progressMonitor) throws Exception {
        SubProgressMonitor subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
        try {
            IJavaProject jProject = this.getProject();
            IProject root = jProject.getProject();
            final IFolder metaInf = root.getFolder("META-INF");
            Display display = Display.getDefault();
            if (display != null) {
                subMonitor.subTask(String.valueOf(jProject.getElementName()) + "/META-INF/MANIFEST.MF");
                display.syncExec(new Runnable((IProgressMonitor)subMonitor){
                    private final /* synthetic */ IProgressMonitor val$subMonitor;
                    {
                        this.val$subMonitor = iProgressMonitor;
                    }

                    public void run() {
                        block14: {
                            ArrayList<IProject> projects = new ArrayList<IProject>();
                            projects.add(metaInf.getProject());
                            try {
                                String className = "org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsOperation";
                                Class<?> loadClass = null;
                                try {
                                    loadClass = Class.forName(className);
                                }
                                catch (Exception exception) {
                                    className = "org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsProcessor";
                                    loadClass = Class.forName(className);
                                }
                                if (loadClass == null) break block14;
                                Class[] classArray = new Class[1];
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("java.util.ArrayList");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                classArray[0] = clazz;
                                Class[] parameterTypes = classArray;
                                Constructor<?> constructor = loadClass.getConstructor(parameterTypes);
                                if (constructor == null) break block14;
                                Object[] initargs = new Object[]{projects};
                                Object op = constructor.newInstance(initargs);
                                if (op instanceof IOrganizeManifestsSettings && className.equals("org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsOperation")) {
                                    Class[] classArray2 = new Class[1];
                                    Class<?> clazz2 = class$1;
                                    if (clazz2 == null) {
                                        try {
                                            clazz2 = class$1 = Class.forName("org.eclipse.jface.dialogs.IDialogSettings");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    classArray2[0] = clazz2;
                                    Class[] mparameterTypes = classArray2;
                                    Method method = loadClass.getMethod("setOperations", mparameterTypes);
                                    IDialogSettings settings = SourceFolderManifestSaver.getSettings();
                                    Object[] arguments = new Object[]{settings};
                                    method.invoke(op, arguments);
                                }
                                if (op instanceof IRunnableWithProgress) {
                                    ((IRunnableWithProgress)op).run(this.val$subMonitor);
                                } else if (op instanceof RefactoringProcessor) {
                                    RefactoringProcessor refactoringProcessor = (RefactoringProcessor)op;
                                    Change change = refactoringProcessor.createChange((IProgressMonitor)new NullProgressMonitor());
                                    PerformChangeOperation performChangeOperation = new PerformChangeOperation(change);
                                    performChangeOperation.run((IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                });
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            subMonitor.done();
            throw throwable;
        }
        subMonitor.done();
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object save(ManifestModel model, IProgressMonitor progressMonitor) throws Exception {
        SubProgressMonitor subMonitor;
        block13: {
            IFile iFile;
            subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
            try {
                IFile manifest;
                block14: {
                    IFile oldMetadataProperties;
                    IJavaProject jProject = this.getProject();
                    IProject root = jProject.getProject();
                    subMonitor.subTask(String.valueOf(jProject.getElementName()) + "/META-INF/MANIFEST.MF");
                    IFolder metaInf = root.getFolder("META-INF");
                    if (!metaInf.exists()) {
                        metaInf.create(true, true, (IProgressMonitor)subMonitor);
                    }
                    if (!metaInf.exists()) break block13;
                    IFile oldMetadata = metaInf.getFile("METADATA.XML");
                    if (oldMetadata.exists()) {
                        oldMetadata.delete(true, (IProgressMonitor)subMonitor);
                    }
                    if ((oldMetadataProperties = metaInf.getFile("METADATA_en.properties")).exists()) {
                        oldMetadataProperties.delete(true, (IProgressMonitor)subMonitor);
                    }
                    manifest = metaInf.getFile("MANIFEST.MF");
                    InputStream stream = null;
                    try {
                        if (!manifest.exists()) {
                            if (model.getRequiredExecutionEnvironments() == null) {
                                JREPreferenceUtil.processExecutionEnvironmentsInManifest(jProject, model);
                            }
                            stream = new ByteArrayInputStream(model.getContents().getBytes());
                            manifest.create(stream, true, (IProgressMonitor)subMonitor);
                        } else {
                            ManifestModel currentManifest = new ManifestModel(manifest);
                            boolean changed = currentManifest.updateModel(model);
                            if (changed) {
                                String newString = currentManifest.getContents();
                                String oldString = DeviceKitUtilities.getStringFromStream(manifest.getContents(true));
                                if (this.contentsChanged(oldString, newString)) {
                                    stream = new ByteArrayInputStream(newString.getBytes());
                                    manifest.setContents(stream, true, true, (IProgressMonitor)subMonitor);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_16 = null;
                        if (stream == null) throw throwable;
                        stream.close();
                        throw throwable;
                    }
                    {
                        Object var15_17 = null;
                        if (stream == null) break block14;
                    }
                    stream.close();
                }
                this.createOtherOsgiFiles(manifest.getParent(), progressMonitor);
                iFile = manifest;
                Object var17_19 = null;
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                subMonitor.done();
                throw throwable;
            }
            subMonitor.done();
            return iFile;
        }
        Object var17_20 = null;
        subMonitor.done();
        return null;
    }

    public void saveAllDirectory(String name, IProject project, IProgressMonitor progressMonitor) {
        try {
            IFolder directory = null;
            StringTokenizer tokenizer = new StringTokenizer(name, "/");
            int count = tokenizer.countTokens();
            int i = 0;
            while (i < count - 1) {
                String token = tokenizer.nextToken();
                IFolder folder = null;
                if (i == 0) {
                    folder = project.getFolder(token);
                } else if (directory != null) {
                    folder = directory.getFolder(token);
                }
                if (folder != null && !folder.exists()) {
                    folder.create(true, true, progressMonitor);
                }
                directory = folder;
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

