/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.xml;

import java.util.List;
import org.eclipse.soda.devicekit.generator.internal.model.xml.KeyPair;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.print.XmlPrinter;

public class XmlElementPrinter
extends XmlPrinter {
    public static final char[] SPECIAL_CHARS = new char[]{'<', '>', '&'};
    public static final char[] AMP = "&amp;".toCharArray();
    public static final char[] COMMENT_BEGIN = "!--".toCharArray();
    public static final char[] COMMENT_END = " --".toCharArray();
    public static final char[] CR_LF = "\r\n".toCharArray();
    public static final char[] ENTITY = "!ENTITY ".toCharArray();
    public static final char[] GT = "&gt;".toCharArray();
    public static final char[] LT = "&lt;".toCharArray();
    public static final char[] QUOT = "&quot;".toCharArray();
    private IXmlElement element;

    public XmlElementPrinter(IXmlElement element, int indentation) {
        super(indentation);
        this.element = element;
        this.printElement();
    }

    public void endCDATA() {
        this.print("]]>");
    }

    public IXmlElement getElement() {
        return this.element;
    }

    protected void printElement() {
        IXmlElement element = this.getElement();
        List comments = element.getComments();
        if (comments.size() > 0) {
            this.printNewLine();
            this.printComments(comments);
            this.printIndentation();
        }
        this.startTag(element.getTag());
        List attributes = element.getAttributes();
        if (attributes.size() > 0) {
            this.incrementIndent();
            int i = 0;
            while (i < attributes.size()) {
                if (i > 0) {
                    this.printNewLine();
                    this.printIndentation();
                }
                KeyPair pair = (KeyPair)attributes.get(i);
                this.printAttribute(pair.getKey(), pair.getValue());
                ++i;
            }
            this.decrementIndent();
        }
        List children = element.getElements();
        String data = element.getData();
        if (children.size() == 0 && (data == null || data.trim().length() == 0)) {
            this.endEmptyTag(false);
        } else {
            this.endTag(false);
            if (data != null) {
                this.printText(data);
            }
            if (children.size() > 0) {
                this.incrementIndent();
                this.printNewLine();
                int i = 0;
                while (i < children.size()) {
                    this.printElement((IXmlElement)children.get(i));
                    this.printNewLine();
                    ++i;
                }
                this.decrementIndent();
                this.printIndentation();
            }
            this.endTag(element.getTag());
        }
    }

    protected void printElement(IXmlElement element) {
        this.printWithIndent(element.print(this.getCurrentIndentenation()));
    }

    private void printText(String data) {
        int count = 0;
        char[] characters = data.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            int j = 0;
            while (j < SPECIAL_CHARS.length) {
                if (character == SPECIAL_CHARS[j]) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        if (count > 0) {
            this.startCDATA();
            this.print(data);
            this.endCDATA();
        } else {
            this.print(data);
        }
    }

    public void startCDATA() {
        this.print("<![CDATA[");
    }
}

