/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitContentProvider;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormEditor;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormPage;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitLabelProvider;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitSourcePage;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitViewerComparator;
import org.eclipse.soda.devicekit.editor.dkml.OutlineSortAction;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElementLink;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class DeviceKitContentOutlinePage
extends ContentOutlinePage
implements IPageChangedListener,
IDocumentListener {
    private boolean sort = false;
    private DeviceKitViewerComparator deviceKitViewerComparator;
    private DeviceKitContentProvider deviceKitContentProvider;
    private DeviceKitLabelProvider deviceKitLabelProvider;
    private DeviceKitTagModel tagModel;
    private DeviceKitFormEditor editor;
    private DeviceKitSourcePage sourcePage;
    private DeviceKitFormPage currentPage;
    protected MenuItem gotoidMenuItem;
    protected MenuItem gotoMenuItem;
    static /* synthetic */ Class class$0;

    public DeviceKitContentOutlinePage(DeviceKitFormEditor editor) {
        this.setEditor(editor);
        if (editor != null) {
            DeviceKitSourcePage deviceKitSourcePage = editor.getSourcePage();
            this.setSourcePage(deviceKitSourcePage);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            DeviceKitContentProvider deviceKitContentProvider = new DeviceKitContentProvider();
            this.setDeviceKitContentProvider(deviceKitContentProvider);
            treeViewer.setContentProvider((IContentProvider)deviceKitContentProvider);
            DeviceKitLabelProvider deviceKitLabelProvider = new DeviceKitLabelProvider(this.getEditor());
            this.setDeviceKitLabelProvider(deviceKitLabelProvider);
            treeViewer.setLabelProvider((IBaseLabelProvider)deviceKitLabelProvider);
            if (this.tagModel != null) {
                treeViewer.setInput((Object)this.getEditor());
            }
            this.setSort(this.isSort());
            IActionBars actionBars = this.getSite().getActionBars();
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            OutlineSortAction action = new OutlineSortAction(this);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.editor.DeviceKitEditorPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile((Class)clazz, (String)"icons/sort.gif");
            action.setImageDescriptor(imageDescriptor);
            toolBarManager.add((IAction)action);
            Menu menu = new Menu((Decorations)parent.getShell(), 8);
            this.gotoMenuItem = new MenuItem(menu, 0);
            this.gotoMenuItem.setText("Goto");
            this.gotoMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = DeviceKitContentOutlinePage.this.getTreeViewer().getSelection();
                    if (selection instanceof TreeSelection) {
                        DeviceKitContentOutlinePage.this.select((TreeSelection)selection, false);
                    }
                }
            });
            this.gotoidMenuItem = new MenuItem(menu, 0);
            this.gotoidMenuItem.setText("Goto id");
            this.gotoidMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = DeviceKitContentOutlinePage.this.getTreeViewer().getSelection();
                    if (selection instanceof TreeSelection) {
                        DeviceKitContentOutlinePage.this.select((TreeSelection)selection, true);
                    }
                }
            });
            menu.addMenuListener(new MenuListener(){

                public void menuHidden(MenuEvent e) {
                }

                public void menuShown(MenuEvent e) {
                    ISelection selection = DeviceKitContentOutlinePage.this.getTreeViewer().getSelection();
                    boolean enable = false;
                    if (selection instanceof TreeSelection) {
                        TagElement tagElement;
                        String idref;
                        TreeSelection treeSelection = (TreeSelection)selection;
                        Object object = treeSelection.getFirstElement();
                        if (object instanceof TagElementLink) {
                            enable = true;
                        } else if (object instanceof TagElement && (idref = (tagElement = (TagElement)object).getIdRef()) != null && idref.length() > 0) {
                            enable = true;
                        }
                    }
                    DeviceKitContentOutlinePage.this.gotoidMenuItem.setEnabled(enable);
                }
            });
            treeViewer.getTree().setMenu(menu);
        }
    }

    public void dispose() {
        this.setTagModel(null);
        this.setEditor(null);
        this.setSourcePage(null);
        this.removeSelectionChangedListener((ISelectionChangedListener)this);
        TreeViewer tree = this.getTreeViewer();
        if (tree != null) {
            tree.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.dispose();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.update();
    }

    public DeviceKitFormPage getCurrentPage() {
        return this.currentPage;
    }

    public DeviceKitContentProvider getDeviceKitContentProvider() {
        return this.deviceKitContentProvider;
    }

    public DeviceKitLabelProvider getDeviceKitLabelProvider() {
        return this.deviceKitLabelProvider;
    }

    public DeviceKitViewerComparator getDeviceKitViewerComparator() {
        return this.deviceKitViewerComparator;
    }

    public DeviceKitFormEditor getEditor() {
        return this.editor;
    }

    public DeviceKitSourcePage getSourcePage() {
        DeviceKitFormEditor editor;
        if (this.sourcePage == null && (editor = this.getEditor()) != null) {
            DeviceKitSourcePage deviceKitSourcePage = editor.getSourcePage();
            this.setSourcePage(deviceKitSourcePage);
        }
        return this.sourcePage;
    }

    public DeviceKitTagModel getTagModel() {
        return this.tagModel;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public boolean isSort() {
        return this.sort;
    }

    public void pageChanged(PageChangedEvent event) {
        Object object = event.getSelectedPage();
        if (object instanceof DeviceKitFormPage) {
            DeviceKitFormPage page = (DeviceKitFormPage)object;
            this.setCurrentPage(page);
        } else {
            this.setCurrentPage(null);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void select(TreeSelection selection, boolean selectReal) {
        IFormPage page;
        FormEditor editor;
        TreeSelection treeSelection = selection;
        TreePath[] paths = treeSelection.getPaths();
        int i = 0;
        while (i < paths.length) {
            IFormPage page2;
            FormEditor editor2;
            TreePath path = paths[i];
            Object segment = path.getFirstSegment();
            if (segment instanceof IFormPage && (editor2 = (page2 = (IFormPage)segment).getEditor()) instanceof DeviceKitFormEditor) {
                DeviceKitFormEditor formEditor = (DeviceKitFormEditor)editor2;
                formEditor.setActivePage(page2.getId());
            }
            ++i;
        }
        Object object = treeSelection.getFirstElement();
        if (object instanceof TagElement) {
            TagElement element = (TagElement)object;
            DeviceKitFormPage currentPage = this.getCurrentPage();
            if (currentPage != null) {
                currentPage.select(element);
            } else {
                DeviceKitSourcePage sourcePage = this.getSourcePage();
                if (sourcePage != null) {
                    sourcePage.select(element, selectReal);
                }
            }
        }
        if (object instanceof IFormPage && (editor = (page = (IFormPage)object).getEditor()) instanceof DeviceKitFormEditor) {
            DeviceKitFormEditor formEditor = (DeviceKitFormEditor)editor;
            formEditor.setActivePage(page.getId());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection instanceof TreeSelection) {
            this.select((TreeSelection)selection, false);
        }
    }

    public void setCurrentPage(DeviceKitFormPage currentPage) {
        this.currentPage = currentPage;
    }

    public void setDeviceKitContentProvider(DeviceKitContentProvider deviceKitContentProvider) {
        this.deviceKitContentProvider = deviceKitContentProvider;
    }

    public void setDeviceKitLabelProvider(DeviceKitLabelProvider deviceKitLabelProvider) {
        this.deviceKitLabelProvider = deviceKitLabelProvider;
    }

    public void setDeviceKitViewerComparator(DeviceKitViewerComparator deviceKitViewerComparator) {
        this.deviceKitViewerComparator = deviceKitViewerComparator;
    }

    public void setEditor(DeviceKitFormEditor editor) {
        if (this.editor != null) {
            this.editor.removePageChangedListener(this);
        }
        this.editor = editor;
        if (editor != null) {
            editor.addPageChangedListener(this);
        }
    }

    public void setSort(boolean sort) {
        TreeViewer treeViewer = this.getTreeViewer();
        DeviceKitViewerComparator comparator = null;
        if (treeViewer != null) {
            if (sort) {
                if (this.deviceKitViewerComparator == null) {
                    this.setDeviceKitViewerComparator(new DeviceKitViewerComparator());
                }
                comparator = this.getDeviceKitViewerComparator();
            }
            treeViewer.setComparator(comparator);
        }
        this.sort = sort;
    }

    public void setSourcePage(DeviceKitSourcePage sourcePage) {
        this.sourcePage = sourcePage;
    }

    public void setTagModel(DeviceKitTagModel tagModel) {
        this.tagModel = tagModel;
    }

    public void update() {
        this.getTreeViewer().refresh(true);
    }

    public void updateContents() {
        this.update();
    }
}

