/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin;

import java.net.URL;
import java.util.Dictionary;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soda.sat.plugin.util.FakeQualiferGenerator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AboutExtension {
    private static final String ABOUT_ELEMENT = "about";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String QUALIFIER = "qualifier";
    private IExtension extension;
    private Object image;

    public AboutExtension(IExtension extension) {
        this.setExtension(extension);
    }

    private String basicGetVersion() {
        Dictionary<?, ?> headers = this.getBundleManifestHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version;
    }

    private String createQualifiedVersion(String version) {
        int length = version.length();
        int index = length - QUALIFIER.length();
        FakeQualiferGenerator generator = new FakeQualiferGenerator();
        String qualifier = generator.generate();
        String qualifiedVersion = String.valueOf(version.substring(0, index)) + qualifier;
        return qualifiedVersion;
    }

    private IConfigurationElement getAboutElement() {
        IExtension extension = this.getExtension();
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length == 0) {
            return null;
        }
        IConfigurationElement element = elements[0];
        String name = element.getName();
        if (!name.equals(ABOUT_ELEMENT)) {
            return null;
        }
        return element;
    }

    private Bundle getBundle() {
        IExtension extension = this.getExtension();
        String id = extension.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)id);
        return bundle;
    }

    private Dictionary<?, ?> getBundleManifestHeaders() {
        Bundle bundle = this.getBundle();
        Dictionary headers = bundle.getHeaders();
        return headers;
    }

    public String getDescription() {
        IConfigurationElement element = this.getAboutElement();
        if (element == null) {
            return null;
        }
        String description = element.getValue();
        if (description == null) {
            description = "<None>";
        }
        return description;
    }

    private IExtension getExtension() {
        return this.extension;
    }

    public String getIconName() {
        IConfigurationElement element = this.getAboutElement();
        if (element == null) {
            return null;
        }
        String icon = element.getAttribute(ICON_ATTRIBUTE);
        return icon;
    }

    public Object getImage() {
        return this.image;
    }

    public URL getInstallUrl() {
        Bundle bundle = this.getBundle();
        URL url = bundle.getEntry("/");
        return url;
    }

    public String getPluginId() {
        IExtension extension = this.getExtension();
        String id = extension.getNamespaceIdentifier();
        return id;
    }

    public String getPluginName() {
        Dictionary<?, ?> headers = this.getBundleManifestHeaders();
        String name = (String)headers.get("Bundle-Name");
        name = name.replace('_', ' ');
        return name;
    }

    public String getProviderName() {
        Dictionary<?, ?> headers = this.getBundleManifestHeaders();
        String name = (String)headers.get("Bundle-Vendor");
        return name;
    }

    public String getVersion() {
        String version = this.basicGetVersion();
        boolean qualified = this.isQualifiedVersion(version);
        if (!qualified) {
            version = this.createQualifiedVersion(version);
        }
        return version;
    }

    private boolean isQualifiedVersion(String version) {
        boolean qualified = !version.endsWith(QUALIFIER);
        return qualified;
    }

    private void setExtension(IExtension extension) {
        this.extension = extension;
    }

    public void setImage(Object image) {
        this.image = image;
    }
}

