/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.internal;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyPreferences;
import org.eclipse.soda.sat.plugin.dependency.bundle.Activator;

public class BundleDependencyPreferences
implements IBundleDependencyPreferences {
    private static final boolean DEFAULT_DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET = false;
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_POLL_FREQUENCY = 5;
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_SERVLET_ALIAS = "/bds";
    private static final boolean DEFAULT_SHOW_ALL_BUNDLES = false;
    private static final String DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET = "doNotRemindMeToInstallDependencyServlet";
    private static final String HOST = "host";
    private static final String POLL_FREQUENCY = "pollFrequency";
    private static final String PORT = "portPreference";
    private static final String SERVLET_ALIAS = "servletAlias";
    private static final String SHOW_ALL_BUNDLES = "showAllBundles";
    private Preferences model;

    public BundleDependencyPreferences(Preferences preferences) {
        this.setModel(preferences);
    }

    private boolean getBooleanPreference(String key) {
        Preferences model = this.getModel();
        boolean value = model.getBoolean(key);
        return value;
    }

    private boolean getDefaultBooleanPreference(String key) {
        Preferences model = this.getModel();
        boolean value = model.getDefaultBoolean(key);
        return value;
    }

    public boolean getDefaultDoNotRemindMeToInstallDependencyServlet() {
        boolean value = this.getDefaultBooleanPreference(DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET);
        return value;
    }

    public String getDefaultHost() {
        String value = this.getDefaultStringPreference(HOST);
        return value;
    }

    public String getDefaultPollFrequency() {
        String value = this.getDefaultStringPreference(POLL_FREQUENCY);
        return value;
    }

    public String getDefaultPort() {
        String value = this.getDefaultStringPreference(PORT);
        return value;
    }

    public String getDefaultServletAlias() {
        String value = this.getDefaultStringPreference(SERVLET_ALIAS);
        return value;
    }

    public boolean getDefaultShowAllBundles() {
        boolean value = this.getDefaultBooleanPreference(SHOW_ALL_BUNDLES);
        return value;
    }

    private String getDefaultStringPreference(String key) {
        Preferences model = this.getModel();
        String value = model.getDefaultString(key);
        return value;
    }

    public boolean getDoNotRemindMeToInstallDependencyServlet() {
        boolean doNotRemindMe = this.getBooleanPreference(DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET);
        return doNotRemindMe;
    }

    public String getHost() {
        String host = this.getStringPreference(HOST);
        return host;
    }

    private Preferences getModel() {
        return this.model;
    }

    public String getPollFrequency() {
        String pollFrequency = this.getStringPreference(POLL_FREQUENCY);
        return pollFrequency;
    }

    public String getPort() {
        String port = this.getStringPreference(PORT);
        return port;
    }

    public String getServletAlias() {
        String host = this.getStringPreference(SERVLET_ALIAS);
        return host;
    }

    public boolean getShowAllBundles() {
        boolean showAllBundles = this.getBooleanPreference(SHOW_ALL_BUNDLES);
        return showAllBundles;
    }

    private String getStringPreference(String key) {
        Preferences model = this.getModel();
        String value = model.getString(key);
        return value;
    }

    private void initializeDefaults() {
        Preferences model = this.getModel();
        model.setDefault(HOST, DEFAULT_HOST);
        model.setDefault(PORT, 80);
        model.setDefault(SERVLET_ALIAS, DEFAULT_SERVLET_ALIAS);
        model.setDefault(SHOW_ALL_BUNDLES, false);
        model.setDefault(POLL_FREQUENCY, 5);
        model.setDefault(DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET, false);
    }

    private boolean isEmpty(String value) {
        return value.length() == 0;
    }

    private boolean isFreeOfSpaces(String value) {
        return value.indexOf(32) == -1;
    }

    public boolean isValidHost(String host) {
        boolean valid = true;
        String value = host.trim();
        valid = valid && !this.isEmpty(value);
        valid = valid && this.isFreeOfSpaces(value);
        return valid;
    }

    private boolean isValidInteger(String value, int minimum) {
        boolean valid = true;
        try {
            int intValue = Integer.parseInt(value);
            valid = intValue >= minimum;
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        return valid;
    }

    public boolean isValidPollFrequency(String pollFrequency) {
        boolean valid = true;
        String value = pollFrequency.trim();
        valid = valid && !this.isEmpty(value);
        valid = valid && this.isValidInteger(value, 1);
        return valid;
    }

    public boolean isValidPort(String port) {
        boolean valid = true;
        String value = port.trim();
        valid = valid && !this.isEmpty(value);
        valid = valid && this.isValidInteger(value, 1);
        return valid;
    }

    public boolean isValidServletAlias(String servletAlias) {
        char forwardSlash = '/';
        boolean valid = true;
        String value = servletAlias.trim();
        int length = value.length();
        valid = valid && !this.isEmpty(value);
        valid = valid && this.isFreeOfSpaces(value);
        valid = valid && servletAlias.charAt(0) == forwardSlash;
        valid = valid && servletAlias.charAt(length - 1) != forwardSlash;
        return valid;
    }

    public void save() {
        Activator plugin = Activator.getDefault();
        plugin.savePluginPreferences();
    }

    private void setBooleanPreference(String key, boolean value) {
        Preferences model = this.getModel();
        model.setValue(key, value);
    }

    public void setDoNotRemindMeToInstallDependencyServlet(boolean doNotRemindMe) {
        this.setBooleanPreference(DO_NOT_REMIND_ME_TO_INSTALL_DEPENDENCY_SERVLET, doNotRemindMe);
    }

    public void setHost(String host) {
        String value = host.trim();
        boolean valid = this.isValidHost(value);
        if (!valid) {
            return;
        }
        this.setStringPreference(HOST, value);
    }

    private void setModel(Preferences model) {
        this.model = model;
        this.initializeDefaults();
    }

    public void setPollFrequency(String pollFrequency) {
        String value = pollFrequency.trim();
        boolean valid = this.isValidPollFrequency(value);
        if (!valid) {
            return;
        }
        this.setStringPreference(POLL_FREQUENCY, value);
    }

    public void setPort(String port) {
        String value = port.trim();
        boolean valid = this.isValidPort(value);
        if (!valid) {
            return;
        }
        this.setStringPreference(PORT, value);
    }

    public void setServletAlias(String servletAlias) {
        String value = servletAlias.trim();
        boolean valid = this.isValidServletAlias(servletAlias);
        if (!valid) {
            return;
        }
        this.setStringPreference(SERVLET_ALIAS, value);
    }

    public void setShowAllBundles(boolean showAllBundles) {
        this.setBooleanPreference(SHOW_ALL_BUNDLES, showAllBundles);
    }

    private void setStringPreference(String key, String value) {
        Preferences model = this.getModel();
        model.setValue(key, value);
    }
}

