/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.ui.internal.bundle;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IImageManager;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator INSTANCE;
    private static final String FAILED_TO_CREATE_URL_KEY = "Activator.FailedToCreateUrl";
    public static final String BUNDLE_ACTIVE_IMAGE = "bundle-active";
    public static final String BUNDLE_EXPORTER_IMAGE = "bundle-exporter";
    public static final String BUNDLE_INSTALLED_IMAGE = "bundle-installed";
    public static final String BUNDLE_IMPORTER_EXPORTER_IMAGE = "bundle-importer-exporter";
    public static final String BUNDLE_IMPORTER_IMAGE = "bundle-importer";
    public static final String BUNDLE_RESOLVED_IMAGE = "bundle-resolved";
    public static final String CONFIGURE_IMAGE = "configure";
    public static final String COPY_IMAGE = "copy";
    public static final String HORIZONTAL_IMAGE = "horizontal";
    public static final String LOCK_IMAGE = "lock";
    public static final String MANIFEST_IMAGE = "manifest";
    public static final String PACKAGE_EXPLORER_IMAGE = "package-explorer";
    public static final String POLL_IMAGE = "poll";
    public static final String REFRESH_IMAGE = "refresh";
    public static final String SHOW_ALL_BUNDLES_IMAGE = "show-all-bundles";
    public static final String VERTICAL_IMAGE = "vertical";
    private static final String ICONS = "resources/icons/";
    private static final String IMAGE_EXTENSION = ".gif";
    private IImageManager imageManager;

    public static Activator getDefault() {
        return INSTANCE;
    }

    public Activator() {
        INSTANCE = this;
    }

    private IImageManager basicGetImageManager() {
        return this.imageManager;
    }

    private IImageManager createImageManager() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IImageManager imageManager = utility.createImageManager(101);
        return imageManager;
    }

    private void disposeImageManager() {
        IImageManager imageManager = this.basicGetImageManager();
        if (imageManager == null) {
            return;
        }
        imageManager.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String name) {
        Activator activator = this;
        synchronized (activator) {
            IImageManager imageManager = this.getImageManager();
            Image image = imageManager.getImage(name);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDescriptor getImageDescriptor(String name) {
        Activator activator = this;
        synchronized (activator) {
            IImageManager imageManager = this.getImageManager();
            ImageDescriptor descriptor = imageManager.getImageDescriptor(name);
            return descriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImageManager getImageManager() {
        Activator activator = this;
        synchronized (activator) {
            IImageManager manager = this.basicGetImageManager();
            if (manager == null) {
                this.initializeImageManager();
            }
        }
        return this.imageManager;
    }

    public URL getInstallUrl() {
        Bundle bundle = this.getBundle();
        URL url = bundle.getEntry("/");
        return url;
    }

    private String getSymbolicName() {
        Bundle bundle = this.getBundle();
        String name = bundle.getSymbolicName();
        return name;
    }

    private void initializeImageManager() {
        IImageManager manager = this.createImageManager();
        this.setImageManager(manager);
        this.populateImageManager();
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable throwable) {
        String id = this.getSymbolicName();
        Status status = new Status(severity, id, 0, message, throwable);
        ILog log = this.getLog();
        log.log((IStatus)status);
    }

    private void populateImageManager() {
        IImageManager imageManager = this.getImageManager();
        URL installUrl = this.getInstallUrl();
        try {
            imageManager.add(BUNDLE_ACTIVE_IMAGE, new URL(installUrl, "resources/icons/bundle-active.gif"));
            imageManager.add(BUNDLE_INSTALLED_IMAGE, new URL(installUrl, "resources/icons/bundle-installed.gif"));
            imageManager.add(BUNDLE_EXPORTER_IMAGE, new URL(installUrl, "resources/icons/bundle-exporter.gif"));
            imageManager.add(BUNDLE_IMPORTER_IMAGE, new URL(installUrl, "resources/icons/bundle-importer.gif"));
            imageManager.add(BUNDLE_IMPORTER_EXPORTER_IMAGE, new URL(installUrl, "resources/icons/bundle-importer-exporter.gif"));
            imageManager.add(BUNDLE_RESOLVED_IMAGE, new URL(installUrl, "resources/icons/bundle-resolved.gif"));
            imageManager.add(CONFIGURE_IMAGE, new URL(installUrl, "resources/icons/configure.gif"));
            imageManager.add(COPY_IMAGE, new URL(installUrl, "resources/icons/copy.gif"));
            imageManager.add(HORIZONTAL_IMAGE, new URL(installUrl, "resources/icons/horizontal.gif"));
            imageManager.add(LOCK_IMAGE, new URL(installUrl, "resources/icons/lock.gif"));
            imageManager.add(MANIFEST_IMAGE, new URL(installUrl, "resources/icons/manifest.gif"));
            imageManager.add(POLL_IMAGE, new URL(installUrl, "resources/icons/poll.gif"));
            imageManager.add(PACKAGE_EXPLORER_IMAGE, new URL(installUrl, "resources/icons/package-explorer.gif"));
            imageManager.add(REFRESH_IMAGE, new URL(installUrl, "resources/icons/refresh.gif"));
            imageManager.add(SHOW_ALL_BUNDLES_IMAGE, new URL(installUrl, "resources/icons/show-all-bundles.gif"));
            imageManager.add(VERTICAL_IMAGE, new URL(installUrl, "resources/icons/vertical.gif"));
        }
        catch (MalformedURLException exception) {
            String message = Messages.getString(FAILED_TO_CREATE_URL_KEY);
            this.log(4, message, exception);
        }
    }

    private void setImageManager(IImageManager imageManager) {
        this.imageManager = imageManager;
    }

    public void stop(BundleContext context) throws Exception {
        this.disposeImageManager();
        INSTANCE = null;
        super.stop(context);
    }
}

